/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.rest.Binder;
import org.jclouds.rest.binders.BindException;
import org.jclouds.xml.XMLParser;

@Singleton
public class BindToXMLPayload
implements Binder {
    protected final XMLParser xmlParser;

    @Inject
    public BindToXMLPayload(XMLParser xmlParser) {
        this.xmlParser = (XMLParser)Preconditions.checkNotNull((Object)xmlParser, (Object)"xmlParser");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        try {
            String xml = this.xmlParser.toXML(Preconditions.checkNotNull((Object)input, (Object)"input"));
            request.setPayload(xml);
            MutableContentMetadata metadata = request.getPayload().getContentMetadata();
            if (BindToXMLPayload.contentTypeMustBeAdded(metadata)) {
                metadata.setContentType("application/xml");
            }
            return request;
        }
        catch (IOException ex) {
            throw new BindException(request, (Throwable)ex);
        }
    }

    private static boolean contentTypeMustBeAdded(MutableContentMetadata metadata) {
        return Strings.isNullOrEmpty((String)metadata.getContentType()) || metadata.getContentType().equals("application/unknown");
    }
}

