/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.suppliers;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.util.Throwables2;

public class SetAndThrowAuthorizationExceptionSupplier<T>
implements Supplier<T> {
    private final Supplier<T> delegate;
    private final AtomicReference<AuthorizationException> authException;

    public SetAndThrowAuthorizationExceptionSupplier(Supplier<T> delegate, AtomicReference<AuthorizationException> authException) {
        this.delegate = (Supplier)Preconditions.checkNotNull(delegate, (Object)"delegate");
        this.authException = (AtomicReference)Preconditions.checkNotNull(authException, (Object)"authException");
    }

    public T get() {
        if (this.authException.get() != null) {
            throw this.authException.get();
        }
        try {
            return (T)this.delegate.get();
        }
        catch (AuthorizationException e) {
            this.authException.set(e);
            throw e;
        }
        catch (Exception e) {
            AuthorizationException aex = Throwables2.getFirstThrowableOfType(e, AuthorizationException.class);
            if (aex != null) {
                this.authException.set(aex);
                throw aex;
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String toString() {
        return "RetryOnTimeOutButNotOnAuthorizationExceptionSupplier(" + this.delegate + ")";
    }
}

