/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.chef;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.feed.AbstractFeed;
import org.apache.brooklyn.core.feed.PollHandler;
import org.apache.brooklyn.core.feed.Poller;
import org.apache.brooklyn.entity.chef.ChefAttributePollConfig;
import org.apache.brooklyn.entity.chef.KnifeTaskFactory;
import org.apache.brooklyn.feed.ssh.SshPollValue;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChefAttributeFeed
extends AbstractFeed {
    private static final Logger log = LoggerFactory.getLogger(ChefAttributeFeed.class);
    public static final String CHEF_ATTRIBUTE_PREFIX = "chef.attribute.";
    public static final ConfigKey<Set<ChefAttributePollConfig<?>>> POLLS = ConfigKeys.newConfigKey((TypeToken)new TypeToken<Set<ChefAttributePollConfig<?>>>(){}, (String)"polls");
    public static final ConfigKey<String> NODE_NAME = ConfigKeys.newStringConfigKey((String)"nodeName");
    private KnifeTaskFactory<String> knifeTaskFactory;

    public static Builder builder() {
        return new Builder();
    }

    public ChefAttributeFeed() {
    }

    protected ChefAttributeFeed(Builder builder) {
        this.config().set(ONLY_IF_SERVICE_UP, (Object)builder.onlyIfServiceUp);
        this.config().set(NODE_NAME, Preconditions.checkNotNull((Object)builder.nodeName, (Object)"builder.nodeName"));
        LinkedHashSet polls = Sets.newLinkedHashSet();
        for (ChefAttributePollConfig config : builder.polls) {
            if (!config.isEnabled()) continue;
            ChefAttributePollConfig configCopy = new ChefAttributePollConfig(config);
            if (configCopy.getPeriod() < 0L) {
                configCopy.period(builder.period);
            }
            polls.add(configCopy);
        }
        this.config().set(POLLS, (Object)polls);
        this.initUniqueTag(builder.uniqueTag, new Object[]{polls});
    }

    protected void preStart() {
        final String nodeName = (String)this.getConfig(NODE_NAME);
        Set polls = (Set)this.getConfig(POLLS);
        long minPeriod = Integer.MAX_VALUE;
        for (ChefAttributePollConfig config : polls) {
            minPeriod = Math.min(minPeriod, config.getPeriod());
        }
        this.knifeTaskFactory = new KnifeNodeAttributeQueryTaskFactory(nodeName);
        Callable<SshPollValue> getAttributesFromKnife = new Callable<SshPollValue>(){

            @Override
            public SshPollValue call() throws Exception {
                ProcessTaskWrapper taskWrapper = ChefAttributeFeed.this.knifeTaskFactory.newTask();
                ExecutionContext executionContext = ((EntityInternal)ChefAttributeFeed.this.entity).getExecutionContext();
                log.debug("START: Running knife to query attributes of Chef node {}", (Object)nodeName);
                executionContext.submit(taskWrapper);
                taskWrapper.block();
                log.debug("DONE:  Running knife to query attributes of Chef node {}", (Object)nodeName);
                return new SshPollValue(null, taskWrapper.getExitCode().intValue(), taskWrapper.getStdout(), taskWrapper.getStderr());
            }
        };
        this.getPoller().scheduleAtFixedRate(new CallInEntityExecutionContext((Entity)this.entity, getAttributesFromKnife), (PollHandler)new SendChefAttributesToSensors((Entity)this.entity, polls), minPeriod);
    }

    protected Poller<SshPollValue> getPoller() {
        return super.getPoller();
    }

    private static class SendChefAttributesToSensors
    implements PollHandler<SshPollValue> {
        private static final Iterable<String> PREFIXES = ImmutableList.of((Object)"", (Object)"automatic", (Object)"force_override", (Object)"override", (Object)"normal", (Object)"force_default", (Object)"default");
        private static final Splitter SPLITTER = Splitter.on((char)'.');
        private final Entity entity;
        private final Map<String, AttributeSensor<?>> chefAttributeSensors;

        public SendChefAttributesToSensors(Entity entity, Set<ChefAttributePollConfig<?>> polls) {
            this.entity = entity;
            this.chefAttributeSensors = Maps.newLinkedHashMap();
            for (ChefAttributePollConfig<?> config : polls) {
                this.chefAttributeSensors.put(config.getChefAttributePath(), config.getSensor());
            }
        }

        public boolean checkSuccess(SshPollValue val) {
            if (val.getExitStatus() != 0) {
                return false;
            }
            String stderr = val.getStderr();
            if (stderr == null || stderr.length() != 0) {
                return false;
            }
            String out = val.getStdout();
            if (out == null || out.length() == 0) {
                return false;
            }
            return out.contains("{");
        }

        public void onSuccess(SshPollValue val) {
            String stdout = val.getStdout();
            int jsonStarts = stdout.indexOf(123);
            if (jsonStarts > 0) {
                stdout = stdout.substring(jsonStarts);
            }
            JsonElement jsonElement = (JsonElement)new Gson().fromJson(stdout, JsonElement.class);
            for (Map.Entry<String, AttributeSensor<?>> attribute : this.chefAttributeSensors.entrySet()) {
                String chefAttributeName = attribute.getKey();
                AttributeSensor<?> sensor = attribute.getValue();
                log.trace("Finding value for attribute sensor " + sensor.getName());
                Iterable path = SPLITTER.split((CharSequence)chefAttributeName);
                JsonElement elementForSensor = null;
                for (String prefix : PREFIXES) {
                    Iterable prefixedPath = !Strings.isNullOrEmpty((String)prefix) ? Iterables.concat((Iterable)ImmutableList.of((Object)prefix), (Iterable)path) : path;
                    try {
                        elementForSensor = this.getElementByPath((JsonElement)jsonElement.getAsJsonObject(), prefixedPath);
                    }
                    catch (IllegalArgumentException e) {
                        log.error("Entity {}: bad Chef attribute {} for sensor {}: {}", new Object[]{this.entity.getDisplayName(), Joiner.on((char)'.').join(prefixedPath), sensor.getName(), e.getMessage()});
                        throw Throwables.propagate((Throwable)e);
                    }
                    if (elementForSensor == null) continue;
                    log.debug("Entity {}: apply Chef attribute {} to sensor {} with value {}", new Object[]{this.entity.getDisplayName(), Joiner.on((char)'.').join(prefixedPath), sensor.getName(), elementForSensor.getAsString()});
                    break;
                }
                if (elementForSensor != null) {
                    this.entity.sensors().set(sensor, TypeCoercions.coerce((Object)elementForSensor.getAsString(), (TypeToken)sensor.getTypeToken()));
                    continue;
                }
                log.debug("Entity {}: no Chef attribute matching {}; setting sensor {} to null", new Object[]{this.entity.getDisplayName(), chefAttributeName, sensor.getName()});
                this.entity.sensors().set(sensor, null);
            }
        }

        private JsonElement getElementByPath(JsonElement element, Iterable<String> path) {
            if (Iterables.isEmpty(path)) {
                return element;
            }
            String head = (String)Iterables.getFirst(path, null);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)head) ? 1 : 0) != 0, (Object)"path must not contain empty or null elements");
            Iterable tail = Iterables.skip(path, (int)1);
            JsonElement child = ((JsonObject)element).get(head);
            return child != null ? this.getElementByPath(child, tail) : null;
        }

        public void onFailure(SshPollValue val) {
            log.error("Chef attribute query did not respond as expected. exitcode={} stdout={} stderr={}", new Object[]{val.getExitStatus(), val.getStdout(), val.getStderr()});
            for (AttributeSensor<?> attribute : this.chefAttributeSensors.values()) {
                if (!attribute.getName().startsWith(ChefAttributeFeed.CHEF_ATTRIBUTE_PREFIX)) continue;
                this.entity.sensors().set(attribute, null);
            }
        }

        public void onException(Exception exception) {
            log.error("Detected exception while retrieving Chef attributes from entity " + this.entity.getDisplayName(), (Throwable)exception);
            for (AttributeSensor<?> attribute : this.chefAttributeSensors.values()) {
                if (!attribute.getName().startsWith(ChefAttributeFeed.CHEF_ATTRIBUTE_PREFIX)) continue;
                this.entity.sensors().set(attribute, null);
            }
        }

        public String toString() {
            return super.toString() + "[" + this.getDescription() + "]";
        }

        public String getDescription() {
            return "" + this.chefAttributeSensors;
        }
    }

    private static class CallInEntityExecutionContext<T>
    implements Callable<T> {
        private final Callable<T> job;
        private Entity entity;

        private CallInEntityExecutionContext(Entity entity, Callable<T> job) {
            this.job = job;
            this.entity = entity;
        }

        @Override
        public T call() throws Exception {
            ExecutionContext executionContext = ((EntityInternal)this.entity).getExecutionContext();
            return (T)executionContext.submit((Map)Maps.newHashMap(), this.job).get();
        }
    }

    private static class KnifeNodeAttributeQueryTaskFactory
    extends KnifeTaskFactory<String> {
        private final String nodeName;

        public KnifeNodeAttributeQueryTaskFactory(String nodeName) {
            super("retrieve attributes of node " + nodeName);
            this.nodeName = nodeName;
        }

        @Override
        protected List<String> initialKnifeParameters() {
            return ImmutableList.of((Object)"node", (Object)"show", (Object)"-l", (Object)this.nodeName, (Object)"--format", (Object)"json");
        }
    }

    public static class Builder {
        private Entity entity;
        private boolean onlyIfServiceUp = false;
        private String nodeName;
        private Set<ChefAttributePollConfig> polls = Sets.newLinkedHashSet();
        private Duration period = Duration.of((long)30L, (TimeUnit)TimeUnit.SECONDS);
        private String uniqueTag;
        private volatile boolean built;

        public Builder entity(Entity val) {
            this.entity = (Entity)Preconditions.checkNotNull((Object)val, (Object)"entity");
            return this;
        }

        public Builder onlyIfServiceUp() {
            return this.onlyIfServiceUp(true);
        }

        public Builder onlyIfServiceUp(boolean onlyIfServiceUp) {
            this.onlyIfServiceUp = onlyIfServiceUp;
            return this;
        }

        public Builder nodeName(String nodeName) {
            this.nodeName = (String)Preconditions.checkNotNull((Object)nodeName, (Object)"nodeName");
            return this;
        }

        public Builder addSensor(ChefAttributePollConfig config) {
            this.polls.add(config);
            return this;
        }

        public Builder addSensor(String chefAttributePath, AttributeSensor sensor) {
            return this.addSensor(new ChefAttributePollConfig(sensor).chefAttributePath(chefAttributePath));
        }

        public Builder addSensors(Map<String, AttributeSensor> sensors) {
            for (Map.Entry<String, AttributeSensor> entry : sensors.entrySet()) {
                this.addSensor(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder addSensors(AttributeSensor[] sensors) {
            return this.addSensors(Arrays.asList((Object[])Preconditions.checkNotNull((Object)sensors, (Object)"sensors")));
        }

        public Builder addSensors(Iterable<AttributeSensor> sensors) {
            for (AttributeSensor sensor : (Iterable)Preconditions.checkNotNull(sensors, (Object)"sensors")) {
                Preconditions.checkNotNull((Object)sensor, (Object)"sensors collection contains a null value");
                Preconditions.checkArgument((boolean)sensor.getName().startsWith(ChefAttributeFeed.CHEF_ATTRIBUTE_PREFIX), (Object)"sensor name must be prefixed chef.attribute. for autodetection to work");
                this.addSensor(sensor.getName().substring(ChefAttributeFeed.CHEF_ATTRIBUTE_PREFIX.length()), sensor);
            }
            return this;
        }

        public Builder period(Duration period) {
            this.period = period;
            return this;
        }

        public Builder period(long millis) {
            return this.period(Duration.of((long)millis, (TimeUnit)TimeUnit.MILLISECONDS));
        }

        public Builder period(long val, TimeUnit units) {
            return this.period(Duration.of((long)val, (TimeUnit)units));
        }

        public Builder uniqueTag(String uniqueTag) {
            this.uniqueTag = uniqueTag;
            return this;
        }

        public ChefAttributeFeed build() {
            this.built = true;
            return (ChefAttributeFeed)AbstractFeed.initAndMaybeStart((AbstractFeed)new ChefAttributeFeed(this), (Entity)this.entity);
        }

        protected void finalize() {
            if (!this.built) {
                log.warn("SshFeed.Builder created, but build() never called");
            }
        }
    }
}

