/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.dns.geoscaling;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.location.geo.HostGeoInfo;
import org.apache.brooklyn.entity.dns.AbstractGeoDnsServiceImpl;
import org.apache.brooklyn.entity.dns.geoscaling.GeoscalingDnsService;
import org.apache.brooklyn.entity.dns.geoscaling.GeoscalingScriptGenerator;
import org.apache.brooklyn.entity.dns.geoscaling.GeoscalingWebClient;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.http.HttpTool;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoscalingDnsServiceImpl
extends AbstractGeoDnsServiceImpl
implements GeoscalingDnsService {
    private static final Logger log = LoggerFactory.getLogger(GeoscalingDnsServiceImpl.class);
    private Set<HostGeoInfo> rememberedTargetHosts;
    private GeoscalingWebClient webClient;
    private boolean randomizeSmartSubdomainName;
    private String username;
    private String password;
    private String primaryDomainName;
    private String smartSubdomainName;
    boolean isConfigured = false;

    @Override
    public void init() {
        Boolean trustAll;
        super.init();
        if (this.config().get(RANDOMIZE_SUBDOMAIN_NAME) == null) {
            this.config().set(RANDOMIZE_SUBDOMAIN_NAME, (Object)true);
        }
        this.webClient = Boolean.TRUE.equals(trustAll = (Boolean)this.config().get(SSL_TRUST_ALL)) ? new GeoscalingWebClient(HttpTool.httpClientBuilder().trustAll().build()) : new GeoscalingWebClient();
    }

    @Override
    public void onManagementStarted() {
        super.onManagementStarted();
        try {
            this.applyConfig();
        }
        catch (Exception e) {
            log.error("Geoscaling did not come up correctly: " + e, (Throwable)e);
            ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)Lifecycle.ON_FIRE);
        }
    }

    @Override
    public synchronized void applyConfig() {
        this.randomizeSmartSubdomainName = Boolean.TRUE.equals(this.config().get(RANDOMIZE_SUBDOMAIN_NAME));
        this.username = (String)this.config().get(GEOSCALING_USERNAME);
        this.password = (String)this.config().get(GEOSCALING_PASSWORD);
        this.primaryDomainName = (String)this.config().get(GEOSCALING_PRIMARY_DOMAIN_NAME);
        this.smartSubdomainName = (String)this.config().get(GEOSCALING_SMART_SUBDOMAIN_NAME);
        Preconditions.checkNotNull((Object)this.username, (Object)"The GeoScaling username is not specified");
        Preconditions.checkNotNull((Object)this.password, (Object)"The GeoScaling password is not specified");
        Preconditions.checkNotNull((Object)this.primaryDomainName, (Object)"The GeoScaling primary domain name is not specified");
        if (this.randomizeSmartSubdomainName) {
            this.smartSubdomainName = this.smartSubdomainName != null ? this.smartSubdomainName + "-" : "";
            this.smartSubdomainName = this.smartSubdomainName + Identifiers.makeRandomId((int)8);
        }
        Preconditions.checkNotNull((Object)this.smartSubdomainName, (Object)"The GeoScaling smart subdomain name is not specified or randomized");
        String fullDomain = this.smartSubdomainName + "." + this.primaryDomainName;
        log.info("GeoScaling service will configure redirection for '" + fullDomain + "' domain");
        this.sensors().set(GEOSCALING_ACCOUNT, (Object)this.username);
        this.sensors().set(MANAGED_DOMAIN, (Object)fullDomain);
        this.sensors().set(HOSTNAME, (Object)this.getHostname());
        this.isConfigured = true;
        if (this.rememberedTargetHosts != null) {
            this.reconfigureService(this.rememberedTargetHosts);
            this.rememberedTargetHosts = null;
        }
    }

    @Override
    public String getHostname() {
        String result = (String)this.getAttribute(MANAGED_DOMAIN);
        return Strings.isBlank((CharSequence)result) ? null : result;
    }

    @Override
    public long getTimeToLiveSeconds() {
        return 300L;
    }

    @Override
    public void destroy() {
        this.setServiceState(Lifecycle.STOPPING);
        if (!this.isConfigured) {
            return;
        }
        if (this.randomizeSmartSubdomainName) {
            GeoscalingWebClient.SmartSubdomain smartSubdomain;
            this.webClient.login(this.username, this.password);
            GeoscalingWebClient.Domain primaryDomain = this.webClient.getPrimaryDomain(this.primaryDomainName);
            GeoscalingWebClient.SmartSubdomain smartSubdomain2 = smartSubdomain = primaryDomain != null ? primaryDomain.getSmartSubdomain(this.smartSubdomainName) : null;
            if (smartSubdomain != null) {
                log.info("Deleting randomized GeoScaling smart subdomain '" + this.smartSubdomainName + "." + this.primaryDomainName + "'");
                smartSubdomain.delete();
            }
            this.webClient.logout();
        }
        super.destroy();
        this.isConfigured = false;
    }

    @Override
    protected void reconfigureService(Collection<HostGeoInfo> targetHosts) {
        if (!this.isConfigured) {
            this.rememberedTargetHosts = MutableSet.copyOf(targetHosts);
            return;
        }
        this.webClient.login(this.username, this.password);
        GeoscalingWebClient.Domain primaryDomain = this.webClient.getPrimaryDomain(this.primaryDomainName);
        if (primaryDomain == null) {
            throw new NullPointerException(this + " got null from web client for primary domain " + this.primaryDomainName);
        }
        GeoscalingWebClient.SmartSubdomain smartSubdomain = primaryDomain.getSmartSubdomain(this.smartSubdomainName);
        if (smartSubdomain == null) {
            log.info("GeoScaling {} smart subdomain '{}.{}' does not exist, creating it now", new Object[]{this, this.smartSubdomainName, this.primaryDomainName});
            primaryDomain.createSmartSubdomain(this.smartSubdomainName);
            smartSubdomain = primaryDomain.getSmartSubdomain(this.smartSubdomainName);
        }
        if (smartSubdomain != null) {
            log.debug("GeoScaling {} being reconfigured to use {}", (Object)this, targetHosts);
            String script = GeoscalingScriptGenerator.generateScriptString(targetHosts);
            smartSubdomain.configure(2L, script);
            if (targetHosts.isEmpty()) {
                this.setServiceState(Lifecycle.CREATED);
                this.sensors().set(ROOT_URL, null);
                this.sensors().set(MAIN_URI, null);
            } else {
                this.setServiceState(Lifecycle.RUNNING);
                String domain = (String)this.getAttribute(MANAGED_DOMAIN);
                if (!Strings.isEmpty((CharSequence)domain)) {
                    this.sensors().set(ROOT_URL, (Object)("http://" + domain + "/"));
                    this.sensors().set(MAIN_URI, (Object)URI.create("http://" + domain + "/"));
                }
            }
        } else {
            log.warn("Failed to retrieve or create GeoScaling smart subdomain '" + this.smartSubdomainName + "." + this.primaryDomainName + "', aborting attempt to configure service");
            this.setServiceState(Lifecycle.ON_FIRE);
        }
        this.webClient.logout();
    }
}

