/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.api;

import com.google.common.annotations.Beta;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.rest.domain.CatalogEnricherSummary;
import org.apache.brooklyn.rest.domain.CatalogEntitySummary;
import org.apache.brooklyn.rest.domain.CatalogItemSummary;
import org.apache.brooklyn.rest.domain.CatalogLocationSummary;
import org.apache.brooklyn.rest.domain.CatalogPolicySummary;

@Path(value="/catalog")
@Api(value="Catalog (deprecated; use Catalog Types endpoint)", hidden=true)
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Deprecated
public interface CatalogApi {
    @Deprecated
    @Consumes(value={"application/deprecated-yaml-old"})
    @POST
    @ApiOperation(value="(deprecated)", hidden=true, response=String.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response create(String var1, @ApiParam(name="forceUpdate", value="Force update of catalog item (overwriting existing catalog items with same name and version)") @QueryParam(value="forceUpdate") @DefaultValue(value="false") boolean var2);

    @Deprecated
    @POST
    @Consumes(value={"application/deprecated-yaml"})
    @ApiOperation(value="(deprecated)", hidden=true, response=String.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response createFromYaml(@ApiParam(name="yaml", value="YAML descriptor of catalog item", required=true) @Valid String var1, @ApiParam(name="forceUpdate", value="Force update of catalog item (overwriting existing catalog items with same name and version)") @QueryParam(value="forceUpdate") @DefaultValue(value="false") boolean var2);

    @Deprecated
    @POST
    @Consumes(value={"application/deprecated-x-zip"})
    @ApiOperation(value="(deprecated)", hidden=true, response=String.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response createFromArchive(@ApiParam(name="archive", value="Bundle to install, in ZIP or JAR format, requiring catalog.bom containing bundle name and version", required=true) byte[] var1, @ApiParam(name="detail", value="Provide a wrapping details map", required=false) @QueryParam(value="detail") @DefaultValue(value="false") boolean var2, @ApiParam(name="forceUpdate", value="Force update of catalog item (overwriting existing catalog items with same name and version)") @QueryParam(value="forceUpdate") @DefaultValue(value="false") boolean var3);

    @Deprecated
    @POST
    @Consumes(value={"application/deprecated-autodetect"})
    @ApiOperation(value="(deprecated)", hidden=true, response=String.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    @Beta
    public Response createFromUpload(@ApiParam(name="item", value="Item to install, as JAR/ZIP or Catalog YAML (autodetected)", required=true) byte[] var1, @ApiParam(name="forceUpdate", value="Force update of catalog item (overwriting existing catalog items with same name and version)") @QueryParam(value="forceUpdate") @DefaultValue(value="false") boolean var2);

    @Deprecated
    @POST
    @Consumes
    @ApiOperation(value="Add a bundle of types (entities, etc) to the type registry (deprecated, use /catalog/bundles endpoint instead)", notes="This will auto-detect the format, with the 'brooklyn-bom-bundle' being common and consisting of a ZIP/JAR containing a catalog.bom. Return value is map of ID to CatalogItemSummary unless detail=true is passed as a parameter in which case the return value is a BundleInstallationRestResult map containing the types map in types along with a message, bundle, and code.", response=String.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=201, message="Catalog items added successfully"), @ApiResponse(code=400, message="Error processing the given archive, or the catalog.bom is invalid"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    @Beta
    public Response create(@ApiParam(name="bundle", value="Bundle contents to install, eg for brooklyn-catalog-bundle a ZIP or JAR containing a catalog.bom file (deprecated, use /catalog/bundles endpoint instead)", required=true) byte[] var1, @ApiParam(name="format", value="Specify the format to indicate a specific resolver for handling this", required=false) @QueryParam(value="format") @DefaultValue(value="") String var2, @ApiParam(name="detail", value="Provide a wrapping details map (false for backwards compatibility, but true is recommended for migration to bundle API)", required=false) @QueryParam(value="detail") @DefaultValue(value="false") boolean var3, @ApiParam(name="itemDetails", value="Include legacy item details in the map of types (true for backwards compatibility, but false is recommended for migration to bundle API)", required=false) @QueryParam(value="itemDetails") @DefaultValue(value="true") boolean var4, @ApiParam(name="forceUpdate", value="Force update of catalog item (overwriting existing catalog items with same name and version)") @QueryParam(value="forceUpdate") @DefaultValue(value="false") boolean var5);

    @Deprecated
    @DELETE
    @Path(value="/applications/{symbolicName}/{version}")
    @ApiOperation(value="Deletes a specific version of an application's definition from the catalog (deprecated, use /catalog/bundles endpoint instead)", notes="Version must exists, otherwise the API will return a 404. Alternatively, passing 'latest' willpick up the latest version for the given 'symbolicName'")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public void deleteApplication(@ApiParam(name="symbolicName", value="The symbolic name of the application or template to delete", required=true) @PathParam(value="symbolicName") String var1, @ApiParam(name="version", value="The version identifier of the application or template to delete", required=true) @PathParam(value="version") String var2) throws Exception;

    @Deprecated
    @DELETE
    @Path(value="/entities/{symbolicName}/{version}")
    @ApiOperation(value="Deletes a specific version of an entity's definition from the catalog (deprecated, use /catalog/bundles endpoint instead, as we add/delete bundles now)", notes="Version must exists, otherwise the API will return a 404. Alternatively, passing 'latest' willpick up the latest version for the given 'symbolicName'")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public void deleteEntity(@ApiParam(name="symbolicName", value="The symbolic name of the entity or template to delete", required=true) @PathParam(value="symbolicName") String var1, @ApiParam(name="version", value="The version identifier of the entity or template to delete", required=true) @PathParam(value="version") String var2) throws Exception;

    @Deprecated
    @DELETE
    @Path(value="/policies/{policyId}/{version}")
    @ApiOperation(value="Deletes a specific version of an policy's definition from the catalog (deprecated, use /catalog/bundles endpoint instead, as we add/delete bundles now)", notes="Version must exists, otherwise the API will return a 404. Alternatively, passing 'latest' willpick up the latest version for the given 'policyId'")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public void deletePolicy(@ApiParam(name="policyId", value="The ID of the policy to delete", required=true) @PathParam(value="policyId") String var1, @ApiParam(name="version", value="The version identifier of the policy to delete", required=true) @PathParam(value="version") String var2) throws Exception;

    @Deprecated
    @DELETE
    @Path(value="/locations/{locationId}/{version}")
    @ApiOperation(value="Deletes a specific version of an location's definition from the catalog (deprecated, use /catalog/bundles endpoint instead, as we add/delete bundles now)", notes="Version must exists, otherwise the API will return a 404. Alternatively, passing 'latest' willpick up the latest version for the given 'locationId'")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public void deleteLocation(@ApiParam(name="locationId", value="The ID of the location to delete", required=true) @PathParam(value="locationId") String var1, @ApiParam(name="version", value="The version identifier of the location to delete", required=true) @PathParam(value="version") String var2) throws Exception;

    @Deprecated
    @GET
    @Path(value="/entities")
    @ApiOperation(value="List available entity types optionally matching a query  (deprecated, use /catalog/types endpoint instead, with supertype=entity)", response=CatalogItemSummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<CatalogEntitySummary> listEntities(@ApiParam(name="regex", value="Regular expression to search for") @QueryParam(value="regex") @DefaultValue(value="") String var1, @ApiParam(name="fragment", value="Substring case-insensitive to search for") @QueryParam(value="fragment") @DefaultValue(value="") String var2, @ApiParam(name="allVersions", value="Include all versions (defaults false, only returning the best version)") @QueryParam(value="allVersions") @DefaultValue(value="false") boolean var3);

    @Deprecated
    @GET
    @Path(value="/applications")
    @ApiOperation(value="Fetch a list of templates (for applications) optionally matching a query (deprecated, use /catalog/types endpoint instead, with supertype=application; note some semantics of templates are changing as definition becomes more precise)", response=CatalogItemSummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<CatalogItemSummary> listApplications(@ApiParam(name="regex", value="Regular expression to search for") @QueryParam(value="regex") @DefaultValue(value="") String var1, @ApiParam(name="fragment", value="Substring case-insensitive to search for") @QueryParam(value="fragment") @DefaultValue(value="") String var2, @ApiParam(name="allVersions", value="Include all versions (defaults false, only returning the best version)") @QueryParam(value="allVersions") @DefaultValue(value="false") boolean var3);

    @Deprecated
    @GET
    @Path(value="/entities/{symbolicName}/{version}")
    @ApiOperation(value="Fetch a specific version of an entity's definition from the catalog (deprecated, use /catalog/types endpoint instead)", notes="Version must exists, otherwise the API will return a 404. Alternatively, passing 'latest' willpick up the latest version for the given 'symbolicName'", response=CatalogEntitySummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public CatalogEntitySummary getEntity(@ApiParam(name="symbolicName", value="The symbolic name of the entity or template to retrieve", required=true) @PathParam(value="symbolicName") String var1, @ApiParam(name="version", value="The version identifier of the entity or template to retrieve", required=true) @PathParam(value="version") String var2) throws Exception;

    @Deprecated
    @GET
    @Path(value="/applications/{symbolicName}/{version}")
    @ApiOperation(value="Fetch a specific version of an application's definition from the catalog (deprecated, use /catalog/types endpoint instead)", notes="Version must exists, otherwise the API will return a 404. Alternatively, passing 'latest' willpick up the latest version for the given 'symbolicName'", response=CatalogEntitySummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public CatalogEntitySummary getApplication(@ApiParam(name="symbolicName", value="The symbolic name of the application to retrieve", required=true) @PathParam(value="symbolicName") String var1, @ApiParam(name="version", value="The version identifier of the application to retrieve", required=true) @PathParam(value="version") String var2) throws Exception;

    @Deprecated
    @GET
    @Path(value="/policies")
    @ApiOperation(value="List available policies optionally matching a query (deprecated, use /catalog/types endpoint instead)", response=CatalogPolicySummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<CatalogPolicySummary> listPolicies(@ApiParam(name="regex", value="Regular expression to search for") @QueryParam(value="regex") @DefaultValue(value="") String var1, @ApiParam(name="fragment", value="Substring case-insensitive to search for") @QueryParam(value="fragment") @DefaultValue(value="") String var2, @ApiParam(name="allVersions", value="Include all versions (defaults false, only returning the best version)") @QueryParam(value="allVersions") @DefaultValue(value="false") boolean var3);

    @Deprecated
    @GET
    @Path(value="/policies/{policyId}/{version}")
    @ApiOperation(value="Fetch a policy's definition from the catalog (deprecated, use /catalog/types endpoint instead)", notes="Version must exists, otherwise the API will return a 404. Alternatively, passing 'latest' willpick up the latest version for the given 'policyId'", response=CatalogItemSummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public CatalogPolicySummary getPolicy(@ApiParam(name="policyId", value="The ID of the policy to retrieve", required=true) @PathParam(value="policyId") String var1, @ApiParam(name="version", value="The version identifier of the application to retrieve", required=true) @PathParam(value="version") String var2) throws Exception;

    @Deprecated
    @GET
    @Path(value="/locations")
    @ApiOperation(value="List available locations optionally matching a query (deprecated, use /catalog/types endpoint instead)", response=CatalogLocationSummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<CatalogLocationSummary> listLocations(@ApiParam(name="regex", value="Regular expression to search for") @QueryParam(value="regex") @DefaultValue(value="") String var1, @ApiParam(name="fragment", value="Substring case-insensitive to search for") @QueryParam(value="fragment") @DefaultValue(value="") String var2, @ApiParam(name="allVersions", value="Include all versions (defaults false, only returning the best version)") @QueryParam(value="allVersions") @DefaultValue(value="false") boolean var3);

    @Deprecated
    @GET
    @Path(value="/locations/{locationId}/{version}")
    @ApiOperation(value="Fetch a location's definition from the catalog (deprecated, use /catalog/types endpoint instead)", notes="Version must exists, otherwise the API will return a 404. Alternatively, passing 'latest' willpick up the latest version for the given 'locationId'", response=CatalogItemSummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public CatalogItemSummary getLocation(@ApiParam(name="locationId", value="The ID of the location to retrieve", required=true) @PathParam(value="locationId") String var1, @ApiParam(name="version", value="The version identifier of the application to retrieve", required=true) @PathParam(value="version") String var2) throws Exception;

    @Deprecated
    @GET
    @Path(value="/icon/{itemId}/{version}")
    @ApiOperation(value="Return the icon for a given catalog entry (application/image or HTTP redirect) (deprecated, use /catalog/types/.../icon endpoint instead)", notes="Version must exists, otherwise the API will return a 404. Alternatively, passing 'latest' willpick up the latest version for the given 'itemId'")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    @Produces(value={"application/image"})
    public Response getIcon(@ApiParam(name="itemId", value="ID of catalog item (application, entity, policy, location)", required=true) @PathParam(value="itemId") String var1, @ApiParam(name="version", value="version identifier of catalog item (application, entity, policy, location)", required=true) @PathParam(value="version") String var2);

    @Deprecated
    @POST
    @Consumes(value={"application/json", "application/octet-stream", "text/plain"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    @ApiOperation(value="Deprecate an item (deprecated, use /catalog/types endpoint instead, but disabled/deprecating is not supported for individual types)")
    @Path(value="/entities/{itemId}/deprecated")
    public void setDeprecated(@ApiParam(name="itemId", value="The ID of the catalog item to be deprecated", required=true) @PathParam(value="itemId") String var1, @ApiParam(name="deprecated", value="Whether or not the catalog item is deprecated", required=true) boolean var2);

    @Deprecated
    @POST
    @Consumes(value={"application/json", "application/octet-stream", "text/plain"})
    @ApiOperation(value="Disable an item (deprecated, use /catalog/types endpoint instead, but disabled/deprecating is not supported for individual types)")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    @Path(value="/entities/{itemId}/disabled")
    public void setDisabled(@ApiParam(name="itemId", value="The ID of the catalog item to be disabled", required=true) @PathParam(value="itemId") String var1, @ApiParam(name="disabled", value="Whether or not the catalog item is disabled", required=true) boolean var2);

    @Deprecated
    @GET
    @Path(value="/enrichers")
    @ApiOperation(value="List available enrichers types optionally matching a query (deprecated, use /catalog/types endpoint instead)", response=CatalogItemSummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Application or entity missing"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<CatalogEnricherSummary> listEnrichers(@ApiParam(name="regex", value="Regular expression to search for") @QueryParam(value="regex") @DefaultValue(value="") String var1, @ApiParam(name="fragment", value="Substring case-insensitive to search for") @QueryParam(value="fragment") @DefaultValue(value="") String var2, @ApiParam(name="allVersions", value="Include all versions (defaults false, only returning the best version)") @QueryParam(value="allVersions") @DefaultValue(value="false") boolean var3);

    @Deprecated
    @GET
    @Path(value="/enrichers/{enricherId}/{version}")
    @ApiOperation(value="Fetch an enricher's definition from the catalog (deprecated, use /catalog/types endpoint instead)", response=CatalogItemSummary.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Enricher not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public CatalogEnricherSummary getEnricher(@ApiParam(name="enricherId", value="The ID of the enricher to retrieve", required=true) @PathParam(value="enricherId") String var1, @ApiParam(name="version", value="The version identifier of the enricher to retrieve", required=true) @PathParam(value="version") String var2) throws Exception;

    @Deprecated
    @DELETE
    @Path(value="/enrichers/{enricherId}/{version}")
    @ApiOperation(value="Deletes a specific version of an enricher's definition from the catalog (deprecated, use /catalog/types endpoint instead)")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Enricher not found"), @ApiResponse(code=500, message="Internal Server Error")})
    public void deleteEnricher(@ApiParam(name="enricherId", value="The ID of the enricher to delete", required=true) @PathParam(value="enricherId") String var1, @ApiParam(name="version", value="The version identifier of the enricher to delete", required=true) @PathParam(value="version") String var2) throws Exception;
}

