/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.docker.compute.functions.LoginPortForContainer;
import org.jclouds.docker.domain.Container;
import org.jclouds.docker.domain.NetworkSettings;
import org.jclouds.docker.domain.Node;
import org.jclouds.docker.domain.State;
import org.jclouds.domain.Location;
import org.jclouds.providers.ProviderMetadata;

@Singleton
public class ContainerToNodeMetadata
implements Function<Container, NodeMetadata> {
    private static final Integer NO_LOGIN_PORT = -1;
    private final ProviderMetadata providerMetadata;
    private final Function<State, NodeMetadata.Status> toPortableStatus;
    private final GroupNamingConvention nodeNamingConvention;
    private final Supplier<Map<String, ? extends Image>> images;
    private final Supplier<Set<? extends Location>> locations;
    private final LoginPortForContainer loginPortForContainer;

    @Inject
    ContainerToNodeMetadata(ProviderMetadata providerMetadata, Function<State, NodeMetadata.Status> toPortableStatus, GroupNamingConvention.Factory namingConvention, Supplier<Map<String, ? extends Image>> images, @Memoized Supplier<Set<? extends Location>> locations, LoginPortForContainer loginPortForContainer) {
        this.providerMetadata = providerMetadata;
        this.toPortableStatus = toPortableStatus;
        this.nodeNamingConvention = namingConvention.createWithoutPrefix();
        this.images = images;
        this.locations = locations;
        this.loginPortForContainer = loginPortForContainer;
    }

    public NodeMetadata apply(Container container) {
        String name = this.cleanUpName(container.name());
        String group = this.nodeNamingConvention.extractGroup(name);
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(container.id()).name(name).group(group).hostname(container.config().hostname()).hardware(new HardwareBuilder().id("").ram(container.config().memory()).processor(new Processor((double)container.config().cpuShares(), (double)container.config().cpuShares())).build());
        builder.status((NodeMetadata.Status)this.toPortableStatus.apply((Object)container.state()));
        builder.loginPort(((Integer)((Optional)this.loginPortForContainer.apply(container)).or((Object)NO_LOGIN_PORT)).intValue());
        builder.publicAddresses(this.getPublicIpAddresses(container));
        builder.privateAddresses(this.getPrivateIpAddresses(container));
        builder.location((Location)Iterables.getOnlyElement((Iterable)((Iterable)this.locations.get())));
        String imageId = container.image();
        builder.imageId(imageId);
        if (((Map)this.images.get()).containsKey(imageId)) {
            Image image = (Image)((Map)this.images.get()).get(imageId);
            builder.operatingSystem(image.getOperatingSystem());
        }
        return builder.build();
    }

    private String cleanUpName(String name) {
        return name.startsWith("/") ? name.substring(1) : name;
    }

    private Iterable<String> getPrivateIpAddresses(Container container) {
        if (container.networkSettings() == null) {
            return ImmutableList.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        NetworkSettings settings = container.networkSettings();
        if (settings.ipAddress() != null && settings.ipAddress().length() > 0) {
            builder.add((Object)settings.ipAddress());
        }
        if (settings.networks() != null) {
            for (Map.Entry<String, NetworkSettings.Details> entry : settings.networks().entrySet()) {
                String ipAddress = entry.getValue().ipAddress();
                if (ipAddress == null || ipAddress.length() <= 0) continue;
                builder.add((Object)ipAddress);
            }
        }
        return builder.build();
    }

    private List<String> getPublicIpAddresses(Container container) {
        String dockerIpAddress = container.node().isPresent() ? ((Node)container.node().get()).ip() : URI.create(this.providerMetadata.getEndpoint()).getHost();
        return ImmutableList.of((Object)dockerIpAddress);
    }
}

