/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.suppliers;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jclouds.docker.suppliers.SSLContextBuilder;
import org.jclouds.domain.Credentials;
import org.jclouds.http.config.SSLModule;
import org.jclouds.location.Provider;

@Singleton
public class DockerUntrustedSSLContextSupplier
implements Supplier<SSLContext> {
    private final Supplier<Credentials> creds;
    private final SSLModule.TrustAllCerts insecureTrustManager;

    @Inject
    DockerUntrustedSSLContextSupplier(@Provider Supplier<Credentials> creds, SSLModule.TrustAllCerts insecureTrustManager) {
        this.creds = creds;
        this.insecureTrustManager = insecureTrustManager;
    }

    public SSLContext get() {
        Credentials currentCreds = (Credentials)Preconditions.checkNotNull((Object)((Credentials)this.creds.get()), (Object)"credential supplier returned null");
        try {
            SSLContextBuilder builder = new SSLContextBuilder();
            if (SSLContextBuilder.isClientKeyAndCertificateData(currentCreds.credential, currentCreds.identity)) {
                builder.clientKeyAndCertificateData(currentCreds.credential, currentCreds.identity);
            } else if (new File(currentCreds.identity).isFile() && new File(currentCreds.credential).isFile()) {
                builder.clientKeyAndCertificatePaths(currentCreds.credential, currentCreds.identity);
            }
            builder.trustManager((TrustManager)this.insecureTrustManager);
            return builder.build();
        }
        catch (GeneralSecurityException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

