/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.options;

import java.net.URI;
import java.util.List;
import org.jclouds.googlecomputeengine.domain.BackendService;
import org.jclouds.googlecomputeengine.options.AutoValue_BackendServiceOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class BackendServiceOptions {
    @Nullable
    public abstract String name();

    @Nullable
    public abstract String description();

    @Nullable
    public abstract List<URI> healthChecks();

    @Nullable
    public abstract List<BackendService.Backend> backends();

    @Nullable
    public abstract Integer timeoutSec();

    @Nullable
    public abstract Integer port();

    @Nullable
    public abstract String protocol();

    @Nullable
    public abstract String fingerprint();

    @Nullable
    public abstract String portName();

    @SerializedNames(value={"name", "description", "healthChecks", "backends", "timeoutSec", "port", "protocol", "fingerprint", "portName"})
    static BackendServiceOptions create(String name, String description, List<URI> healthChecks, List<BackendService.Backend> backends, Integer timeoutSec, Integer port, String protocol, String fingerprint, String portName) {
        return new AutoValue_BackendServiceOptions(name, description, healthChecks, backends, timeoutSec, port, protocol, fingerprint, portName);
    }

    BackendServiceOptions() {
    }

    public static class Builder {
        private String name;
        private String description;
        private List<URI> healthChecks;
        private List<BackendService.Backend> backends;
        private Integer timeoutSec;
        private Integer port;
        private String protocol;
        private String fingerprint;
        private String portName;

        public Builder(String name, List<URI> healthChecks) {
            this.name = name;
            this.healthChecks = healthChecks;
        }

        public Builder() {
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder healthChecks(List<URI> healthChecks) {
            this.healthChecks = healthChecks;
            return this;
        }

        public Builder backends(List<BackendService.Backend> backends) {
            this.backends = backends;
            return this;
        }

        public Builder timeoutSec(Integer timeoutSec) {
            this.timeoutSec = timeoutSec;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public Builder portName(String portName) {
            this.portName = portName;
            return this;
        }

        public BackendServiceOptions build() {
            return BackendServiceOptions.create(this.name, this.description, this.healthChecks, this.backends, this.timeoutSec, this.port, this.protocol, this.fingerprint, this.portName);
        }
    }
}

