/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.network.bind;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.entity.network.bind.BindDnsServer;
import org.apache.brooklyn.entity.network.bind.BindDnsServerDriver;
import org.apache.brooklyn.entity.network.bind.BindDnsServerImpl;
import org.apache.brooklyn.entity.network.bind.BindOsSupport;
import org.apache.brooklyn.entity.software.base.AbstractSoftwareProcessSshDriver;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.net.Protocol;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.ssh.BashCommands;
import org.apache.brooklyn.util.ssh.BashCommandsConfigurable;
import org.apache.brooklyn.util.ssh.IptablesCommandsConfigurable;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindDnsServerSshDriver
extends AbstractSoftwareProcessSshDriver
implements BindDnsServerDriver {
    private static final Logger LOG = LoggerFactory.getLogger(BindDnsServerSshDriver.class);
    private volatile BindOsSupport osSupport;
    private final Object osSupportMutex = new Object();

    public BindDnsServerSshDriver(BindDnsServerImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
    }

    public BindDnsServerImpl getEntity() {
        return (BindDnsServerImpl)super.getEntity();
    }

    public void install() {
        ImmutableList commands = ImmutableList.builder().add((Object)BashCommands.installPackage((Map)MutableMap.of((Object)"yum", (Object)"bind", (Object)"apt", (Object)"bind9"), (String)"bind")).add((Object)BashCommands.ok((String)("which setenforce && " + BashCommands.sudo((String)"setenforce 0")))).build();
        this.newScript((String)"installing").failOnNonZeroResultCode().body.append((Collection)commands).execute();
    }

    public void customize() {
        Integer dnsPort = this.getEntity().getDnsPort();
        MutableMap ports = MutableMap.of((Object)"dnsPort", (Object)dnsPort);
        Networking.checkPortsValid((Map)ports);
        ArrayList commands = Lists.newArrayList((Object[])new String[]{BashCommands.sudo((String)("mkdir -p " + this.getDataDirectory() + " " + this.getDynamicDirectory() + " " + this.getOsSupport().getConfigDirectory())), BashCommands.sudo((String)("chown -R " + this.getOsSupport().getUser() + ":" + this.getOsSupport().getUser() + " " + this.getDataDirectory() + " " + this.getDynamicDirectory())), new IptablesCommandsConfigurable(BashCommandsConfigurable.newInstance()).insertIptablesRule(IptablesCommandsConfigurable.Chain.INPUT, "eth0", Protocol.UDP, dnsPort.intValue(), IptablesCommandsConfigurable.Policy.ACCEPT), new IptablesCommandsConfigurable(BashCommandsConfigurable.newInstance()).insertIptablesRule(IptablesCommandsConfigurable.Chain.INPUT, "eth0", Protocol.TCP, dnsPort.intValue(), IptablesCommandsConfigurable.Policy.ACCEPT), BashCommands.sudo((String)"service iptables save"), BashCommands.sudo((String)"service iptables restart")});
        if (((Boolean)this.getEntity().getConfig(BindDnsServer.UPDATE_ROOT_ZONES_FILE)).booleanValue()) {
            commands.add("curl --user=ftp:ftp ftp://ftp.rs.internic.net/domain/db.cache -o " + this.getOsSupport().getRootZonesFile());
        }
        this.newScript((String)"customizing").body.append((Collection)commands).execute();
        this.copyAsRoot("classpath://org/apache/brooklyn/entity/network/bind/rfc1912.zone", this.getRfc1912ZonesFile());
        this.copyAsRoot("classpath://org/apache/brooklyn/entity/network/bind/named.localhost", Os.mergePathsUnix((String[])new String[]{this.getOsSupport().getConfigDirectory(), "named.localhost"}));
        this.copyAsRoot("classpath://org/apache/brooklyn/entity/network/bind/named.loopback", Os.mergePathsUnix((String[])new String[]{this.getOsSupport().getConfigDirectory(), "named.loopback"}));
        this.copyAsRoot("classpath://org/apache/brooklyn/entity/network/bind/named.empty", Os.mergePathsUnix((String[])new String[]{this.getOsSupport().getConfigDirectory(), "named.empty"}));
        this.newScript((String)"Checking BIND configuration").body.append((CharSequence)BashCommands.sudo((String)"named-checkconf")).failOnNonZeroResultCode().execute();
    }

    public void launch() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").body.append((CharSequence)BashCommands.sudo((String)("service " + this.getOsSupport().getServiceName() + " start"))).execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"check-running").body.append((CharSequence)BashCommands.sudo((String)("service " + this.getOsSupport().getServiceName() + " status"))).execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").body.append((CharSequence)BashCommands.sudo((String)("service " + this.getOsSupport().getServiceName() + " stop"))).execute();
    }

    @Override
    public void updateBindConfiguration() {
        LOG.debug("Updating bind configuration at " + this.getMachine());
        this.copyAsRoot((String)this.entity.getConfig(BindDnsServer.NAMED_CONF_TEMPLATE), this.getOsSupport().getRootConfigFile());
        this.copyAsRoot((String)this.entity.getConfig(BindDnsServer.DOMAIN_ZONE_FILE_TEMPLATE), this.getDomainZoneFile());
        this.copyAsRoot((String)this.entity.getConfig(BindDnsServer.REVERSE_ZONE_FILE_TEMPLATE), this.getReverseZoneFile());
        int result = this.getMachine().execScript("restart bind", (List)ImmutableList.of((Object)BashCommands.sudo((String)("service " + this.getOsSupport().getServiceName() + " restart"))));
        LOG.info("Updated named configuration and zone file for '{}' on {} (exit code {}).", new Object[]{this.entity.getConfig(BindDnsServer.DOMAIN_NAME), this.entity, result});
    }

    private void copyAsRoot(String template, String destination) {
        String content = this.processTemplate(template);
        String temp = "/tmp/template-" + Strings.makeRandomId((int)6);
        this.getMachine().copyTo((InputStream)new ByteArrayInputStream(content.getBytes()), temp);
        this.getMachine().execScript("copying file", (List)ImmutableList.of((Object)BashCommands.sudo((String)String.format("mv %s %s", temp, destination))));
    }

    public String getDomainZoneFile() {
        return Os.mergePaths((String[])new String[]{this.getOsSupport().getConfigDirectory(), "domain.zone"});
    }

    public String getReverseZoneFile() {
        return Os.mergePaths((String[])new String[]{this.getOsSupport().getConfigDirectory(), "reverse.zone"});
    }

    public String getDataDirectory() {
        return Os.mergePaths((String[])new String[]{this.getOsSupport().getWorkingDirectory(), "data"});
    }

    public String getDynamicDirectory() {
        return Os.mergePaths((String[])new String[]{this.getOsSupport().getWorkingDirectory(), "dynamic"});
    }

    public String getRfc1912ZonesFile() {
        return Os.mergePaths((String[])new String[]{this.getOsSupport().getConfigDirectory(), "rfc1912.zone"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BindOsSupport getOsSupport() {
        BindOsSupport result = this.osSupport;
        if (result == null) {
            Object object = this.osSupportMutex;
            synchronized (object) {
                result = this.osSupport;
                if (result == null) {
                    boolean yumExists = this.newScript((String)"testing for yum").body.append((CharSequence)BashCommands.requireExecutable((String)"yum")).execute() == 0;
                    result = yumExists ? BindOsSupport.forRhel() : BindOsSupport.forDebian();
                    this.osSupport = result;
                }
            }
        }
        return result;
    }
}

