/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.task;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Callables;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.mgmt.HasTaskChildren;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.task.ScheduledTask;
import org.apache.brooklyn.util.core.task.TaskInternal;
import org.apache.brooklyn.util.core.task.TaskInternalCancellableWithMode;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.javalang.StackTraceSimplifier;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTask<T>
implements TaskInternal<T> {
    private static final Logger log = LoggerFactory.getLogger(BasicTask.class);
    private String id = Identifiers.makeRandomId((int)8);
    protected Callable<T> job;
    public final String displayName;
    public final String description;
    protected final Set<Object> tags = Sets.newConcurrentHashSet();
    protected Task<?> proxyTargetTask = null;
    protected String blockingDetails = null;
    protected Task<?> blockingTask = null;
    Object extraStatusText = null;
    protected final ExecutionList listeners = new ExecutionList();
    protected long queuedTimeUtc = -1L;
    protected long submitTimeUtc = -1L;
    protected long startTimeUtc = -1L;
    protected long endTimeUtc = -1L;
    protected Maybe<Task<?>> submittedByTask;
    protected String submittedByTaskId;
    protected volatile Thread thread = null;
    protected volatile boolean cancelled = false;
    protected volatile Future<T> internalFuture = null;
    private transient String loggedLongStack = null;
    public static final TaskFinalizer WARN_IF_NOT_RUN = new TaskFinalizer(){

        @Override
        public void onTaskFinalization(Task<?> t) {
            if (!Tasks.isAncestorCancelled(t) && !t.isSubmitted()) {
                boolean skipWarning = false;
                skipWarning |= t instanceof ScheduledTask && ((ScheduledTask)t).getNextScheduled() != null;
                skipWarning |= t instanceof TaskInternal && ((TaskInternal)t).getQueuedTimeUtc() > 0L;
                if (!(skipWarning |= BrooklynTaskTags.hasTag(t, "WORKFLOW"))) {
                    log.warn(t + " was never submitted; did the code create it and forget to run it? ('cancel' the task to suppress this message)");
                    log.debug("Detail of unsubmitted task " + t + ":\n" + t.getStatusDetail(true));
                    return;
                }
            }
            if (!t.isDone()) {
                if (!BrooklynTaskTags.getExecutionContext(t).isShutdown()) {
                    log.warn("Task " + t + " was submitted but forgotten before it was run (finalized before completion)");
                }
                return;
            }
        }
    };
    public static final TaskFinalizer NO_OP = new TaskFinalizer(){

        @Override
        public void onTaskFinalization(Task<?> t) {
        }
    };

    @Deprecated
    protected BasicTask() {
        this(Collections.emptyMap());
    }

    protected BasicTask(Map<?, ?> flags) {
        this(flags, (Callable)null);
    }

    public BasicTask(Callable<T> job) {
        this(Collections.emptyMap(), job);
    }

    public BasicTask(Map<?, ?> flags, Callable<T> job) {
        Object ftags;
        this.job = job;
        if (flags.containsKey("tag")) {
            this.tags.add(flags.remove("tag"));
        }
        if ((ftags = flags.remove("tags")) != null) {
            if (ftags instanceof Iterable) {
                Iterables.addAll(this.tags, (Iterable)((Iterable)ftags));
            } else {
                log.info("deprecated use of non-collection argument for 'tags' (" + ftags + ") in " + this, new Throwable("trace of discouraged use of non-collection tags argument"));
                this.tags.add(ftags);
            }
        }
        this.description = JavaGroovyEquivalents.elvisString(flags.remove("description"), (Object)"");
        String d = JavaGroovyEquivalents.asString(flags.remove("displayName"));
        this.displayName = d == null ? "" : d;
    }

    public BasicTask(Runnable job) {
        this(JavaGroovyEquivalents.toCallable((Runnable)job));
    }

    public BasicTask(Map<?, ?> flags, Runnable job) {
        this(flags, JavaGroovyEquivalents.toCallable((Runnable)job));
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (obj instanceof Task) {
            return ((Task)obj).getId().equals(this.getId());
        }
        return false;
    }

    public String toString() {
        return "Task[" + (Strings.isNonEmpty((CharSequence)this.displayName) ? this.displayName : this.job + (this.tags != null && !this.tags.isEmpty() ? ";" + this.tags : "")) + "]@" + this.getId();
    }

    public Task<T> asTask() {
        return this;
    }

    @Override
    public synchronized void initInternalFuture(ListenableFuture<T> result) {
        if (this.internalFuture != null) {
            throw new IllegalStateException("task " + this + " is being given a result twice");
        }
        this.internalFuture = result;
        this.notifyAll();
    }

    public Set<Object> getTags() {
        return Collections.unmodifiableSet(new LinkedHashSet<Object>(this.tags));
    }

    @Override
    public long getQueuedTimeUtc() {
        return this.queuedTimeUtc;
    }

    public long getSubmitTimeUtc() {
        return this.submitTimeUtc;
    }

    public long getStartTimeUtc() {
        return this.startTimeUtc;
    }

    public long getEndTimeUtc() {
        return this.endTimeUtc;
    }

    @Override
    public Future<T> getInternalFuture() {
        return this.internalFuture;
    }

    public Task<?> getSubmittedByTask() {
        if (this.submittedByTask == null) {
            return null;
        }
        return (Task)this.submittedByTask.orNull();
    }

    public String getSubmittedByTaskId() {
        if (this.submittedByTaskId != null) {
            return this.submittedByTaskId;
        }
        if (this.submittedByTask == null || this.submittedByTask.isAbsent()) {
            return null;
        }
        throw new IllegalStateException("Task was set up with a submitted task but no task ID");
    }

    public Thread getThread() {
        return this.thread;
    }

    @Override
    public boolean isQueued() {
        return this.queuedTimeUtc >= 0L;
    }

    @Override
    public boolean isQueuedOrSubmitted() {
        return this.isQueued() || this.isSubmitted();
    }

    @Override
    public boolean isQueuedAndNotSubmitted() {
        return this.isQueued() && !this.isSubmitted();
    }

    public boolean isSubmitted() {
        return this.submitTimeUtc >= 0L;
    }

    public boolean isBegun() {
        return this.startTimeUtc >= 0L;
    }

    @Override
    public void markQueued() {
        if (this.queuedTimeUtc < 0L) {
            this.queuedTimeUtc = System.currentTimeMillis();
        }
    }

    @Override
    public final synchronized boolean cancel() {
        return this.cancel(true);
    }

    @Beta
    public synchronized boolean uncancel() {
        boolean wasCancelled = this.cancelled;
        this.cancelled = false;
        return wasCancelled;
    }

    public final synchronized boolean cancel(boolean mayInterruptIfRunning) {
        return this.cancel(mayInterruptIfRunning ? TaskInternal.TaskCancellationMode.INTERRUPT_TASK_AND_DEPENDENT_SUBMITTED_TASKS : TaskInternal.TaskCancellationMode.DO_NOT_INTERRUPT);
    }

    @Override
    @Beta
    public synchronized boolean cancel(TaskInternal.TaskCancellationMode mode) {
        if (this.isDone(true)) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("BT cancelling " + this + " mode " + mode + ", from thread " + Thread.currentThread());
        }
        this.cancelled = true;
        this.doCancel(mode);
        this.notifyAll();
        return true;
    }

    protected boolean doCancel(TaskInternal.TaskCancellationMode mode) {
        if (this.internalFuture != null) {
            if (this.internalFuture instanceof TaskInternalCancellableWithMode) {
                return ((TaskInternalCancellableWithMode)((Object)this.internalFuture)).cancel(mode);
            }
            return this.internalFuture.cancel(mode.isAllowedToInterruptTask());
        }
        return true;
    }

    public boolean isCancelled() {
        return this.cancelled || this.internalFuture != null && this.internalFuture.isCancelled();
    }

    public boolean isDone(boolean andTaskNotRunning) {
        if (!(this.cancelled || this.internalFuture != null && this.internalFuture.isDone() || this.endTimeUtc > 0L)) {
            return false;
        }
        return !andTaskNotRunning || !this.cancelled || !this.isBegun() || this.endTimeUtc > 0L;
    }

    public boolean isDone() {
        return this.isDone(false);
    }

    public boolean isError() {
        if (!this.isDone()) {
            return false;
        }
        if (this.isCancelled()) {
            return true;
        }
        try {
            this.get();
            return false;
        }
        catch (Throwable t) {
            return true;
        }
    }

    public T get() throws InterruptedException, ExecutionException {
        try {
            if (!this.isDone()) {
                Tasks.setBlockingTask(this);
            }
            this.blockUntilStarted();
            T t = this.internalFuture.get();
            return t;
        }
        finally {
            Tasks.resetBlockingTask();
        }
    }

    public T getUnchecked() {
        try {
            return this.get();
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public synchronized void blockUntilStarted() {
        this.blockUntilStarted(null);
    }

    @Override
    public synchronized boolean blockUntilStarted(Duration timeout) {
        Long endTime;
        Long l = endTime = timeout == null ? null : Long.valueOf(System.currentTimeMillis() + timeout.toMillisecondsRoundingUp());
        do {
            if (this.cancelled) {
                throw new CancellationException();
            }
            if (this.startTimeUtc > 0L) {
                return true;
            }
            if (this.internalFuture != null) continue;
            try {
                if (timeout == null) {
                    this.wait(5000L);
                    continue;
                }
                long remaining = endTime - System.currentTimeMillis();
                if (remaining > 0L) {
                    this.wait(remaining);
                    continue;
                }
                return false;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Throwables.propagate((Throwable)e);
            }
        } while (this.internalFuture == null);
        return true;
    }

    public void blockUntilEnded() {
        this.blockUntilEnded(null);
    }

    public boolean blockUntilEnded(Duration timeout) {
        return this.blockUntilEnded(timeout, false);
    }

    public boolean blockUntilEnded(Duration timeout, boolean andTaskNotRunning) {
        Long endTime = timeout == null ? null : Long.valueOf(System.currentTimeMillis() + timeout.toMillisecondsRoundingUp());
        try {
            while (true) {
                block15: {
                    try {
                        boolean started = this.blockUntilStarted(timeout);
                        if (!started) {
                            return false;
                        }
                    }
                    catch (CancellationException cancelled) {
                        if (!this.isDone(andTaskNotRunning)) break block15;
                        return true;
                    }
                }
                if (timeout == null) {
                    this.internalFuture.get();
                } else {
                    long remaining = endTime - System.currentTimeMillis();
                    try {
                        if (remaining > 0L) {
                            this.internalFuture.get(remaining, TimeUnit.MILLISECONDS);
                        }
                    }
                    catch (CancellationException | TimeoutException exception) {
                        // empty catch block
                    }
                    remaining = endTime - System.currentTimeMillis();
                    if (remaining <= 0L) {
                        return this.isDone(andTaskNotRunning);
                    }
                }
                if (this.isDone(andTaskNotRunning)) {
                    return true;
                }
                Thread.yield();
                if (this.isDone(andTaskNotRunning)) {
                    return true;
                }
                Time.sleep((long)20L);
            }
        }
        catch (Throwable t) {
            Exceptions.propagateIfFatal((Throwable)t);
            if (!(t instanceof TimeoutException) && log.isDebugEnabled()) {
                log.debug("call from " + Thread.currentThread() + ", blocking until '" + this + "' finishes, ended with error: " + t);
            }
            return this.isDone(andTaskNotRunning);
        }
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get(new Duration(timeout, unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(Duration duration) throws InterruptedException, ExecutionException, TimeoutException {
        Long remaining;
        Long end;
        long start = System.currentTimeMillis();
        Long l = end = duration == null ? null : Long.valueOf(start + duration.toMillisecondsRoundingUp());
        while (end == null || end > System.currentTimeMillis()) {
            if (this.cancelled) {
                throw new CancellationException();
            }
            if (this.internalFuture == null) {
                BasicTask basicTask = this;
                synchronized (basicTask) {
                    long remaining2;
                    long l2 = remaining2 = end == null ? 100L : end - System.currentTimeMillis();
                    if (this.internalFuture == null && remaining2 > 0L) {
                        this.wait(remaining2);
                    }
                }
            }
            if (this.internalFuture == null) continue;
        }
        Long l3 = remaining = end == null ? null : Long.valueOf(end - System.currentTimeMillis());
        if (this.isDone()) {
            if (this.internalFuture == null) {
                assert (this.cancelled) : "task=" + this + "; endTimeUtc=" + this.endTimeUtc + "; cancelled=" + this.cancelled + "; isDone=true; null internal future";
                throw new CancellationException();
            }
            if (remaining == null) {
                return this.internalFuture.get();
            }
            return this.internalFuture.get(Math.max(remaining, 1000L), TimeUnit.MILLISECONDS);
        }
        if (remaining == null) {
            return this.internalFuture.get();
        }
        if (remaining > 0L) {
            return this.internalFuture.get(remaining, TimeUnit.MILLISECONDS);
        }
        throw new TimeoutException();
    }

    public T getUnchecked(Duration duration) {
        try {
            return this.get(duration);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public String getStatusSummary() {
        return this.getStatusString(0);
    }

    public String getStatusDetail(boolean multiline) {
        return this.getStatusString(multiline ? 2 : 1);
    }

    protected String getStatusString(int verbosity) {
        StatusStringData data = new StatusStringData();
        if (this.submitTimeUtc <= 0L) {
            data.setSummary("Not submitted");
        } else if (!this.isCancelled() && this.startTimeUtc <= 0L) {
            data.setSummary("Submitted for execution");
            if (verbosity > 0) {
                data.appendToSummary(" " + Time.makeTimeStringRoundedSince((long)this.submitTimeUtc) + " ago");
            }
            if (verbosity >= 2 && this.getExtraStatusText() != null) {
                data.multiLineData.add("" + this.getExtraStatusText());
            }
        } else if (this.isDone()) {
            String duration;
            long elapsed = this.endTimeUtc - this.submitTimeUtc;
            boolean allDone = this.isDone(true);
            String string = elapsed >= 0L ? " after " + Time.makeTimeStringRounded((long)elapsed) : (duration = allDone ? " but no end time" : "");
            if (!allDone) {
                duration = duration + " but not ended";
            }
            if (this.isCancelled()) {
                data.setSummary("Cancelled");
                if (verbosity >= 1) {
                    data.appendToSummary(duration);
                }
                this.computeStatusStringError(verbosity, data);
                this.computeStatusStringActive(verbosity, data);
            } else if (this.isError()) {
                data.setSummary("Failed");
                if (verbosity >= 1) {
                    data.appendToSummary(duration);
                }
                this.computeStatusStringError(verbosity, data);
                this.computeStatusStringActive(verbosity, data);
            } else {
                data.setSummary("Completed");
                if (verbosity >= 1) {
                    Callable<String> valueGetter = () -> {
                        String vs;
                        T v = this.get();
                        if (v == null) {
                            return null;
                        }
                        if (v instanceof String) {
                            if (Strings.isMultiLine((String)((String)v)) || ((String)v).contains(": ") || ((String)v).contains("=")) {
                                return "\n" + Strings.indent((int)2, (String)((String)v));
                            }
                            return (String)v;
                        }
                        if (Boxing.isPrimitiveOrBoxedObject(v)) {
                            return "" + v;
                        }
                        try {
                            vs = BeanWithTypeUtils.newYamlMapper(null, false, null, false).writeValueAsString(v);
                            if (vs.trim().startsWith("---")) {
                                vs = Strings.removeFromStart((String)vs.trim(), (String)"---").trim();
                            }
                        }
                        catch (Exception e) {
                            Exceptions.propagateIfFatal((Throwable)e);
                            vs = v.toString();
                        }
                        return "\n" + Strings.indent((int)2, (String)vs);
                    };
                    if (verbosity == 1) {
                        try {
                            String v = valueGetter.call();
                            data.appendToSummary(", " + (v == null ? "no return value (null)" : "result: " + BasicTask.abbreviate(v)));
                        }
                        catch (Exception e) {
                            data.appendToSummary(", but error accessing result [" + Exceptions.collapseText((Throwable)e) + "]");
                        }
                    } else {
                        if (verbosity >= 1) {
                            data.appendToSummary(duration);
                        }
                        try {
                            String v = valueGetter.call();
                            data.multiLineData.add(v == null ? "No return value (null)" : "Result: " + BasicTask.abbreviate(v, 512, true));
                        }
                        catch (Exception e) {
                            data.appendToSummary(", but error accessing result");
                            data.multiLineData.add("Error accessing result: " + e);
                        }
                    }
                    this.computeStatusStringError(verbosity, data);
                    this.computeStatusStringActive(verbosity, data);
                }
            }
        } else {
            this.computeStatusStringActive(verbosity, data);
        }
        if (Strings.isBlank((CharSequence)data.mainShortSummary)) {
            data.setSummary("Unknown");
        }
        if (verbosity <= 0) {
            return data.mainShortSummary;
        }
        String result = data.mainShortSummary + Strings.join(data.oneLineData, (String)"");
        if (verbosity == 1) {
            return result;
        }
        return MutableList.of((Object)result).appendAll(data.multiLineData).stream().filter(Strings::isNonBlank).map(String::trim).collect(Collectors.joining("\n\n"));
    }

    private static String abbreviate(String s0) {
        return BasicTask.abbreviate(s0, 255, false);
    }

    private static String abbreviate(String s0, int length, boolean allowMultiLine) {
        String s;
        boolean isMultilineToShrink = !allowMultiLine && Strings.isMultiLine((String)s0);
        String string = s = allowMultiLine ? s0 : Strings.getFirstLine((String)s0);
        if (Strings.isBlank((CharSequence)s) && isMultilineToShrink) {
            s = Strings.getFirstLine((String)s0.trim());
        }
        if (s.length() > length) {
            s = s.substring(0, length - 3) + "...";
        } else if (isMultilineToShrink) {
            s = s + " ...";
        }
        return s;
    }

    protected void computeStatusStringActive(int verbosity, StatusStringData data) {
        Thread t = this.getThread();
        boolean done = this.isDone();
        if (t == null) {
            if (done) {
                if (data.mainShortSummary == null) {
                    data.setSummary("Finishing");
                    data.appendToSummary("; just went done, no thread available");
                }
            } else if (data.mainShortSummary == null) {
                data.setSummary("Sleeping");
                data.appendToSummary("; no thread available");
            }
            this.computeStatusStringOptionalDetails(verbosity, data);
            return;
        }
        ThreadInfo ti = ManagementFactory.getThreadMXBean().getThreadInfo(t.getId(), verbosity <= 0 ? 0 : (verbosity == 1 ? 1 : Integer.MAX_VALUE));
        if (this.getThread() == null) {
            data.multiLineData.add("Task thread transitioned to null from " + t);
            this.computeStatusStringOptionalDetails(verbosity, data);
            return;
        }
        if (!done) {
            this.computeStatusStringOptionalDetails(verbosity, data);
            if (Strings.isBlank((CharSequence)data.mainShortSummary)) {
                data.setSummary("In progress");
            }
            this.computeStatusStringError(verbosity, data);
        } else if (data.mainShortSummary == null) {
            data.setSummary("Finishing");
            data.appendToSummary("; just went done");
            this.computeStatusStringOptionalDetails(verbosity, data);
        }
        this.computeStatusStringThreadInfo(verbosity, data, ti);
    }

    protected void computeStatusStringThreadInfo(int verbosity, StatusStringData data, ThreadInfo ti) {
        if (verbosity >= 1) {
            String msg;
            LockInfo lock = ti.getLockInfo();
            if (lock == null && ti.getThreadState() == Thread.State.RUNNABLE) {
                msg = ti.isSuspended() ? "Thread suspended" : (verbosity >= 2 ? "(" + (Object)((Object)ti.getThreadState()) + ")" : null);
            } else {
                msg = "Thread waiting ";
                msg = ti.getThreadState() == Thread.State.BLOCKED ? msg + "(mutex) on " + this.lookup(lock) : (ti.getThreadState() == Thread.State.WAITING ? msg + "(notify) on " + this.lookup(lock) : (ti.getThreadState() == Thread.State.TIMED_WAITING ? msg + "(timed) on " + this.lookup(lock) : msg + "(" + (Object)((Object)ti.getThreadState()) + ") on " + this.lookup(lock)));
            }
            if (msg != null) {
                if (data.hasBlockingDetails) {
                    data.multiLineData.add(msg);
                } else {
                    data.oneLineData.add((msg.startsWith("(") ? "" : ",") + " " + Strings.toInitialLowerCase((String)msg));
                }
            }
            data.hasBlockingDetails = true;
        }
        if (verbosity >= 2) {
            StackTraceElement[] st = ti.getStackTrace();
            if ((st = StackTraceSimplifier.cleanStackTrace((StackTraceElement[])st)) != null && st.length > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("At: " + st[0]);
                for (int ii = 1; ii < st.length; ++ii) {
                    sb.append("\n    " + st[ii]);
                }
                data.multiLineData.add(sb.toString());
            }
        }
    }

    protected void computeStatusStringOptionalDetails(int verbosity, StatusStringData data) {
        String msg;
        if (verbosity < 1) {
            return;
        }
        if (Strings.isNonBlank((CharSequence)this.blockingDetails)) {
            data.hasBlockingDetails = true;
            if (Strings.isBlank((CharSequence)data.mainShortSummary)) {
                data.setSummary(this.blockingDetails);
            } else if (verbosity == 1) {
                data.appendToSummary("; " + this.blockingDetails);
            } else {
                data.multiLineData.add("Waiting: " + this.blockingDetails);
            }
        }
        if (verbosity >= 1 && this.blockingTask != null) {
            msg = "Waiting on: " + this.blockingTask;
            if (Strings.isBlank((CharSequence)data.mainShortSummary)) {
                data.setSummary(msg);
            } else if (verbosity == 1) {
                if (!data.hasBlockingDetails) {
                    data.appendToSummary("; " + Strings.toInitialLowerCase((String)msg));
                }
            } else {
                data.multiLineData.add(msg);
            }
            data.hasBlockingDetails = true;
        }
        if (verbosity >= 2) {
            if (this.getExtraStatusText() != null) {
                data.multiLineData.add("" + this.getExtraStatusText());
            }
            data.multiLineData.add("Known as: " + this.toString());
            if (this.submittedByTask != null && this.submittedByTask.isPresent()) {
                data.multiLineData.add("Submitted by: " + this.submittedByTask.get());
            }
            if (this instanceof HasTaskChildren) {
                msg = "";
                try {
                    Iterable childrenTasks = ((HasTaskChildren)this).getChildren();
                    if (childrenTasks.iterator().hasNext()) {
                        msg = msg + "Children:\n";
                        for (Task child : childrenTasks) {
                            msg = msg + "  " + child + ": " + child.getStatusDetail(false) + "\n";
                        }
                    }
                }
                catch (ConcurrentModificationException exc) {
                    msg = msg + "(children not available - currently being modified)\n";
                }
                if (Strings.isNonBlank((CharSequence)msg)) {
                    data.multiLineData.add(msg);
                }
            }
        }
    }

    protected void computeStatusStringError(int verbosity, StatusStringData data) {
        Throwable error = Tasks.getError(this, false);
        if (error != null && verbosity >= 1) {
            boolean isCancelled;
            while (error instanceof ExecutionException) {
                error = error.getCause();
            }
            String errorMessage = Exceptions.collapseText((Throwable)error);
            boolean bl = isCancelled = this.isCancelled() && error instanceof CancellationException;
            if (!isCancelled) {
                data.oneLineData.add(": " + BasicTask.abbreviate(errorMessage));
            }
            if (verbosity >= 2) {
                if (this.loggedLongStack != null) {
                    data.multiLineData.add(this.loggedLongStack);
                } else {
                    StringWriter sw = new StringWriter();
                    error.printStackTrace(new PrintWriter(sw));
                    String sws = sw.toString();
                    if (!isCancelled || !sws.contains(BasicTask.class.getName() + ".computeStatusStringError")) {
                        if (sws.length() > 16000) {
                            this.loggedLongStack = sws.substring(0, 8000) + "\n  ...\n  ..." + sws.substring(sws.length() - 8000);
                            log.warn("Long stack trace suppressed when reporting status of task " + this.getId() + ":\n" + sws);
                            data.multiLineData.add(this.loggedLongStack);
                        } else {
                            data.multiLineData.add(sws);
                        }
                    }
                }
            }
        }
    }

    protected String lookup(LockInfo info) {
        return info != null ? "" + info : "unknown (sleep)";
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String setBlockingDetails(String blockingDetails) {
        String old = this.blockingDetails;
        this.blockingDetails = blockingDetails;
        return old;
    }

    @Override
    public Task<?> setBlockingTask(Task<?> blockingTask) {
        Task<?> old = this.blockingTask;
        this.blockingTask = blockingTask;
        return old;
    }

    @Override
    public void resetBlockingDetails() {
        this.blockingDetails = null;
    }

    @Override
    public void resetBlockingTask() {
        this.blockingTask = null;
    }

    @Override
    public String getBlockingDetails() {
        return this.blockingDetails;
    }

    @Override
    public Task<?> getBlockingTask() {
        return this.blockingTask;
    }

    @Override
    public void setExtraStatusText(Object extraStatus) {
        this.extraStatusText = extraStatus;
    }

    @Override
    public Object getExtraStatusText() {
        return this.extraStatusText;
    }

    public void ignoreIfNotRun() {
        this.setFinalizer(NO_OP);
    }

    public void setFinalizer(TaskFinalizer f) {
        TaskFinalizer finalizer = Tasks.tag(this, TaskFinalizer.class, false);
        if (finalizer != null && finalizer != f) {
            throw new IllegalStateException("Cannot apply multiple finalizers");
        }
        if (this.isDone()) {
            throw new IllegalStateException("Finalizer cannot be set on task " + this + " after it is finished");
        }
        this.tags.add(f);
    }

    protected void finalize() throws Throwable {
        TaskFinalizer finalizer = Tasks.tag(this, TaskFinalizer.class, false);
        if (finalizer == null) {
            finalizer = WARN_IF_NOT_RUN;
        }
        finalizer.onTaskFinalization(this);
    }

    public void addListener(Runnable listener, Executor executor) {
        this.listeners.add(listener, (Executor)new SubmissionErrorCatchingExecutor(executor));
    }

    @Override
    public void runListeners() {
        this.listeners.execute();
    }

    @Override
    public void setEndTimeUtc(long val) {
        this.endTimeUtc = val;
    }

    @Override
    public void setThread(Thread thread) {
        this.thread = thread;
    }

    @Override
    public Callable<T> getJob() {
        return this.job;
    }

    @Override
    public void setJob(Callable<T> job) {
        this.job = job;
    }

    @Override
    public ExecutionList getListeners() {
        return this.listeners;
    }

    @Override
    public void setSubmitTimeUtc(long val) {
        this.submitTimeUtc = val;
    }

    @Override
    public void setSubmittedByTask(Task<?> task) {
        this.setSubmittedByTask(Maybe.ofDisallowingNull(task), task == null ? null : task.getId());
    }

    @Override
    public void setSubmittedByTask(Maybe<Task<?>> taskM, String taskId) {
        this.submittedByTask = (Maybe)Preconditions.checkNotNull(taskM);
        this.submittedByTaskId = taskId;
    }

    @Override
    public Set<Object> getMutableTags() {
        return this.tags;
    }

    @Override
    public void setStartTimeUtc(long val) {
        this.startTimeUtc = val;
    }

    @Override
    public void applyTagModifier(Function<Set<Object>, Void> modifier) {
        modifier.apply(this.tags);
    }

    @Override
    public Task<?> getProxyTarget() {
        return this.proxyTargetTask;
    }

    public static class PlaceholderTask
    extends BasicTask {
        private PlaceholderTask(Map flags) {
            super(flags);
        }

        public static PlaceholderTask newPlaceholderForForgottenTask(String id, String displayName) {
            PlaceholderTask result = new PlaceholderTask((Map)MutableMap.of((Object)"displayName", (Object)(displayName + " (placeholder)"), (Object)"description", (Object)"Details of the original task have been forgotten."));
            ((BasicTask)result).id = id;
            result.job = Callables.returning(null);
            result.cancelled = true;
            return result;
        }
    }

    public static class SubmissionErrorCatchingExecutor
    implements Executor {
        final Executor target;

        public SubmissionErrorCatchingExecutor(Executor target) {
            this.target = target;
        }

        @Override
        public void execute(Runnable command) {
            if (this.isShutdown()) {
                log.debug("Skipping execution of task callback hook " + command + " because executor is shutdown.");
                return;
            }
            try {
                this.target.execute(command);
            }
            catch (Exception e) {
                if (this.isShutdown()) {
                    log.debug("Ignoring failed execution of task callback hook " + command + " because executor is shutdown.");
                }
                log.warn("Execution of task callback hook " + command + " failed: " + e, (Throwable)e);
            }
        }

        protected boolean isShutdown() {
            return this.target instanceof ExecutorService && ((ExecutorService)this.target).isShutdown();
        }
    }

    public static interface TaskFinalizer {
        public void onTaskFinalization(Task<?> var1);
    }

    protected static class StatusStringData {
        boolean hasBlockingDetails = false;
        String mainShortSummary = null;
        Set<String> oneLineData = MutableSet.of();
        Set<String> multiLineData = MutableSet.of();

        protected StatusStringData() {
        }

        protected void setSummary(String summary) {
            this.mainShortSummary = this.mainShortSummary != null ? this.mainShortSummary + "; and " + summary : summary;
        }

        protected void appendToSummary(String detail) {
            if (Strings.isNonBlank((CharSequence)detail)) {
                this.mainShortSummary = this.mainShortSummary + detail;
            }
        }
    }
}

