/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.domain;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;

public class ResourceLimit {
    private final String account;
    private final String domain;
    private final String domainId;
    private final int max;
    private final ResourceType resourceType;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromResourceLimit(this);
    }

    @ConstructorProperties(value={"account", "domain", "domainid", "max", "resourcetype"})
    protected ResourceLimit(@Nullable String account, @Nullable String domain, @Nullable String domainId, int max, @Nullable ResourceType resourceType) {
        this.account = account;
        this.domain = domain;
        this.domainId = domainId;
        this.max = max;
        this.resourceType = resourceType;
    }

    @Nullable
    public String getAccount() {
        return this.account;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getDomainId() {
        return this.domainId;
    }

    public int getMax() {
        return this.max;
    }

    @Nullable
    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.account, this.domain, this.domainId, this.max, this.resourceType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceLimit that = (ResourceLimit)ResourceLimit.class.cast(obj);
        return Objects.equal((Object)this.account, (Object)that.account) && Objects.equal((Object)this.domain, (Object)that.domain) && Objects.equal((Object)this.domainId, (Object)that.domainId) && Objects.equal((Object)this.max, (Object)that.max) && Objects.equal((Object)((Object)this.resourceType), (Object)((Object)that.resourceType));
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("account", (Object)this.account).add("domain", (Object)this.domain).add("domainId", (Object)this.domainId).add("max", this.max).add("resourceType", (Object)this.resourceType);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String account;
        protected String domain;
        protected String domainId;
        protected int max;
        protected ResourceType resourceType;

        protected abstract T self();

        public T account(String account) {
            this.account = account;
            return this.self();
        }

        public T domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        public T domainId(String domainId) {
            this.domainId = domainId;
            return this.self();
        }

        public T max(int max) {
            this.max = max;
            return this.self();
        }

        public T resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            return this.self();
        }

        public ResourceLimit build() {
            return new ResourceLimit(this.account, this.domain, this.domainId, this.max, this.resourceType);
        }

        public T fromResourceLimit(ResourceLimit in) {
            return ((Builder)((Builder)((Builder)((Builder)this.account(in.getAccount())).domain(in.getDomain())).domainId(in.getDomainId())).max(in.getMax())).resourceType(in.getResourceType());
        }
    }

    public static enum ResourceType {
        INSTANCE(0),
        IP(1),
        VOLUME(2),
        SNAPSHOT(3),
        TEMPLATE(4),
        PROJECT(5),
        NETWORK(6),
        VPC(7),
        CPU(8),
        MEMORY(9),
        PRIMARY_STORAGE(10),
        SECONDARY_STORAGE(11),
        UNRECOGNIZED(Integer.MAX_VALUE);

        private int code;
        private static final Map<Integer, ResourceType> INDEX;

        private ResourceType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public String toString() {
            return this.name();
        }

        public static ResourceType fromValue(String resourceType) {
            Integer code = Integer.valueOf((String)Preconditions.checkNotNull((Object)resourceType, (Object)"resourcetype"));
            return INDEX.containsKey(code) ? INDEX.get(code) : UNRECOGNIZED;
        }

        static {
            INDEX = Maps.uniqueIndex((Iterable)ImmutableSet.copyOf((Object[])ResourceType.values()), (Function)new Function<ResourceType, Integer>(){

                public Integer apply(ResourceType input) {
                    return input.code;
                }
            });
        }
    }
}

