/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.javalang;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableSet;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class StackTraceSimplifier {
    public static final String DEFAULT_BLACKLIST_SYSTEM_PROPERTY_NAME = "org.apache.brooklyn.util.javalang.StackTraceSimplifier.blacklist";
    private static final Collection<String> DEFAULT_BLACKLIST;
    private static final StackTraceSimplifier DEFAULT_INSTACE;
    private final Collection<String> blacklist;

    protected StackTraceSimplifier() {
        this(true, new String[0]);
    }

    protected StackTraceSimplifier(boolean includeDefaultBlacklist, String ... packages) {
        ImmutableSet.Builder blacklistB = ImmutableSet.builder();
        if (includeDefaultBlacklist) {
            blacklistB.addAll(DEFAULT_BLACKLIST);
        }
        blacklistB.add((Object[])packages);
        this.blacklist = blacklistB.build();
    }

    public static StackTraceSimplifier newInstance() {
        return new StackTraceSimplifier();
    }

    public static StackTraceSimplifier newInstance(String ... additionalBlacklistPackagePrefixes) {
        return new StackTraceSimplifier(true, additionalBlacklistPackagePrefixes);
    }

    public static StackTraceSimplifier newInstanceExcludingOnly(String ... blacklistPackagePrefixes) {
        return new StackTraceSimplifier(false, blacklistPackagePrefixes);
    }

    public boolean isUseful(StackTraceElement el) {
        for (String s : this.blacklist) {
            if (el.getClassName().startsWith(s)) {
                return false;
            }
            if (!el.getClassName().replace('_', '.').startsWith(s)) continue;
            return false;
        }
        return true;
    }

    public List<StackTraceElement> clean(Iterable<StackTraceElement> st) {
        LinkedList<StackTraceElement> result = new LinkedList<StackTraceElement>();
        for (StackTraceElement element : st) {
            if (!this.isUseful(element)) continue;
            result.add(element);
        }
        return result;
    }

    public StackTraceElement[] clean(StackTraceElement[] st) {
        List<StackTraceElement> result = this.clean(Arrays.asList(st));
        return result.toArray(new StackTraceElement[result.size()]);
    }

    public StackTraceElement firstUseful(StackTraceElement[] st) {
        return this.nthUseful(0, st);
    }

    public StackTraceElement nthUseful(int n, StackTraceElement[] st) {
        for (StackTraceElement element : st) {
            if (!this.isUseful(element)) continue;
            if (n == 0) {
                return element;
            }
            --n;
        }
        return null;
    }

    public <T extends Throwable> T cleaned(T t) {
        t.setStackTrace(this.clean(t.getStackTrace()));
        return t;
    }

    public static boolean isStackTraceElementUseful(StackTraceElement el) {
        return DEFAULT_INSTACE.isUseful(el);
    }

    public static List<StackTraceElement> cleanStackTrace(Iterable<StackTraceElement> st) {
        return DEFAULT_INSTACE.clean(st);
    }

    public static StackTraceElement[] cleanStackTrace(StackTraceElement[] st) {
        return DEFAULT_INSTACE.clean(st);
    }

    public static <T extends Throwable> T cleanedStackTrace(T t) {
        return DEFAULT_INSTACE.cleaned(t);
    }

    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    @Beta
    public static int getRecursiveCallCount() {
        StackTraceElement[] t = StackTraceSimplifier.cleanStackTrace(new Throwable().getStackTrace());
        Iterator<StackTraceElement> ti = Arrays.asList(t).iterator();
        ti.next();
        if (!ti.hasNext()) {
            return 0;
        }
        StackTraceElement t0 = ti.next();
        String l0 = t0.getClassName() + "." + t0.getMethodName() + "(" + t0.getFileName() + ")";
        int count = 0;
        while (ti.hasNext()) {
            StackTraceElement ta = ti.next();
            String li = ta.getClassName() + "." + ta.getMethodName() + "(" + ta.getFileName() + ")";
            if (!li.equals(l0)) continue;
            ++count;
        }
        return count;
    }

    static {
        ImmutableSet.Builder blacklist = ImmutableSet.builder();
        blacklist.addAll(Arrays.asList(System.getProperty(DEFAULT_BLACKLIST_SYSTEM_PROPERTY_NAME, "java.,javax.,jdk.,sun.,groovy.,org.codehaus.groovy.,gjdk.groovy.,").split("(\\s|,)+")));
        DEFAULT_BLACKLIST = blacklist.build();
        DEFAULT_INSTACE = StackTraceSimplifier.newInstance();
    }
}

