/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.math;

import com.google.common.primitives.Bytes;
import com.google.common.primitives.Ints;
import java.util.Collection;

public class BitUtils {
    public static byte reverseBitSignificance(byte b) {
        return (byte)(Integer.reverse(b) >> 24);
    }

    public static byte reverseBitSignificanceInByte(int b) {
        return BitUtils.reverseBitSignificance((byte)b);
    }

    public static byte[] reverseBitSignificance(byte ... bytes) {
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = BitUtils.reverseBitSignificance(bytes[i]);
        }
        return result;
    }

    public static byte[] reverseBitSignificanceInBytes(int ... bytes) {
        return BitUtils.reverseBitSignificance(Bytes.toArray((Collection)Ints.asList((int[])bytes)));
    }

    public static int unsigned(byte b) {
        return b & 0xFF;
    }

    public static int unsignedByte(int b) {
        return b & 0xFF;
    }
}

