/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.stream;

import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.stream.KnownSizeInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Streams {
    private static final Logger log = LoggerFactory.getLogger(Streams.class);

    @Beta
    public static void closeQuietly(Closeable x) {
        block3: {
            try {
                if (x != null) {
                    x.close();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug("Error closing (ignored) " + x + ": " + e);
            }
        }
    }

    public static InputStream newInputStreamWithContents(String contents) {
        byte[] bytes = ((String)Preconditions.checkNotNull((Object)contents, (Object)"contents")).getBytes(Charsets.UTF_8);
        return KnownSizeInputStream.of(bytes);
    }

    public static Reader newReaderWithContents(String contents) {
        return new StringReader(contents);
    }

    public static Reader reader(InputStream stream) {
        return new InputStreamReader(stream);
    }

    public static Reader reader(InputStream stream, Charset charset) {
        if (charset == null) {
            return new InputStreamReader(stream);
        }
        return new InputStreamReader(stream, charset);
    }

    public static byte[] readFully(InputStream is) {
        try {
            return ByteStreams.toByteArray((InputStream)is);
        }
        catch (IOException ioe) {
            throw Exceptions.propagate(ioe);
        }
    }

    public static int readFully(InputStream s, byte[] buf) throws IOException {
        int count;
        int countHere;
        for (count = 0; count < buf.length; count += countHere) {
            countHere = s.read(buf, count, buf.length - count);
            if (countHere > 0) continue;
            return count;
        }
        return count;
    }

    public static byte[] readFullyAndClose(InputStream is) {
        try {
            byte[] byArray = Streams.readFully(is);
            return byArray;
        }
        finally {
            Streams.closeQuietly(is);
        }
    }

    public static String readFullyString(InputStream is) {
        return Streams.readFully(Streams.reader(is));
    }

    public static String readFullyStringAndClose(InputStream is) {
        return Streams.readFullyStringAndClose(is, null);
    }

    public static String readFullyString(InputStream is, Charset charset) {
        return Streams.readFully(Streams.reader(is, charset));
    }

    public static String readFullyStringAndClose(InputStream is, Charset charset) {
        try {
            String string = Streams.readFullyString(is, charset);
            return string;
        }
        finally {
            Streams.closeQuietly(is);
        }
    }

    public static String readFully(Reader is) {
        try {
            return CharStreams.toString((Readable)is);
        }
        catch (IOException ioe) {
            throw Exceptions.propagate(ioe);
        }
    }

    public static String readFullyAndClose(Reader is) {
        try {
            String string = Streams.readFully(is);
            return string;
        }
        finally {
            Streams.closeQuietly(is);
        }
    }

    public static void copy(InputStream input, OutputStream output) {
        try {
            ByteStreams.copy((InputStream)input, (OutputStream)output);
            output.flush();
        }
        catch (IOException ioe) {
            throw Exceptions.propagate(ioe);
        }
    }

    public static void copyClose(InputStream input, OutputStream output) {
        try {
            Streams.copy(input, output);
        }
        finally {
            Streams.closeQuietly(input);
            Streams.closeQuietly(output);
        }
    }

    public static void copy(Reader input, Writer output) {
        try {
            CharStreams.copy((Readable)input, (Appendable)output);
            output.flush();
        }
        catch (IOException ioe) {
            throw Exceptions.propagate(ioe);
        }
    }

    public static Supplier<Integer> sizeSupplier(final ByteArrayOutputStream src) {
        Preconditions.checkNotNull((Object)src);
        return new Supplier<Integer>(){

            public Integer get() {
                return src.size();
            }
        };
    }

    public static Function<ByteArrayOutputStream, Integer> sizeFunction() {
        return new Function<ByteArrayOutputStream, Integer>(){

            public Integer apply(ByteArrayOutputStream input) {
                return input.size();
            }
        };
    }

    public static ByteArrayOutputStream byteArrayOfString(String in) {
        return Streams.byteArray(in.getBytes(Charsets.UTF_8));
    }

    public static ByteArrayOutputStream byteArray(byte[] in) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            stream.write(in);
        }
        catch (IOException e) {
            throw Exceptions.propagate(e);
        }
        return stream;
    }

    public static boolean logStreamTail(Logger log, String message, ByteArrayOutputStream stream, int max) {
        if (stream != null && stream.size() > 0) {
            String streamS = stream.toString();
            if (max >= 0 && streamS.length() > max) {
                streamS = "... " + streamS.substring(streamS.length() - max);
            }
            log.info(message + ":\n" + streamS);
            return true;
        }
        return false;
    }

    public static String getMd5Checksum(InputStream in) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw Exceptions.propagate(e);
        }
        DigestInputStream dis = new DigestInputStream(in, md);
        Streams.readFullyAndClose(dis);
        byte[] digest = md.digest();
        StringBuilder result = new StringBuilder();
        for (byte b : digest) {
            result.append(Strings.padStart((String)Integer.toHexString((256 + b) % 256), (int)2, (char)'0'));
        }
        return result.toString().toUpperCase();
    }

    public static boolean compare(InputStream s1, InputStream s2) throws IOException {
        try {
            if (s1 == null || s2 == null) {
                boolean bl = s1 == null && s2 == null;
                return bl;
            }
            byte[] buf1 = new byte[4096];
            byte[] buf2 = new byte[4096];
            while (true) {
                int r1 = Streams.readFully(s1, buf1);
                int r2 = Streams.readFully(s2, buf2);
                if (!ByteBuffer.wrap(buf1, 0, r1).equals(ByteBuffer.wrap(buf2, 0, r2))) {
                    boolean bl = false;
                    return bl;
                }
                if (r1 >= 4096) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            Streams.closeQuietly(s1);
            Streams.closeQuietly(s2);
        }
    }
}

