/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.text;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.ByteArrayInputStream;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.Strings;

public class Secret<T>
implements Supplier<T> {
    private final T secret;

    public Secret(T secret) {
        this.secret = secret;
    }

    @Override
    public T get() {
        return this.secret;
    }

    @JsonValue
    public Object getSanitized() {
        if (SecretHelper.permitJacksonSerializationInThisThread.get() != null) {
            return this.secret;
        }
        return SecretHelper.suppress(this.secret);
    }

    @JsonCreator
    static <T> Secret<T> jacksonNotNormallyAllowedToCreate(T possiblySuppressedValue) {
        if (SecretHelper.permitJacksonSerializationInThisThread.get() != null) {
            return new Secret<T>(possiblySuppressedValue);
        }
        if (SecretHelper.isProbablySuppressed(possiblySuppressedValue)) {
            throw new IllegalStateException("Secrets deserialization detected on value which appears suppressed");
        }
        throw new IllegalStateException("Secrets cannot be deserialized from JSON");
    }

    public boolean equals(Object obj) {
        if (obj instanceof Secret) {
            return Objects.equals(this.get(), ((Secret)obj).get());
        }
        return Objects.equals(this.get(), obj);
    }

    public int hashCode() {
        T x = this.get();
        return x == null ? 0 : x.hashCode();
    }

    public String toString() {
        return "Secret[" + SecretHelper.suppress(this.secret) + "]";
    }

    public static class SecretHelper {
        static ThreadLocal<Integer> permitJacksonSerializationInThisThread = new ThreadLocal();

        public static boolean isProbablySuppressed(Object value) {
            return ("" + value).startsWith("<suppressed>");
        }

        public static String suppress(Object value) {
            if (value == null) {
                return null;
            }
            String md5Checksum = Strings.maxlen(Streams.getMd5Checksum(new ByteArrayInputStream(("" + value).getBytes())), 8);
            return "<suppressed> (MD5 hash: " + md5Checksum + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T> T runWithJacksonSerializationEnabledInThread(Callable<T> callable) throws Exception {
            try {
                Integer old = permitJacksonSerializationInThisThread.get();
                if (old == null) {
                    old = 0;
                }
                Integer n = old;
                Integer n2 = old = Integer.valueOf(old + 1);
                permitJacksonSerializationInThisThread.set(old);
                n = callable.call();
                return (T)n;
            }
            finally {
                Integer old;
                Integer n = old = permitJacksonSerializationInThisThread.get();
                Integer n3 = old = Integer.valueOf(old - 1);
                if (old == 0) {
                    permitJacksonSerializationInThisThread.remove();
                } else {
                    permitJacksonSerializationInThisThread.set(old);
                }
            }
        }
    }
}

