/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.transform;

import com.google.common.collect.Iterables;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.UriBuilder;
import org.apache.brooklyn.api.catalog.CatalogConfig;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.api.objs.SpecParameter;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.render.RendererHints;
import org.apache.brooklyn.rest.api.AdjunctApi;
import org.apache.brooklyn.rest.api.EntityConfigApi;
import org.apache.brooklyn.rest.domain.ConfigSummary;
import org.apache.brooklyn.rest.domain.EnricherConfigSummary;
import org.apache.brooklyn.rest.domain.EntityConfigSummary;
import org.apache.brooklyn.rest.domain.PolicyConfigSummary;
import org.apache.brooklyn.rest.transform.AdjunctTransformer;
import org.apache.brooklyn.rest.transform.EntityTransformer;
import org.apache.brooklyn.rest.transform.SensorTransformer;
import org.apache.brooklyn.rest.util.WebResourceUtils;
import org.apache.brooklyn.util.collections.MutableMap;

public class ConfigTransformer {
    private final ConfigKey<?> key;
    UriBuilder ub;
    boolean includeContextLinks;
    boolean includeActionLinks;
    Entity entity;
    EntityAdjunct adjunct;
    String label;
    Double priority;
    Boolean pinned;

    public static ConfigTransformer of(ConfigKey<?> key) {
        return new ConfigTransformer(key);
    }

    public static ConfigTransformer of(SpecParameter<?> param) {
        ConfigTransformer result = ConfigTransformer.of(param.getConfigKey());
        result.label = param.getLabel();
        result.pinned = param.isPinned();
        return result;
    }

    private ConfigTransformer(ConfigKey<?> key) {
        this.key = key;
    }

    public ConfigTransformer on(Entity entity) {
        this.entity = entity;
        return this;
    }

    public ConfigTransformer on(Entity entity, EntityAdjunct adjunct) {
        this.entity = entity;
        this.adjunct = adjunct;
        return this;
    }

    public ConfigTransformer includeLinks(UriBuilder ub, boolean includeContextLinks, boolean includeActionLinks) {
        this.ub = ub;
        this.includeContextLinks = includeContextLinks;
        this.includeActionLinks = includeActionLinks;
        return this;
    }

    public ConfigTransformer uiMetadata(String label, Double priority, Boolean pinned) {
        this.label = label;
        this.priority = priority;
        this.pinned = pinned;
        return this;
    }

    public ConfigTransformer uiMetadata(String label, Boolean pinned) {
        return this.uiMetadata(label, Boolean.TRUE.equals(pinned) ? 1.0 : 0.0, pinned);
    }

    public ConfigTransformer uiIncrementAndSetPriorityIfPinned(AtomicInteger lastPriority) {
        if (Boolean.TRUE.equals(this.pinned)) {
            this.priority = lastPriority.incrementAndGet();
        }
        return this;
    }

    public ConfigTransformer uiMetadata(Field keyField) {
        if (keyField == null) {
            return this;
        }
        return this.uiMetadata(keyField.getDeclaredAnnotation(CatalogConfig.class));
    }

    public ConfigTransformer uiMetadata(CatalogConfig annotation) {
        if (annotation == null) {
            return this;
        }
        return this.uiMetadata(annotation.label(), annotation.priority(), annotation.pinned());
    }

    public ConfigSummary transform() {
        MutableMap.Builder lb = new MutableMap.Builder();
        if (this.ub != null && this.entity != null) {
            URI self = this.adjunct != null ? WebResourceUtils.serviceUriBuilder(this.ub, AdjunctApi.class, "getConfig").build(new Object[]{this.entity.getApplicationId(), this.entity.getId(), this.adjunct.getId(), this.key.getName()}) : WebResourceUtils.serviceUriBuilder(this.ub, EntityConfigApi.class, "get").build(new Object[]{this.entity.getApplicationId(), this.entity.getId(), this.key.getName()});
            lb.put((Object)"self", (Object)self);
            if (this.includeContextLinks) {
                lb.put((Object)"application", (Object)EntityTransformer.applicationUri(this.entity.getApplication(), this.ub));
                lb.put((Object)"entity", (Object)EntityTransformer.entityUri(this.entity, this.ub));
                if (this.adjunct != null) {
                    lb.put((Object)"adjunct", (Object)AdjunctTransformer.adjunctUri(this.entity, this.adjunct, this.ub));
                }
            }
            if (this.includeActionLinks) {
                lb.put((Object)"action:json", (Object)self);
                Iterable hints = Iterables.filter((Iterable)RendererHints.getHintsFor(this.key), RendererHints.NamedAction.class);
                EntityAdjunct context = this.adjunct != null ? this.adjunct : this.entity;
                for (RendererHints.NamedAction na : hints) {
                    SensorTransformer.addNamedAction((MutableMap.Builder<String, URI>)lb, na, context.getConfig(this.key), this.key, (BrooklynObject)context);
                }
            }
        }
        return new ConfigSummary(this.key, this.label, this.priority, this.pinned, (Map)lb.build());
    }

    @Deprecated
    public EntityConfigSummary transformLegacyEntityConfig() {
        ConfigSummary v2 = this.transform();
        return new EntityConfigSummary(this.key, v2.getLabel(), v2.getPriority(), v2.isPinned(), v2.getLinks());
    }

    @Deprecated
    public EnricherConfigSummary transformLegacyEnricherConfig() {
        ConfigSummary v2 = this.transform();
        return new EnricherConfigSummary(this.key, v2.getLabel(), v2.getPriority(), v2.getLinks());
    }

    @Deprecated
    public PolicyConfigSummary transformLegacyPolicyConfig() {
        ConfigSummary v2 = this.transform();
        return new PolicyConfigSummary(this.key, v2.getLabel(), v2.getPriority(), v2.getLinks());
    }
}

