/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.util;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.rest.util.OsgiCompat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class ManagementContextProvider
implements ContextResolver<ManagementContext> {
    private static final Logger log = LoggerFactory.getLogger(ManagementContextProvider.class);
    @Context
    private ServletContext context;
    private ManagementContext mgmt;

    public ManagementContextProvider() {
    }

    public ManagementContextProvider(ServletContext context) {
        this.context = context;
    }

    @VisibleForTesting
    public ManagementContextProvider(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    public ManagementContext getContext(Class<?> type) {
        if (type == ManagementContext.class) {
            return this.getManagementContext();
        }
        return null;
    }

    @Beta
    public ManagementContext getManagementContext() {
        if (this.mgmt != null) {
            return this.mgmt;
        }
        return OsgiCompat.getManagementContext(this.context);
    }
}

