/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.brooklynnode;

import org.apache.brooklyn.core.internal.BrooklynProperties;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.entity.brooklynnode.BrooklynNodeImpl;
import org.apache.brooklyn.entity.brooklynnode.LocalBrooklynNode;
import org.apache.brooklyn.util.text.Strings;

public class LocalBrooklynNodeImpl
extends BrooklynNodeImpl
implements LocalBrooklynNode {
    private static final String LOCAL_BROOKLYN_NODE_KEY = "brooklyn.entity.brooklynnode.local.%s";
    private static final String BROOKLYN_WEBCONSOLE_PASSWORD_KEY = "brooklyn.webconsole.security.user.%s.password";

    @Override
    protected void connectSensors() {
        BrooklynProperties properties = ((ManagementContextInternal)this.getManagementContext()).getBrooklynProperties();
        String user = (String)properties.getConfig(String.format(LOCAL_BROOKLYN_NODE_KEY, "user"));
        String password = (String)properties.getConfig(String.format(LOCAL_BROOKLYN_NODE_KEY, "password"));
        if (Strings.isBlank((CharSequence)password)) {
            if (Strings.isBlank((CharSequence)user)) {
                user = "admin";
            }
            password = (String)properties.getConfig(String.format(BROOKLYN_WEBCONSOLE_PASSWORD_KEY, user));
        }
        if (Strings.isNonBlank((CharSequence)user) && Strings.isNonBlank((CharSequence)password)) {
            this.config().set(MANAGEMENT_USER, (Object)user);
            this.config().set(MANAGEMENT_PASSWORD, (Object)password);
        }
        super.connectSensors();
    }
}

