/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.software.base;

import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.core.entity.EntityAdjuncts;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.entity.software.base.SoftwareProcessImpl;
import org.apache.brooklyn.entity.software.base.WorkflowSoftwareProcess;
import org.apache.brooklyn.entity.software.base.WorkflowSoftwareProcessDriver;
import org.apache.brooklyn.util.guava.Maybe;

public class WorkflowSoftwareProcessImpl
extends SoftwareProcessImpl
implements WorkflowSoftwareProcess {
    public Class<?> getDriverInterface() {
        return WorkflowSoftwareProcessDriver.class;
    }

    @Override
    protected void connectSensors() {
        super.connectSensors();
        if (this.isSshMonitoringEnabled()) {
            this.connectServiceUpIsRunning();
        } else {
            Maybe enricher = EntityAdjuncts.tryFindWithUniqueTag((Iterable)this.enrichers(), (Object)"service-process-is-running-updating-not-up");
            if (enricher.isPresent()) {
                this.enrichers().remove((Enricher)enricher.get());
            }
            ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((Entity)this, (Sensor)SERVICE_PROCESS_IS_RUNNING);
        }
    }

    @Override
    protected void postStop() {
        super.postStop();
        if (!this.isSshMonitoringEnabled()) {
            ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this, (Sensor)SERVICE_PROCESS_IS_RUNNING, (Object)"This service was stopped");
        }
    }

    @Override
    protected void disconnectSensors() {
        this.disconnectServiceUpIsRunning();
        super.disconnectSensors();
    }

    protected boolean isSshMonitoringEnabled() {
        return Boolean.TRUE.equals(this.getConfig(USE_SSH_MONITORING));
    }
}

