/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.tasks.kubectl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.brooklyn.core.mgmt.ha.BrooklynBomOsgiArchiveInstaller;
import org.apache.brooklyn.tasks.kubectl.ContainerSpec;
import org.apache.brooklyn.tasks.kubectl.JobTemplate;
import org.apache.brooklyn.tasks.kubectl.PullPolicy;
import org.apache.brooklyn.tasks.kubectl.VolumeMount;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class KubeJobFileCreator {
    private static final Logger LOG = LoggerFactory.getLogger(KubeJobFileCreator.class);
    String jobName;
    String imageName;
    String imagePullPolicy;
    String workingDir;
    String prefix = "brooklyn-job";
    List<String> command = Lists.newArrayList();
    List<String> args = Lists.newArrayList();
    Map<String, String> env = Maps.newHashMap();
    List<Map<String, String>> volumeMounts = Lists.newArrayList();
    List<Map<String, Object>> volumes = Lists.newArrayList();

    public KubeJobFileCreator withName(String name) {
        this.jobName = name;
        return this;
    }

    public KubeJobFileCreator withImage(String image) {
        this.imageName = image;
        return this;
    }

    public KubeJobFileCreator withImagePullPolicy(PullPolicy eimagePullPolicy) {
        if (eimagePullPolicy != null) {
            this.imagePullPolicy = eimagePullPolicy.val();
        }
        return this;
    }

    public KubeJobFileCreator withCommand(List<String> commandAndEntryPointArgs) {
        if (commandAndEntryPointArgs != null) {
            this.command.addAll(commandAndEntryPointArgs);
        }
        return this;
    }

    public KubeJobFileCreator withArgs(List<String> args) {
        if (args != null) {
            this.args.addAll(args);
        }
        return this;
    }

    public KubeJobFileCreator withVolumeMounts(Set<Map<String, String>> volumeMounts) {
        if (volumeMounts != null) {
            this.volumeMounts.addAll(volumeMounts);
        }
        return this;
    }

    public KubeJobFileCreator withVolumes(Set<Map<String, Object>> volumes) {
        if (volumes != null) {
            this.volumes.addAll(volumes);
        }
        return this;
    }

    public KubeJobFileCreator withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    public KubeJobFileCreator withPrefix(String prefixArg) {
        this.prefix = prefixArg;
        return this;
    }

    public KubeJobFileCreator withEnv(Map<String, String> env) {
        if (env != null) {
            this.env.putAll(env);
        }
        return this;
    }

    public BrooklynBomOsgiArchiveInstaller.FileWithTempInfo<File> createFile() {
        JobTemplate jobTemplate = this.buildJobTemplate();
        return this.serializeAndWriteToTempFile(jobTemplate);
    }

    public String getAsString() {
        JobTemplate jobTemplate = this.buildJobTemplate();
        StringWriter sw = new StringWriter();
        this.serializeAndWriteToWriter(jobTemplate, sw);
        return sw.toString();
    }

    private JobTemplate buildJobTemplate() {
        JobTemplate jobTemplate = new JobTemplate(this.jobName);
        ContainerSpec containerSpec = jobTemplate.getSpec().getTemplate().getContainerSpec(0);
        if (Strings.isNonBlank((CharSequence)this.workingDir)) {
            containerSpec.setWorkingDir(this.workingDir);
        }
        containerSpec.setImage(this.imageName);
        containerSpec.setImagePullPolicy(this.imagePullPolicy);
        if (!this.env.isEmpty()) {
            List<Map<String, String>> envList = this.env.entrySet().stream().map(e -> {
                HashMap<String, Object> envItem = new HashMap<String, Object>();
                envItem.put("name", e.getKey());
                envItem.put("value", e.getValue());
                return envItem;
            }).collect(Collectors.toList());
            containerSpec.setEnv(envList);
        }
        if (!this.command.isEmpty()) {
            containerSpec.setCommand(this.command);
        }
        if (!this.args.isEmpty()) {
            containerSpec.setArgs(this.args);
        }
        HashSet volumeNames = new HashSet();
        if (!this.volumes.isEmpty()) {
            jobTemplate.getSpec().getTemplate().getSpec().setVolumes(this.volumes);
            this.volumes.stream().map(volumeSpec -> (String)volumeSpec.get("name")).forEach(volumeNames::add);
        }
        if (!this.volumeMounts.isEmpty()) {
            ArrayList vms = Lists.newArrayList();
            this.volumeMounts.forEach(vmMap -> {
                VolumeMount vm = new VolumeMount();
                vm.setName((String)vmMap.get("name"));
                if (!volumeNames.contains(vm.getName())) {
                    throw new IllegalArgumentException("The Job " + this.jobName + "is invalid: spec.template.spec.containers[0].volumeMounts[0].name: Not found:\"" + vm.getName() + "\"");
                }
                vm.setMountPath((String)vmMap.get("mountPath"));
                vms.add(vm);
            });
            containerSpec.setVolumeMounts(vms);
        }
        return jobTemplate;
    }

    private BrooklynBomOsgiArchiveInstaller.FileWithTempInfo<File> serializeAndWriteToTempFile(JobTemplate jobTemplate) {
        try {
            File jobBodyPath = File.createTempFile(this.prefix, ".yaml");
            jobBodyPath.deleteOnExit();
            this.serializeAndWriteToWriter(jobTemplate, new PrintWriter(jobBodyPath));
            LOG.debug("Job body dumped at: {}", (Object)jobBodyPath.getAbsolutePath());
            return new BrooklynBomOsgiArchiveInstaller.FileWithTempInfo(jobBodyPath, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create temp file for container", e);
        }
    }

    private void serializeAndWriteToWriter(JobTemplate jobTemplate, Writer writer) {
        DumperOptions options = new DumperOptions();
        options.setIndent(2);
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Representer representer = new Representer(options){

            protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
                if (propertyValue == null) {
                    return null;
                }
                return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
            }
        };
        representer.addClassTag(JobTemplate.class, Tag.MAP);
        try {
            File jobBodyPath = File.createTempFile(this.prefix, ".yaml");
            jobBodyPath.deleteOnExit();
            Yaml yaml = new Yaml(representer, options);
            yaml.dump((Object)jobTemplate, writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write job file for container", e);
        }
    }
}

