/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.s3.blobstore.functions.BucketToResourceMetadata;
import org.jclouds.s3.domain.BucketMetadata;

@Singleton
public class BucketsToStorageMetadata
implements Function<Set<BucketMetadata>, PageSet<? extends StorageMetadata>> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final ListeningExecutorService userExecutor;
    private final BucketToResourceMetadata bucket2ResourceMd;

    @Inject
    public BucketsToStorageMetadata(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, BucketToResourceMetadata bucket2ResourceMd) {
        this.userExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecutor");
        this.bucket2ResourceMd = (BucketToResourceMetadata)Preconditions.checkNotNull((Object)bucket2ResourceMd, (Object)"bucket2ResourceMd");
    }

    public PageSet<? extends StorageMetadata> apply(Set<BucketMetadata> input) {
        Iterable buckets = FutureIterables.transformParallel(input, (Function)new Function<BucketMetadata, ListenableFuture<? extends StorageMetadata>>(){

            public ListenableFuture<? extends StorageMetadata> apply(final BucketMetadata from) {
                return BucketsToStorageMetadata.this.userExecutor.submit((Callable)new Callable<StorageMetadata>(){

                    @Override
                    public StorageMetadata call() throws Exception {
                        return BucketsToStorageMetadata.this.bucket2ResourceMd.apply(from);
                    }

                    public String toString() {
                        return "bucket2ResourceMd.apply(" + from + ")";
                    }
                });
            }
        }, (ListeningExecutorService)this.userExecutor, null, (Logger)this.logger, (String)"my buckets");
        return new PageSetImpl(buckets, null);
    }
}

