/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.creation.service;

import java.util.Set;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.camp.brooklyn.BrooklynCampConstants;
import org.apache.brooklyn.camp.brooklyn.spi.creation.CampTypePlanTransformer;
import org.apache.brooklyn.core.resolve.entity.EntitySpecResolver;
import org.apache.brooklyn.core.typereg.RegisteredTypeLoadingContexts;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Urls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlServiceSpecResolver
implements EntitySpecResolver {
    private static final Logger log = LoggerFactory.getLogger(UrlServiceSpecResolver.class);

    public String getName() {
        return "url";
    }

    public boolean accepts(String type, BrooklynClassLoadingContext loader) {
        String protocol = Urls.getProtocol((String)type);
        return protocol != null && BrooklynCampConstants.YAML_URL_PROTOCOL_WHITELIST.contains(protocol);
    }

    public EntitySpec<?> resolve(String type, BrooklynClassLoadingContext loader, Set<String> encounteredTypes) {
        String yaml;
        try {
            yaml = ResourceUtils.create((Object)loader).getResourceAsString(type);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("AssemblyTemplate type " + type + " looks like a URL that can't be fetched.", (Throwable)e);
            return null;
        }
        if (encounteredTypes.contains(type)) {
            throw new IllegalStateException("URL " + type + " is self referential.");
        }
        EntitySpec item = (EntitySpec)loader.getManagementContext().getTypeRegistry().createSpecFromPlan(CampTypePlanTransformer.FORMAT, (Object)yaml, RegisteredTypeLoadingContexts.loaderAlreadyEncountered((BrooklynClassLoadingContext)loader, encounteredTypes, (String)type), EntitySpec.class);
        return item;
    }

    public void setManagementContext(ManagementContext managementContext) {
    }
}

