/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.camp.brooklyn.spi.dsl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslInterpreter;
import org.apache.brooklyn.camp.spi.resolve.interpret.PlanInterpretationNode;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.util.core.task.DeferredSupplier;
import org.apache.brooklyn.util.core.task.ImmediateSupplier;
import org.apache.brooklyn.util.core.task.TaskTags;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BrooklynDslDeferredSupplier<T>
implements DeferredSupplier<T>,
ImmediateSupplier<T>,
TaskFactory<Task<T>>,
Serializable {
    private static final long serialVersionUID = -8789624905412198233L;
    private static final Logger log = LoggerFactory.getLogger(BrooklynDslDeferredSupplier.class);
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="$brooklyn:literal")
    protected Object dsl = null;
    protected static ThreadLocal<Pair<Integer, BrooklynDslDeferredSupplier>> lastSourceNode = new ThreadLocal();

    public BrooklynDslDeferredSupplier() {
        PlanInterpretationNode sourceNode = BrooklynDslInterpreter.currentNode();
        if (sourceNode != null && sourceNode.getOriginalValue() != null) {
            Pair<Integer, BrooklynDslDeferredSupplier> last = lastSourceNode.get();
            if (last != null && ((Integer)last.getLeft()).equals(sourceNode.hashCode())) {
                ((BrooklynDslDeferredSupplier)last.getRight()).dsl = null;
            }
            this.dsl = sourceNode.getOriginalValue();
            lastSourceNode.set((Pair<Integer, BrooklynDslDeferredSupplier>)Pair.of((Object)sourceNode.hashCode(), (Object)this));
        }
    }

    protected static final EntityInternal entity() {
        return (EntityInternal)BrooklynTaskTags.getTargetOrContextEntity((Task)Tasks.current());
    }

    protected static final ManagementContextInternal managementContext() {
        return (ManagementContextInternal)BrooklynTaskTags.getManagementContext((Task)Tasks.current());
    }

    public final T get() {
        Object result;
        ExecutionContext exec;
        if (log.isTraceEnabled()) {
            log.trace("Queuing task to resolve {}, called by {}", this.dsl, (Object)Tasks.current());
        }
        if ((exec = BrooklynTaskTags.getCurrentExecutionContext()) == null) {
            throw new IllegalStateException("No execution context available to resolve " + this.dsl);
        }
        Task<T> task = this.newTask();
        try {
            result = exec.submit(task).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Task currentTask = Tasks.current();
            if (currentTask != null && currentTask.isCancelled()) {
                task.cancel(true);
            }
            throw Exceptions.propagate((Throwable)e);
        }
        if (log.isTraceEnabled()) {
            log.trace("Resolved " + this.dsl);
        }
        return (T)result;
    }

    public abstract Task<T> newTask();

    protected void checkAndTagForRecursiveReference(Entity targetEntity, String tag) {
        Task ancestor = Tasks.current();
        if (ancestor != null) {
            ancestor = ancestor.getSubmittedByTask();
        }
        while (ancestor != null) {
            if (TaskTags.hasTag((Task)ancestor, (Object)tag)) {
                throw new IllegalStateException("Recursive reference " + tag);
            }
            ancestor = ancestor.getSubmittedByTask();
        }
        Tasks.addTagDynamically((Object)tag);
    }
}

