/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.catalog.internal;

import com.google.common.base.Predicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.OsgiBundleWithUrl;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.catalog.internal.CatalogInitialization;
import org.apache.brooklyn.core.catalog.internal.RegisteredTypesSupplier;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.typereg.BundleUpgradeParser;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

class CatalogUpgradeScanner {
    private final ManagementContextInternal managementContext;
    private final BiFunction<Bundle, RegisteredTypesSupplier, BundleUpgradeParser.CatalogUpgrades> bundleUpgradeParser;
    private final Function<OsgiBundleWithUrl, Predicate<? super RegisteredType>> managedBundlePredicateSupplier;
    private final Function<String, Predicate<? super RegisteredType>> unmanagedBundlePredicateSupplier;

    CatalogUpgradeScanner(ManagementContextInternal managementContext, BiFunction<Bundle, RegisteredTypesSupplier, BundleUpgradeParser.CatalogUpgrades> bundleUpgradeParser, Function<OsgiBundleWithUrl, Predicate<? super RegisteredType>> managedBundlePredicateSupplier, Function<String, Predicate<? super RegisteredType>> unmanagedBundlePredicateSupplier) {
        this.managementContext = Objects.requireNonNull(managementContext, "managementContext");
        this.bundleUpgradeParser = Objects.requireNonNull(bundleUpgradeParser, "bundleUpgradeParser");
        this.managedBundlePredicateSupplier = Objects.requireNonNull(managedBundlePredicateSupplier, "managedBundlePredicateSupplier");
        this.unmanagedBundlePredicateSupplier = Objects.requireNonNull(unmanagedBundlePredicateSupplier, "unmanagedBundlePredicateSupplier");
    }

    public BundleUpgradeParser.CatalogUpgrades scan(OsgiManager osgiManager, BundleContext bundleContext, CatalogInitialization.RebindLogger rebindLogger) {
        BundleUpgradeParser.CatalogUpgrades.Builder catalogUpgradesBuilder = BundleUpgradeParser.CatalogUpgrades.builder();
        this.scanManagedBundles(osgiManager, catalogUpgradesBuilder, rebindLogger);
        this.scanAllBundles(catalogUpgradesBuilder, bundleContext);
        return catalogUpgradesBuilder.build();
    }

    private void scanManagedBundles(OsgiManager osgiManager, BundleUpgradeParser.CatalogUpgrades.Builder catalogUpgradesBuilder, CatalogInitialization.RebindLogger rebindLogger) {
        Collection<ManagedBundle> managedBundles = osgiManager.getManagedBundles().values();
        for (ManagedBundle managedBundle : managedBundles) {
            Maybe<Bundle> bundle = osgiManager.findBundle((OsgiBundleWithUrl)managedBundle);
            if (bundle.isPresent()) {
                BundleUpgradeParser.CatalogUpgrades catalogUpgrades = this.bundleUpgradeParser.apply((Bundle)bundle.get(), this.typeSupplier(managedBundle));
                catalogUpgradesBuilder.addAll(catalogUpgrades);
                continue;
            }
            rebindLogger.info("Managed bundle " + managedBundle.getId() + " not found by OSGi Manager; ignoring when calculating persisted state catalog upgrades", new Object[0]);
        }
    }

    private void scanAllBundles(BundleUpgradeParser.CatalogUpgrades.Builder catalogUpgradesBuilder, BundleContext bundleContext) {
        Arrays.stream(bundleContext.getBundles()).filter(b -> Strings.isNonBlank((CharSequence)b.getSymbolicName())).forEach(bundle -> catalogUpgradesBuilder.addAll(this.bundleUpgradeParser.apply((Bundle)bundle, this.typeSupplier((Bundle)bundle))));
    }

    private RegisteredTypesSupplier typeSupplier(ManagedBundle managedBundle) {
        return new RegisteredTypesSupplier(this.managementContext, this.managedBundlePredicateSupplier.apply((OsgiBundleWithUrl)managedBundle));
    }

    private RegisteredTypesSupplier typeSupplier(Bundle bundle) {
        return new RegisteredTypesSupplier(this.managementContext, this.unmanagedBundlePredicateSupplier.apply(bundle.getSymbolicName()));
    }
}

