/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.config.external;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.core.config.external.AbstractExternalConfigSupplier;
import org.apache.brooklyn.util.core.ResourceUtils;

public class UrlsExternalConfigSupplier
extends AbstractExternalConfigSupplier {
    private final Map<String, String> config;
    private final ResourceUtils resourceUtils;

    public UrlsExternalConfigSupplier(ManagementContext managementContext, String name, Map<String, String> config) throws IOException {
        super(managementContext, name);
        this.config = config;
        this.resourceUtils = ResourceUtils.create(managementContext.getCatalogClassLoader(), (Object)this, UrlsExternalConfigSupplier.class.getSimpleName() + "(" + this.getName() + ")");
        LinkedHashMap missing = Maps.newLinkedHashMap();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            String target = entry.getValue();
            if (this.resourceUtils.doesUrlExist(target)) continue;
            missing.put(entry.getKey(), entry.getValue());
        }
        if (missing.size() > 0) {
            throw new IllegalStateException("URLs for external config '" + this.getName() + "' not found: " + missing);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).toString();
    }

    @Override
    public String get(String key) {
        String target = this.config.get(key);
        if (target == null) {
            throw new IllegalArgumentException("Unknown key '" + key + "' for " + this.toString());
        }
        return this.resourceUtils.getResourceAsString(target);
    }
}

