/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity.drivers.downloads;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.brooklyn.api.entity.drivers.downloads.DownloadResolverManager;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.drivers.downloads.DownloadSubstituters;

public class DownloadProducerFromUrlAttribute
extends DownloadSubstituters.Substituter
implements Function<DownloadResolverManager.DownloadRequirement, DownloadResolverManager.DownloadTargets> {
    public DownloadProducerFromUrlAttribute() {
        super((Function<? super DownloadResolverManager.DownloadRequirement, String>)new Function<DownloadResolverManager.DownloadRequirement, String>(){

            public String apply(DownloadResolverManager.DownloadRequirement input) {
                if (input.getAddonName() == null) {
                    return (String)input.getEntityDriver().getEntity().getAttribute(Attributes.DOWNLOAD_URL);
                }
                String addon = input.getAddonName();
                Map addonUrls = (Map)input.getEntityDriver().getEntity().getAttribute(Attributes.DOWNLOAD_ADDON_URLS);
                return addonUrls != null ? (String)addonUrls.get(addon) : null;
            }
        }, new Function<DownloadResolverManager.DownloadRequirement, Map<String, ?>>(){

            public Map<String, ?> apply(DownloadResolverManager.DownloadRequirement input) {
                LinkedHashMap result = Maps.newLinkedHashMap();
                if (input.getAddonName() == null) {
                    result.putAll(DownloadSubstituters.getBasicEntitySubstitutions(input.getEntityDriver()));
                } else {
                    result.putAll(DownloadSubstituters.getBasicAddonSubstitutions(input.getEntityDriver(), input.getAddonName()));
                }
                result.putAll(input.getProperties());
                return result;
            }
        });
    }
}

