/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.location.cloud;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.LocationSpec;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.location.AbstractLocation;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.internal.ssh.SshTool;
import org.apache.brooklyn.util.text.StringPredicates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCloudMachineProvisioningLocation
extends AbstractLocation
implements MachineProvisioningLocation<MachineLocation>,
CloudLocationConfig {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCloudMachineProvisioningLocation.class);

    public AbstractCloudMachineProvisioningLocation() {
    }

    public AbstractCloudMachineProvisioningLocation(Map<?, ?> conf) {
        super(conf);
    }

    public AbstractCloudMachineProvisioningLocation newSubLocation(Map<?, ?> newFlags) {
        return this.newSubLocation(this.getClass(), newFlags);
    }

    public AbstractCloudMachineProvisioningLocation newSubLocation(Class<? extends AbstractCloudMachineProvisioningLocation> type, Map<?, ?> newFlags) {
        return (AbstractCloudMachineProvisioningLocation)this.getManagementContext().getLocationManager().createLocation((LocationSpec)((LocationSpec)LocationSpec.create(type).parent((Location)this).configure(this.config().getLocalBag().getAllConfig())).configure(newFlags));
    }

    public Map<String, Object> getProvisioningFlags(Collection<String> tags) {
        if (tags.size() > 0) {
            LOG.warn("Location {}, ignoring provisioning tags {}", (Object)this, tags);
        }
        return MutableMap.of();
    }

    protected ConfigBag extractSshConfig(ConfigBag setup, ConfigBag alt) {
        ConfigBag sshConfig = new ConfigBag();
        for (ConfigKey.HasConfigKey<?> key : SshMachineLocation.ALL_SSH_CONFIG_KEYS) {
            String keyName = key.getConfigKey().getName();
            if (setup.containsKey(keyName)) {
                sshConfig.putStringKey(keyName, setup.getStringKey(keyName));
                continue;
            }
            if (!alt.containsKey(keyName)) continue;
            sshConfig.putStringKey(keyName, setup.getStringKey(keyName));
        }
        Map sshToolClassProperties = Maps.filterKeys(setup.getAllConfig(), (Predicate)StringPredicates.startsWith((String)SshMachineLocation.SSH_TOOL_CLASS_PROPERTIES_PREFIX));
        sshConfig.putAll(sshToolClassProperties);
        if (setup.containsKey(PASSWORD)) {
            sshConfig.copyKeyAs(setup, PASSWORD, SshTool.PROP_PASSWORD);
        } else if (alt.containsKey(PASSWORD)) {
            sshConfig.copyKeyAs(alt, PASSWORD, SshTool.PROP_PASSWORD);
        }
        if (setup.containsKey(PRIVATE_KEY_DATA)) {
            sshConfig.copyKeyAs(setup, PRIVATE_KEY_DATA, SshTool.PROP_PRIVATE_KEY_DATA);
        } else if (setup.containsKey(PRIVATE_KEY_FILE)) {
            sshConfig.copyKeyAs(setup, PRIVATE_KEY_FILE, SshTool.PROP_PRIVATE_KEY_FILE);
        } else if (alt.containsKey(PRIVATE_KEY_DATA)) {
            sshConfig.copyKeyAs(setup, PRIVATE_KEY_DATA, SshTool.PROP_PRIVATE_KEY_DATA);
        }
        if (setup.containsKey(PRIVATE_KEY_PASSPHRASE)) {
            sshConfig.copyKeyAs(setup, PRIVATE_KEY_PASSPHRASE, SshTool.PROP_PRIVATE_KEY_PASSPHRASE);
        }
        return sshConfig;
    }
}

