/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.ha.dto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.net.URI;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeSyncRecord;
import org.apache.brooklyn.core.BrooklynVersion;
import org.apache.brooklyn.util.time.Time;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE)
public class BasicManagementNodeSyncRecord
implements ManagementNodeSyncRecord,
Serializable {
    private static final long serialVersionUID = 4918161834047884244L;
    private String brooklynVersion;
    private String nodeId;
    private URI uri;
    private ManagementNodeState status;
    private Long priority;
    private Long localTimestamp;
    private Long remoteTimestamp;
    @Deprecated
    private Long timestampUtc;

    public static Builder builder() {
        return new Builder();
    }

    private BasicManagementNodeSyncRecord() {
    }

    protected BasicManagementNodeSyncRecord(Builder builder) {
        this.brooklynVersion = builder.brooklynVersion;
        this.nodeId = builder.nodeId;
        this.uri = builder.uri;
        this.status = builder.status;
        this.priority = builder.priority;
        this.localTimestamp = builder.localTimestamp;
        this.remoteTimestamp = builder.remoteTimestamp;
    }

    public String getBrooklynVersion() {
        return this.brooklynVersion;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public URI getUri() {
        return this.uri;
    }

    public ManagementNodeState getStatus() {
        return this.status;
    }

    public Long getPriority() {
        return this.priority;
    }

    public long getLocalTimestamp() {
        if (this.localTimestamp != null) {
            return this.localTimestamp;
        }
        if (this.timestampUtc != null) {
            return this.timestampUtc;
        }
        throw new NullPointerException("localTimestamp not known for " + this.getNodeId());
    }

    public Long getRemoteTimestamp() {
        return this.remoteTimestamp;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeId", (Object)this.getNodeId()).add("status", (Object)this.getStatus()).toString();
    }

    public String toVerboseString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("brooklynVersion", (Object)this.getBrooklynVersion()).add("nodeId", (Object)this.getNodeId()).add("uri", (Object)this.getUri()).add("status", (Object)this.getStatus()).add("priority", (Object)this.getPriority()).add("localTimestamp", (Object)(this.getLocalTimestamp() + "=" + Time.makeDateString((long)this.getLocalTimestamp()))).add("remoteTimestamp", (Object)(this.getRemoteTimestamp() + (this.getRemoteTimestamp() == null ? "" : "=" + Time.makeDateString((long)this.getRemoteTimestamp())))).toString();
    }

    public void setRemoteTimestamp(Long remoteTimestamp) {
        this.remoteTimestamp = remoteTimestamp;
    }

    public static class Builder {
        private String brooklynVersion = BrooklynVersion.get();
        protected String nodeId;
        protected URI uri;
        protected ManagementNodeState status;
        protected Long priority;
        protected long localTimestamp;
        protected Long remoteTimestamp;

        protected Builder self() {
            return this;
        }

        public Builder brooklynVersion(String val) {
            this.brooklynVersion = val;
            return this.self();
        }

        public Builder nodeId(String val) {
            this.nodeId = val;
            return this.self();
        }

        public Builder uri(URI val) {
            this.uri = val;
            return this.self();
        }

        public Builder status(ManagementNodeState val) {
            this.status = val;
            return this.self();
        }

        public Builder priority(Long val) {
            this.priority = val;
            return this.self();
        }

        public Builder localTimestamp(long val) {
            this.localTimestamp = val;
            return this.self();
        }

        public Builder remoteTimestamp(Long val) {
            this.remoteTimestamp = val;
            return this.self();
        }

        public Builder from(ManagementNodeSyncRecord other) {
            return this.from(other, false);
        }

        public Builder from(ManagementNodeSyncRecord other, boolean ignoreNulls) {
            if (ignoreNulls && other == null) {
                return this;
            }
            if (other.getBrooklynVersion() != null) {
                this.brooklynVersion = other.getBrooklynVersion();
            }
            if (other.getNodeId() != null) {
                this.nodeId = other.getNodeId();
            }
            if (other.getUri() != null) {
                this.uri = other.getUri();
            }
            if (other.getStatus() != null) {
                this.status = other.getStatus();
            }
            if (other.getPriority() != null) {
                this.priority = other.getPriority();
            }
            if (other.getLocalTimestamp() > 0L) {
                this.localTimestamp = other.getLocalTimestamp();
            }
            if (other.getRemoteTimestamp() != null) {
                this.remoteTimestamp = other.getRemoteTimestamp();
            }
            return this;
        }

        public ManagementNodeSyncRecord build() {
            return new BasicManagementNodeSyncRecord(this);
        }
    }
}

