/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.entity.EntityTypeRegistry;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.internal.BrooklynLoggingCategories;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.mgmt.AccessController;
import org.apache.brooklyn.api.mgmt.EntityManager;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Enricher;
import org.apache.brooklyn.api.sensor.EnricherSpec;
import org.apache.brooklyn.core.BrooklynLogging;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.EntityPredicates;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.internal.storage.BrooklynStorage;
import org.apache.brooklyn.core.mgmt.BrooklynTags;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.entitlement.Entitlements;
import org.apache.brooklyn.core.mgmt.internal.AsyncCollectionChangeAdapter;
import org.apache.brooklyn.core.mgmt.internal.BrooklynObjectManagementMode;
import org.apache.brooklyn.core.mgmt.internal.CollectionChangeListener;
import org.apache.brooklyn.core.mgmt.internal.EntityManagerInternal;
import org.apache.brooklyn.core.mgmt.internal.IdAlreadyExistsException;
import org.apache.brooklyn.core.mgmt.internal.LocalManagementContext;
import org.apache.brooklyn.core.mgmt.internal.ManagementTransitionInfo;
import org.apache.brooklyn.core.mgmt.internal.ManagementTransitionMode;
import org.apache.brooklyn.core.mgmt.internal.ObservableSet;
import org.apache.brooklyn.core.objs.BasicEntityTypeRegistry;
import org.apache.brooklyn.core.objs.proxy.EntityProxy;
import org.apache.brooklyn.core.objs.proxy.EntityProxyImpl;
import org.apache.brooklyn.core.objs.proxy.InternalEntityFactory;
import org.apache.brooklyn.core.objs.proxy.InternalPolicyFactory;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.collections.SetFromLiveMap;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.time.CountdownTimer;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalEntityManager
implements EntityManagerInternal {
    private static final Logger log = LoggerFactory.getLogger(LocalEntityManager.class);
    private static final Pattern ENTITY_ID_PATTERN = Pattern.compile("[a-z0-9]{10,63}");
    private final LocalManagementContext managementContext;
    private final BasicEntityTypeRegistry entityTypeRegistry;
    private final InternalEntityFactory entityFactory;
    private final InternalPolicyFactory policyFactory;
    private final Map<String, Entity> preRegisteredEntitiesById = Collections.synchronizedMap(new WeakHashMap());
    private final Map<String, Entity> preManagedEntitiesById = Collections.synchronizedMap(new WeakHashMap());
    private final ConcurrentMap<String, Entity> entityProxiesById = Maps.newConcurrentMap();
    private final Map<String, Entity> entitiesById = Maps.newLinkedHashMap();
    private final Map<String, ManagementTransitionMode> entityModesById = Collections.synchronizedMap(Maps.newLinkedHashMap());
    private final ObservableSet<Entity> entities = new ObservableSet();
    private final Set<Application> applications = Sets.newConcurrentHashSet();
    private final BrooklynStorage storage;
    private final Map<String, String> entityTypes;
    private final Set<String> applicationIds;

    public LocalEntityManager(LocalManagementContext managementContext) {
        this.managementContext = (LocalManagementContext)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
        this.storage = managementContext.getStorage();
        this.entityTypeRegistry = new BasicEntityTypeRegistry();
        this.policyFactory = new InternalPolicyFactory(managementContext);
        this.entityFactory = new InternalEntityFactory(managementContext, this.entityTypeRegistry, this.policyFactory);
        this.entityTypes = this.storage.getMap("entities");
        this.applicationIds = SetFromLiveMap.create(this.storage.getMap("applications"));
    }

    public InternalEntityFactory getEntityFactory() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        return this.entityFactory;
    }

    public InternalPolicyFactory getPolicyFactory() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        return this.policyFactory;
    }

    public EntityTypeRegistry getEntityTypeRegistry() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Management context no longer running");
        }
        return this.entityTypeRegistry;
    }

    public <T extends Entity> T createEntity(EntitySpec<T> spec, EntityManager.EntityCreationOptions options) {
        String entityId = options.getRequiredUniqueId();
        if (entityId != null && !ENTITY_ID_PATTERN.matcher(entityId).matches()) {
            throw new IllegalArgumentException("Invalid entity id '" + entityId + "'");
        }
        try {
            T entity = this.entityFactory.createEntity(spec, options);
            if (options.isDryRun()) {
                this.unmanageDryRun((Entity)entity);
                this.managementContext.getGarbageCollector().onUnmanaged((Entity)entity);
                return entity;
            }
            Entity proxy = ((AbstractEntity)entity).getProxy();
            Preconditions.checkNotNull((Object)proxy, (String)"proxy for entity %s, spec %s", entity, spec);
            this.manage((Entity)entity);
            if (options.persistAfterCreation()) {
                try {
                    this.managementContext.getRebindManager().forcePersistNow(false, null);
                }
                catch (Exception e) {
                    log.warn("Error persisting " + entity + " after creation; will unmanage then rethrow: " + e);
                    try {
                        this.unmanage((Entity)entity);
                    }
                    catch (Exception e2) {
                        log.error("Could not unmanage " + entity + " which failed persistence after creation; manual removal will be required: " + e2, (Throwable)e2);
                    }
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            return (T)proxy;
        }
        catch (Throwable e) {
            log.debug("Failed to create entity using spec " + spec + " (rethrowing)", e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public <T extends Entity> T createEntity(Map<?, ?> config, Class<T> type) {
        return (T)this.createEntity(EntitySpec.create(config, type));
    }

    public <T extends Policy> T createPolicy(PolicySpec<T> spec) {
        try {
            return this.policyFactory.createPolicy(spec);
        }
        catch (Throwable e) {
            log.warn("Failed to create policy using spec " + spec + " (rethrowing)", e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public <T extends Enricher> T createEnricher(EnricherSpec<T> spec) {
        try {
            return this.policyFactory.createEnricher(spec);
        }
        catch (Throwable e) {
            log.warn("Failed to create enricher using spec " + spec + " (rethrowing)", e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Collection<Entity> getEntities() {
        return ImmutableList.copyOf(this.entityProxiesById.values());
    }

    public Collection<String> getEntityIds() {
        return ImmutableList.copyOf(this.entityProxiesById.keySet());
    }

    public Collection<Entity> getEntitiesInApplication(Application application) {
        Predicate<Entity> predicate = EntityPredicates.applicationIdEqualTo(application.getId());
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.entityProxiesById.values(), predicate));
    }

    public Collection<Entity> findEntities(Predicate<? super Entity> filter) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.entityProxiesById.values(), filter));
    }

    public Collection<Entity> findEntitiesInApplication(Application application, Predicate<? super Entity> filter) {
        Predicate predicate = Predicates.and(EntityPredicates.applicationIdEqualTo(application.getId()), filter);
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.entityProxiesById.values(), (Predicate)predicate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Entity> getAllEntitiesInApplication(Application application) {
        Predicate<Entity> predicate = EntityPredicates.applicationIdEqualTo(application.getId());
        LinkedHashSet result = Sets.newLinkedHashSet();
        Object object = this.preRegisteredEntitiesById;
        synchronized (object) {
            for (Entity entity : this.preRegisteredEntitiesById.values()) {
                if (!predicate.apply((Object)entity)) continue;
                result.add(entity);
            }
        }
        object = this.preManagedEntitiesById;
        synchronized (object) {
            for (Entity entity : this.preManagedEntitiesById.values()) {
                if (!predicate.apply((Object)entity)) continue;
                result.add(entity);
            }
        }
        for (Entity entity : this.entityProxiesById.values()) {
            if (!predicate.apply((Object)entity)) continue;
            result.add(entity);
        }
        return FluentIterable.from((Iterable)result).transform((Function)new Function<Entity, Entity>(){

            public Entity apply(Entity input) {
                return Entities.proxy(input);
            }
        }).toSet();
    }

    public Entity getEntity(String id) {
        return (Entity)this.entityProxiesById.get(id);
    }

    Collection<Application> getApplications() {
        return ImmutableList.copyOf(this.applications);
    }

    public boolean isManaged(Entity e) {
        return this.isRunning() && this.getEntity(e.getId()) != null && this.entitiesById.get(e.getId()) == this.deproxyIfNecessary(e);
    }

    boolean isPreRegistered(Entity e) {
        return this.preRegisteredEntitiesById.containsKey(e.getId());
    }

    void prePreManage(Entity entity) {
        if (this.isPreRegistered(entity)) {
            log.warn("" + this + " redundant call to pre-pre-manage entity " + entity + "; skipping", (Throwable)new Exception("source of duplicate pre-pre-manage of " + entity));
            return;
        }
        this.preRegisteredEntitiesById.put(entity.getId(), entity);
    }

    @Override
    public ManagementTransitionMode getLastManagementTransitionMode(String itemId) {
        return this.entityModesById.get(itemId);
    }

    @Override
    public void setManagementTransitionMode(Entity item, ManagementTransitionMode mode) {
        this.entityModesById.put(item.getId(), mode);
    }

    public void manage(Entity e) {
        if (this.isManaged(e)) {
            log.warn("" + this + " redundant call to start management of entity (and descendants of) " + e + "; skipping", (Throwable)new Exception("source of duplicate management of " + e));
            return;
        }
        this.manageRecursive(e, ManagementTransitionMode.guessing(BrooklynObjectManagementMode.NONEXISTENT, BrooklynObjectManagementMode.MANAGED_PRIMARY));
    }

    @Override
    public void manageRebindedRoot(Entity item) {
        ManagementTransitionMode mode = this.getLastManagementTransitionMode(item.getId());
        Preconditions.checkNotNull((Object)mode, (String)"Mode not set for rebinding %s", (Object)item);
        this.manageRecursive(item, mode);
    }

    protected void checkManagementAllowed(Entity item) {
        AccessController.Response access = this.managementContext.getAccessController().canManageEntity(item);
        if (!access.isAllowed()) {
            throw new IllegalStateException("Access controller forbids management of " + item + ": " + access.getMsg());
        }
    }

    protected void manageRecursive(Entity e, final ManagementTransitionMode initialMode) {
        this.checkManagementAllowed(e);
        final ArrayList allEntities = Lists.newArrayList();
        Predicate<EntityInternal> manageEntity = new Predicate<EntityInternal>(){

            public boolean apply(EntityInternal it) {
                ManagementTransitionMode mode = LocalEntityManager.this.getLastManagementTransitionMode(it.getId());
                if (mode == null) {
                    mode = initialMode;
                    LocalEntityManager.this.setManagementTransitionMode((Entity)it, mode);
                }
                log.debug("Starting management of {} mode {}", (Object)it, (Object)mode);
                Boolean isReadOnlyFromEntity = it.getManagementSupport().isReadOnlyRaw();
                if (isReadOnlyFromEntity == null) {
                    if (mode.isReadOnly()) {
                        log.warn("Read-only entity " + it + " not marked as such on call to manage; marking and continuing");
                    }
                    it.getManagementSupport().setReadOnly(mode.isReadOnly());
                } else if (!isReadOnlyFromEntity.equals(mode.isReadOnly())) {
                    log.warn("Read-only status at entity " + it + " (" + isReadOnlyFromEntity + ") not consistent with management mode " + mode);
                }
                if (it.getManagementSupport().isDeployed()) {
                    if (mode.wasNotLoaded()) {
                        return false;
                    }
                    if (!(mode.wasPrimary() && mode.isPrimary() || mode.wasReadOnly() && mode.isReadOnly())) {
                        log.warn("Already deployed " + it + " when managing " + mode + "/" + initialMode + "; ignoring this and all descendants");
                        return false;
                    }
                }
                boolean isNowReadOnly = Boolean.TRUE.equals(it.getManagementSupport().isReadOnly());
                if (mode.isReadOnly() != isNowReadOnly) {
                    throw new IllegalStateException("Read-only status mismatch for " + it + ": " + mode + " / RO=" + isNowReadOnly);
                }
                allEntities.add(it);
                LocalEntityManager.this.preManageNonRecursive((Entity)it, mode);
                it.getManagementSupport().onManagementStarting(new ManagementTransitionInfo(LocalEntityManager.this.managementContext, mode));
                return LocalEntityManager.this.manageNonRecursive((Entity)it, mode);
            }
        };
        boolean isRecursive = true;
        if (initialMode.wasPrimary() && initialMode.isPrimary()) {
            Entity aChild = (Entity)Iterables.getFirst((Iterable)e.getChildren(), null);
            if (aChild != null && this.isPreRegistered(aChild)) {
                log.debug("Managing " + e + " in mode " + initialMode + ", doing this recursively because a child is preregistered");
            } else {
                log.debug("Managing " + e + " but skipping recursion, as mode is " + initialMode);
                isRecursive = false;
            }
        }
        if (!isRecursive) {
            manageEntity.apply((Object)((EntityInternal)e));
        } else {
            this.recursively(e, manageEntity);
        }
        for (EntityInternal it : allEntities) {
            if (it.getManagementSupport().isFullyManaged()) continue;
            ManagementTransitionMode mode = this.getLastManagementTransitionMode(it.getId());
            ManagementTransitionInfo info = new ManagementTransitionInfo(this.managementContext, mode);
            it.getManagementSupport().onManagementStarted(info);
            this.managementContext.getRebindManager().getChangeListener().onManaged((BrooklynObject)it);
        }
    }

    public void unmanage(Entity e) {
        this.unmanage(e, ManagementTransitionMode.guessing(BrooklynObjectManagementMode.MANAGED_PRIMARY, BrooklynObjectManagementMode.NONEXISTENT));
    }

    @Override
    public void unmanage(Entity e, ManagementTransitionMode mode) {
        this.unmanage(e, mode, false);
    }

    @Override
    public void discardPremanaged(Entity e) {
        if (e == null) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        LinkedHashSet<String> todiscard = new LinkedHashSet<String>();
        Stack<Entity> tovisit = new Stack<Entity>();
        LinkedHashSet<Entity> visited = new LinkedHashSet<Entity>();
        tovisit.push(e);
        while (!tovisit.isEmpty()) {
            Entity next = (Entity)tovisit.pop();
            visited.add(next);
            for (Entity child : next.getChildren()) {
                if (visited.contains(child)) continue;
                tovisit.push(child);
            }
            if (this.isManaged(next)) {
                throw new IllegalStateException("Cannot discard entity " + e + " because it or a descendent is already managed (" + next + ")");
            }
            Entity realNext = this.deproxyIfNecessary(next);
            String id = next.getId();
            Entity realFound = this.preRegisteredEntitiesById.get(id);
            if (realFound == null) {
                this.preManagedEntitiesById.get(id);
            }
            if (realFound != null && realFound != realNext) {
                throw new IllegalStateException("Cannot discard pre-managed entity " + e + " because it or a descendent's id (" + id + ") clashes with a different entity (given " + next + " but found " + realFound + ")");
            }
            todiscard.add(id);
        }
        for (String id : todiscard) {
            this.preRegisteredEntitiesById.remove(id);
            this.preManagedEntitiesById.remove(id);
        }
    }

    private void unmanageDryRun(Entity e) {
        ManagementTransitionInfo info = new ManagementTransitionInfo(this.managementContext, ManagementTransitionMode.transitioning(BrooklynObjectManagementMode.NONEXISTENT, BrooklynObjectManagementMode.NONEXISTENT));
        log.debug("Unmanaging " + e + " (dry run)");
        this.discardPremanaged(e);
        ((EntityInternal)e).getManagementSupport().onManagementStopping(info, true);
        this.stopTasks(e);
        ((EntityInternal)e).getManagementSupport().onManagementStopped(info, true);
    }

    private void unmanage(Entity e, ManagementTransitionMode mode, boolean hasBeenReplaced) {
        if (this.shouldSkipUnmanagement(e, hasBeenReplaced)) {
            return;
        }
        final ManagementTransitionInfo info = new ManagementTransitionInfo(this.managementContext, mode);
        log.debug("Unmanaging " + e + " (mode " + mode + ", replaced " + hasBeenReplaced + ")");
        if (hasBeenReplaced) {
            if (!mode.wasReadOnly()) {
                if (!mode.wasPrimary()) {
                    log.warn("Unexpected mode " + mode + " for unmanage-replace " + e + " (applying anyway)");
                }
                ((EntityInternal)e).getManagementSupport().onManagementStopping(info, false);
                this.stopTasks(e);
                ((EntityInternal)e).getManagementSupport().onManagementStopped(info, false);
            }
            return;
        }
        if (mode.wasReadOnly() && mode.isNoLongerLoaded()) {
            ((EntityInternal)e).getManagementSupport().onManagementStopping(info, false);
            if (this.unmanageNonRecursive(e)) {
                this.stopTasks(e);
            }
            ((EntityInternal)e).getManagementSupport().onManagementStopped(info, false);
            this.managementContext.getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)e);
            if (this.managementContext.getGarbageCollector() != null) {
                this.managementContext.getGarbageCollector().onUnmanaged(e);
            }
        } else if (mode.wasPrimary() && mode.isNoLongerLoaded()) {
            final LinkedHashSet allEntities = new LinkedHashSet();
            int iteration = 0;
            do {
                MutableList entitiesToUnmanageRecursively = MutableList.of();
                if (iteration > 0) {
                    log.info("Re-running descendant unmanagement on descendants of " + e + " which were added concurrently during previous iteration: " + allEntities);
                    if (iteration >= 20) {
                        throw new IllegalStateException("Too many iterations detected trying to unmanage descendants of " + e + " (" + iteration + ")");
                    }
                    entitiesToUnmanageRecursively.addAll(allEntities);
                } else {
                    entitiesToUnmanageRecursively.add(e);
                }
                entitiesToUnmanageRecursively.forEach(ei -> this.recursively((Entity)ei, new Predicate<EntityInternal>(){

                    public boolean apply(EntityInternal it) {
                        if (LocalEntityManager.this.shouldSkipUnmanagement((Entity)it, false)) {
                            return false;
                        }
                        allEntities.add(it);
                        it.getManagementSupport().onManagementStopping(info, false);
                        return true;
                    }
                }));
                if (!allEntities.isEmpty()) {
                    MutableList allEntitiesExceptApp = MutableList.copyOf(allEntities);
                    EntityInternal app = (EntityInternal)allEntitiesExceptApp.remove(0);
                    Collections.reverse(allEntitiesExceptApp);
                    allEntitiesExceptApp.forEach(it -> BrooklynLoggingCategories.ENTITY_LIFECYCLE_LOG.debug("Deleting entity " + it.getId() + " (" + it + ") in application " + it.getApplicationId() + " for user " + Entitlements.getEntitlementContextUser()));
                    BrooklynLoggingCategories.APPLICATION_LIFECYCLE_LOG.debug("Deleting application " + app.getId() + " (" + app + ") mode " + mode + " for user " + Entitlements.getEntitlementContextUser());
                }
                for (EntityInternal it2 : allEntities) {
                    if (this.shouldSkipUnmanagement((Entity)it2, false) || !this.unmanageNonRecursive((Entity)it2)) continue;
                    this.stopTasks((Entity)it2);
                }
                for (EntityInternal it2 : allEntities) {
                    it2.getManagementSupport().onManagementStopped(info, false);
                    this.managementContext.getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)it2);
                    if (this.managementContext.getGarbageCollector() == null) continue;
                    this.managementContext.getGarbageCollector().onUnmanaged(e);
                }
                final LinkedHashSet allEntitiesAgain = new LinkedHashSet();
                allEntities.forEach(ei -> this.recursively((Entity)ei, new Predicate<EntityInternal>(){

                    public boolean apply(EntityInternal it) {
                        allEntitiesAgain.add(it);
                        return true;
                    }
                }));
                allEntitiesAgain.removeAll(allEntities);
                allEntities.clear();
                allEntities.addAll(allEntitiesAgain);
                ++iteration;
            } while (!allEntities.isEmpty());
        } else {
            log.warn("Invalid mode for unmanage: " + mode + " on " + e + " (ignoring)");
        }
        this.preRegisteredEntitiesById.remove(e.getId());
        this.preManagedEntitiesById.remove(e.getId());
        this.entityProxiesById.remove(e.getId());
        this.entitiesById.remove(e.getId());
        this.entityModesById.remove(e.getId());
    }

    private void stopTasks(Entity entity) {
        this.stopTasks(entity, null);
    }

    @Beta
    public void stopTasks(Entity entity, @Nullable Duration timeout) {
        CountdownTimer timeleft = timeout == null ? null : timeout.countdownTimer();
        MutableSet exceptions = MutableSet.of();
        try {
            Set tasks;
            boolean inTaskForThisEntity = entity.equals(BrooklynTaskTags.getContextEntity(Tasks.current()));
            Set<String> currentAncestorIds = null;
            MutableSet tasksCancelled = MutableSet.of();
            try {
                tasks = this.managementContext.getExecutionContext(entity).getTasks();
            }
            catch (Exception e) {
                log.debug("Unable to stop tasks for " + entity + "; probably it was added but management cancelled: " + e);
                log.trace("Trace for failure to stop tasks", (Throwable)e);
                return;
            }
            for (Task t : tasks) {
                if (inTaskForThisEntity) {
                    if (currentAncestorIds == null) {
                        currentAncestorIds = this.getAncestorTaskIds(Tasks.current());
                    }
                    if (this.getAncestorTaskIds(t).stream().anyMatch(currentAncestorIds::contains)) continue;
                }
                if (t.isDone()) continue;
                try {
                    log.debug("Cancelling " + t + " on " + entity);
                    tasksCancelled.add(t);
                    t.cancel(true);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    log.debug("Error cancelling " + t + " on " + entity + " (will warn when all tasks are cancelled): " + e, (Throwable)e);
                    exceptions.add(e);
                }
            }
            if (timeleft != null) {
                MutableSet tasksIncomplete = MutableSet.of();
                for (Task t : this.managementContext.getExecutionContext(entity).getTasks()) {
                    if (this.hasTaskAsAncestor(t, Tasks.current()) || Tasks.blockUntilInternalTasksEnded(t, timeleft.getDurationRemaining())) continue;
                    tasksIncomplete.add(t);
                }
                if (!tasksIncomplete.isEmpty()) {
                    log.warn("Incomplete tasks when stopping " + entity + ": " + tasksIncomplete);
                }
                if (log.isTraceEnabled()) {
                    log.trace("Cancelled " + tasksCancelled + " tasks for " + entity + ", with " + timeleft.getDurationRemaining() + " remaining (of " + timeout + "): " + tasksCancelled);
                }
            } else if (log.isTraceEnabled()) {
                log.trace("Cancelled " + tasksCancelled + " tasks for " + entity + ": " + tasksCancelled);
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Error inspecting tasks to cancel on unmanagement: " + e, (Throwable)e);
        }
        if (!exceptions.isEmpty()) {
            log.warn("Error when cancelling tasks for " + entity + " on unmanagement: " + Exceptions.create((Iterable)exceptions));
        }
    }

    private boolean hasTaskAsAncestor(Task<?> t, Task<?> potentialAncestor) {
        if (t == null || potentialAncestor == null) {
            return false;
        }
        if (t.equals(potentialAncestor)) {
            return true;
        }
        return this.hasTaskAsAncestor(t.getSubmittedByTask(), potentialAncestor);
    }

    private Set<String> getAncestorTaskIds(Task<?> t) {
        MutableList ancestorIds = MutableList.of();
        while (t != null) {
            ancestorIds.add(t.getId());
            t = t.getSubmittedByTask();
        }
        Collections.reverse(ancestorIds);
        return MutableSet.copyOf((Iterable)ancestorIds);
    }

    void manageIfNecessary(Entity entity, Object context) {
        Entity candidateUnmanagedParent;
        if (!this.isRunning()) {
            return;
        }
        if (((EntityInternal)entity).getManagementSupport().wasDeployed()) {
            return;
        }
        if (this.isManaged(entity)) {
            return;
        }
        if (this.isPreManaged(entity)) {
            return;
        }
        if (Boolean.TRUE.equals(((EntityInternal)entity).getManagementSupport().isReadOnly())) {
            return;
        }
        Entity rootUnmanaged = entity;
        while ((candidateUnmanagedParent = rootUnmanaged.getParent()) != null && !this.isManaged(candidateUnmanagedParent) && !this.isPreManaged(candidateUnmanagedParent)) {
            rootUnmanaged = candidateUnmanagedParent;
        }
        if (context == Startable.START.getName()) {
            log.info("Activating local management for {} on start", (Object)rootUnmanaged);
        } else {
            log.warn("Activating local management for {} due to effector invocation on {}: {}", new Object[]{rootUnmanaged, entity, context});
        }
        this.manage(rootUnmanaged);
    }

    private void recursively(Entity e, Predicate<EntityInternal> action) {
        boolean success;
        Entity otherPreregistered = this.preRegisteredEntitiesById.get(e.getId());
        if (otherPreregistered != null) {
            e = otherPreregistered;
        }
        if (!(success = action.apply((Object)((EntityInternal)e)))) {
            return;
        }
        for (Entity child : e.getChildren()) {
            this.recursively(child, action);
        }
    }

    private synchronized boolean isPreManaged(Entity e) {
        return this.preManagedEntitiesById.containsKey(e.getId());
    }

    private synchronized boolean preManageNonRecursive(Entity e, ManagementTransitionMode mode) {
        Entity realE = this.toRealEntity(e);
        Entity old = this.preManagedEntitiesById.put(e.getId(), realE);
        Entity pre = this.preRegisteredEntitiesById.remove(e.getId());
        if (old != null && mode.wasNotLoaded()) {
            if (!old.equals(e)) {
                throw new IllegalStateException("call to pre-manage entity " + e + " (" + mode + ") but different entity " + old + " already known under that id at " + this);
            }
            log.warn("{} redundant call to pre-start management of entity {}, mode {}; ignoring", new Object[]{this, e, mode});
            return false;
        }
        if (pre == null) {
            this.preManagedEntitiesById.remove(e.getId());
            throw new IllegalStateException("Entity " + e + " not known as pre-registered when starting management of it; probably it was unmanaged concurrently");
        }
        if (log.isTraceEnabled()) {
            log.trace("{} pre-start management of entity {}, mode {}", new Object[]{this, e, mode});
        }
        return true;
    }

    private synchronized boolean manageNonRecursive(Entity e, ManagementTransitionMode mode) {
        Entity proxyE;
        Entity old = this.entitiesById.get(e.getId());
        if (old != null && mode.wasNotLoaded()) {
            if (old != this.deproxyIfNecessary(e)) {
                throw new IdAlreadyExistsException("call to manage entity " + e + " (" + mode + ") but different entity " + old + " already known under that id '" + e.getId() + "' at " + this);
            }
            log.warn("{} redundant call to start management of entity {}; ignoring", (Object)this, (Object)e);
            return false;
        }
        BrooklynLogging.log(log, BrooklynLogging.levelDebugOrTraceIfReadOnly(e), "{} starting management of entity {}", this, e);
        Entity realE = this.toRealEntity(e);
        Entity oldProxy = (Entity)this.entityProxiesById.get(e.getId());
        if (oldProxy != null) {
            if (mode.wasNotLoaded()) {
                throw new IdAlreadyExistsException("call to manage entity " + e + " from unloaded state (" + mode + ") but already had proxy " + oldProxy + " already known under that id '" + e.getId() + "' at " + this);
            }
            ((EntityProxyImpl)Proxy.getInvocationHandler(oldProxy)).resetDelegate(oldProxy, oldProxy, realE);
            proxyE = oldProxy;
        } else {
            proxyE = this.toProxyEntityIfAvailable(e);
        }
        this.entityProxiesById.put(e.getId(), proxyE);
        this.entityTypes.put(e.getId(), realE.getClass().getName());
        this.entitiesById.put(e.getId(), realE);
        Entity preManaged = this.preManagedEntitiesById.remove(e.getId());
        if (preManaged == null) {
            log.warn(this + " cannot start management for " + e + " because it is not or no longer pre-managed; probably its ancestor was concurrently unmanaged (unmanaging then throwing)");
            this.unmanage(e, mode);
            throw new IllegalStateException(this + " cannot start management for " + e + " because it is not or no longer pre-managed; probably its ancestor was concurrently unmanaged");
        }
        if (e instanceof Application && e.getParent() == null) {
            this.applications.add((Application)proxyE);
            this.applicationIds.add(e.getId());
        }
        if (!this.entities.contains(proxyE)) {
            this.entities.add(proxyE);
        }
        if (old != null && old != e) {
            log.debug("Unmanaging previous instance {} being replaced by {} {}", new Object[]{old, e, mode});
            this.unmanage(old, mode, true);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unmanageNonRecursive(Entity e) {
        ManagementTransitionMode lastTM = this.getLastManagementTransitionMode(e.getId());
        if (lastTM != null && !lastTM.isReadOnly()) {
            e.clearParent();
            for (Object group : e.groups()) {
                if (Entities.isNoLongerManaged((Entity)group)) continue;
                group.removeMember(e);
            }
            if (e instanceof Group) {
                Collection members = ((Group)e).getMembers();
                for (Entity member : members) {
                    if (Entities.isNoLongerManaged(member)) continue;
                    ((EntityInternal)member).groups().remove((Group)e);
                }
            }
        } else {
            log.trace("No groups being updated on unmanage of read only {} (mode {})", (Object)e, (Object)lastTM);
        }
        this.unmanageOwnedLocations(e);
        LocalEntityManager localEntityManager = this;
        synchronized (localEntityManager) {
            Entity proxyE = this.toProxyEntityIfAvailable(e);
            if (e instanceof Application) {
                this.applications.remove(proxyE);
                this.applicationIds.remove(e.getId());
            }
            this.entities.remove(proxyE);
            this.entityProxiesById.remove(e.getId());
            ManagementTransitionMode oldMode = this.entityModesById.remove(e.getId());
            Entity old = this.entitiesById.remove(e.getId());
            this.entityTypes.remove(e.getId());
            if (old == null) {
                if (this.preRegisteredEntitiesById.remove(e.getId()) != null) {
                    log.info("{} stopping management of pre-pre-managed entity {} {}/{}; removed from pre-pre-managed list (management of that should fail)", new Object[]{this, e, oldMode, lastTM});
                    this.discardPremanaged(e);
                } else if (this.preManagedEntitiesById.remove(e.getId()) != null) {
                    log.info("{} stopping management of pre-managed entity {} {}/{}; removed from pre-managed list (promotion of that should fail)", new Object[]{this, e, oldMode, lastTM});
                    this.discardPremanaged(e);
                } else {
                    if (!Entities.isNoLongerManaged(e)) {
                        log.debug("Unexpected call to unmanage {}, possibly a race, delaying slightly to allow to complete");
                        log.trace("Trace for unexpected unmanage call", new Throwable("trace"));
                        Time.sleep((Duration)Duration.millis((Number)10));
                    }
                    if (Entities.isNoLongerManaged(e)) {
                        log.debug("Confirmed redundant call to unmanage {} (e.g. an entity ensuring things are removed by policy when also unmanaging)", (Object)e);
                    } else {
                        log.warn("{} call to stop management of unknown/unexpected entity (possibly due to redundant concurrent calls) {} {}/{}; ignoring", new Object[]{this, e, oldMode, lastTM});
                    }
                }
                return false;
            }
            if (!old.equals(e)) {
                log.error("{} call to stop management of entity {} removed different entity {} {}/{}", new Object[]{this, e, old, oldMode, lastTM});
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("{} stopped management of entity {} {}/{}", new Object[]{this, e, oldMode, lastTM});
            }
            return true;
        }
    }

    private void unmanageOwnedLocations(Entity e) {
        for (Location loc : e.getLocations()) {
            BrooklynTags.NamedStringTag ownerEntityTag = BrooklynTags.findFirstNamedStringTag("owner_entity_id", loc.tags().getTags());
            if (ownerEntityTag == null) continue;
            if (e.getId().equals(ownerEntityTag.getContents())) {
                this.managementContext.getLocationManager().unmanage(loc);
                continue;
            }
            log.debug("Unmanaging entity {}, which contains a location {} owned by another entity {}. Not automatically unmanaging the location (it will be unmanaged when its owning entity is unmanaged).", new Object[]{e, loc, ownerEntityTag.getContents()});
        }
    }

    void addEntitySetListener(CollectionChangeListener<Entity> listener) {
        AsyncCollectionChangeAdapter<Entity> wrappedListener = new AsyncCollectionChangeAdapter<Entity>(this.managementContext.getExecutionManager(), listener);
        this.entities.addListener(wrappedListener);
    }

    void removeEntitySetListener(CollectionChangeListener<Entity> listener) {
        AsyncCollectionChangeAdapter<Entity> wrappedListener = new AsyncCollectionChangeAdapter<Entity>(this.managementContext.getExecutionManager(), listener);
        this.entities.removeListener(wrappedListener);
    }

    private boolean shouldSkipUnmanagement(Entity e, boolean hasBeenReplaced) {
        if (e == null) {
            log.warn("" + this + " call to unmanage null entity; skipping", (Throwable)new IllegalStateException("source of null unmanagement call to " + this));
            return true;
        }
        if (!this.isManaged(e)) {
            if (!hasBeenReplaced) {
                if (((EntityInternal)e).getManagementSupport().wasDeployed() && !Entities.isNoLongerManaged(e)) {
                    log.debug("Unexpected call to skippable unmanagement of {}, possibly a race, delaying slightly to allow to complete");
                    log.trace("Trace for unexpected unmanage call", new Throwable("trace"));
                    Time.sleep((Duration)Duration.millis((Number)10));
                }
                if (Entities.isNoLongerManaged(e)) {
                    log.debug("Confirmed redundant call to skippable unmanage {} (e.g. an entity ensuring things are removed by policy when also unmanaging); skipping, and all descendants", (Object)e);
                } else if (!((EntityInternal)e).getManagementSupport().wasDeployed()) {
                    log.debug("Call to unmanage {} which is not (yet?) deployed; assume concurrent creator will unmanage; here we are skipping, and all descendants", (Object)e);
                } else {
                    log.warn("{} call to skippable unmanagement of unknown/unexpected entity (possibly due to redundant concurrent calls); skipping, and all descendants", (Object)this, (Object)e);
                }
            } else {
                log.trace("{} call to unmanagement of replaced entity (previous already unmanaged?) {}; skipping, and all descendants", (Object)this, (Object)e);
            }
            return true;
        }
        return false;
    }

    private Entity toProxyEntityIfAvailable(Entity e) {
        Preconditions.checkNotNull((Object)e, (Object)"entity");
        if (e instanceof EntityProxy) {
            return e;
        }
        if (e instanceof AbstractEntity) {
            Entity result = ((AbstractEntity)e).getProxy();
            return result == null ? e : result;
        }
        return e;
    }

    private Entity toRealEntity(Entity e) {
        Preconditions.checkNotNull((Object)e, (Object)"entity");
        if (e instanceof AbstractEntity) {
            return e;
        }
        Entity result = this.toRealEntityOrNull(e.getId());
        if (result == null) {
            throw new IllegalStateException("No concrete entity known for entity " + e + " (" + e.getId() + ", " + e.getEntityType().getName() + ")");
        }
        return result;
    }

    public boolean isKnownEntityId(String id) {
        return this.entitiesById.containsKey(id) || this.preManagedEntitiesById.containsKey(id) || this.preRegisteredEntitiesById.containsKey(id);
    }

    private Entity toRealEntityOrNull(String id) {
        Entity result = this.preRegisteredEntitiesById.get(id);
        if (result == null) {
            result = this.preManagedEntitiesById.get(id);
        }
        if (result == null) {
            this.entitiesById.get(id);
        }
        return result;
    }

    private Entity deproxyIfNecessary(Entity e) {
        return e instanceof AbstractEntity ? e : Entities.deproxy(e);
    }

    private boolean isRunning() {
        return this.managementContext.isRunning();
    }
}

