/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.core.mgmt.ManagementContextInjectable;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.usage.ManagementNodeStateListener;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.util.core.ClassLoaderUtils;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagementNodeStateListenerManager
implements ManagementNodeStateListener {
    private static final Logger LOG = LoggerFactory.getLogger(ManagementNodeStateListenerManager.class);
    private final ManagementContextInternal mgmt;
    private final Object mutex = new Object();
    private final Object waitForMasterRebindMutex = new Object();
    private volatile boolean terminated;
    private final List<ManagementNodeStateListener> listeners = Lists.newCopyOnWriteArrayList();
    private ManagementNodeState lastPublishedVal;
    private final AtomicInteger listenerQueueSize = new AtomicInteger();
    private ListeningExecutorService listenerExecutor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("brooklyn-managementnodestate-listener-%d").build()));

    public ManagementNodeStateListenerManager(ManagementContextInternal managementContext) {
        this.mgmt = (ManagementContextInternal)Preconditions.checkNotNull((Object)managementContext, (Object)"managementContext");
        TypeCoercions.BrooklynCommonAdaptorTypeCoercions.registerInstanceForClassnameAdapter(new ClassLoaderUtils(this.getClass(), (ManagementContext)managementContext), ManagementNodeStateListener.class);
        Collection rawListeners = managementContext.getBrooklynProperties().getConfig(BrooklynServerConfig.MANAGEMENT_NODE_STATE_LISTENERS);
        if (rawListeners != null) {
            for (Object obj : rawListeners) {
                if (obj == null) {
                    throw new NullPointerException("null listener in config " + BrooklynServerConfig.MANAGEMENT_NODE_STATE_LISTENERS);
                }
                if (!(obj instanceof ManagementNodeStateListener)) {
                    throw new ClassCastException("Configured object is not a " + ManagementNodeStateListener.class.getSimpleName() + ". This probably means coercion failed: " + obj);
                }
                ManagementNodeStateListener listener = (ManagementNodeStateListener)obj;
                if (listener instanceof ManagementContextInjectable) {
                    ((ManagementContextInjectable)((Object)listener)).setManagementContext(managementContext);
                }
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStateChange(final ManagementNodeState state) {
        Object object = this.mutex;
        synchronized (object) {
            if (state != null && this.lastPublishedVal != state) {
                LOG.debug("Notifying {} listener(s) of management-node state changed to {}", new Object[]{this.listeners.size(), state});
                this.lastPublishedVal = state;
                this.execOnListeners(new Function<ManagementNodeStateListener, Void>(){

                    public Void apply(ManagementNodeStateListener listener) {
                        boolean success;
                        if (state == ManagementNodeState.MASTER && !(success = ManagementNodeStateListenerManager.this.waitForMasterNotRebinding())) {
                            LOG.info("Not notifying listener {} of management-node state {} because did not finish rebinding", new Object[]{listener, state});
                            return null;
                        }
                        listener.onStateChange(state);
                        return null;
                    }

                    public String toString() {
                        return "stateChange(" + state + ")";
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForMasterNotRebinding() {
        while (true) {
            boolean abort;
            boolean awaitingRebind = this.mgmt.getRebindManager().isAwaitingInitialRebind();
            ManagementNodeState state = this.mgmt.getHighAvailabilityManager().getNodeState();
            boolean bl = abort = state != ManagementNodeState.MASTER || this.terminated || !this.mgmt.isRunning();
            if (abort) {
                return false;
            }
            if (!awaitingRebind) {
                return true;
            }
            Object object = this.waitForMasterRebindMutex;
            synchronized (object) {
                try {
                    this.waitForMasterRebindMutex.wait(100L);
                }
                catch (InterruptedException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.terminated = true;
        Object object = this.waitForMasterRebindMutex;
        synchronized (object) {
            this.waitForMasterRebindMutex.notifyAll();
        }
        Duration timeout = this.mgmt.getBrooklynProperties().getConfig(BrooklynServerConfig.MANAGEMENT_NODE_STATE_LISTENER_TERMINATION_TIMEOUT);
        if (this.listenerQueueSize.get() > 0) {
            LOG.info("Management-node-state-listener manager waiting for " + this.listenerQueueSize + " listener events for up to " + timeout);
        }
        ArrayList futures = Lists.newArrayList();
        for (final ManagementNodeStateListener listener : this.listeners) {
            ListenableFuture future = this.listenerExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    if (listener instanceof Closeable) {
                        try {
                            ((Closeable)((Object)listener)).close();
                        }
                        catch (IOException | RuntimeException e) {
                            LOG.warn("Problem closing management-node-state listener " + listener, (Throwable)e);
                            Exceptions.propagateIfFatal((Throwable)e);
                        }
                    }
                }
            });
            futures.add(future);
        }
        try {
            Futures.successfulAsList((Iterable)futures).get(timeout.toMilliseconds(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            LOG.warn("Problem terminiating management-node-state listeners (continuing)", (Throwable)e);
        }
        finally {
            this.listenerExecutor.shutdownNow();
        }
    }

    private void execOnListeners(final Function<ManagementNodeStateListener, Void> job) {
        for (final ManagementNodeStateListener listener : this.listeners) {
            this.listenerQueueSize.incrementAndGet();
            this.listenerExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        job.apply((Object)listener);
                    }
                    catch (RuntimeException e) {
                        LOG.error("Problem notifying listener " + listener + " of " + job, (Throwable)e);
                        Exceptions.propagateIfFatal((Throwable)e);
                    }
                    finally {
                        ManagementNodeStateListenerManager.this.listenerQueueSize.decrementAndGet();
                    }
                }
            });
        }
    }
}

