/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.persist;

import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.brooklyn.api.mgmt.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnwantedStateLoggingMapper
extends MapperWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(UnwantedStateLoggingMapper.class);
    private static final AtomicLong WARN_CNT = new AtomicLong();
    private static Class<?>[] TYPES_TO_WARN_IF_SERIALIZE = new Class[]{Task.class, Thread.class, ThreadLocal.class};

    public UnwantedStateLoggingMapper(Mapper wrapped) {
        super(wrapped);
    }

    public String serializedClass(Class type) {
        this.logIfInteresting(type);
        return super.serializedClass(type);
    }

    private void logIfInteresting(Class<?> type) {
        if (type != null) {
            for (Class<?> warnClass : TYPES_TO_WARN_IF_SERIALIZE) {
                long cnt;
                if (!warnClass.isAssignableFrom(type) || (cnt = WARN_CNT.getAndIncrement()) >= 5L && cnt % 10000L != 0L) continue;
                LOG.warn("Trying to serialize a " + warnClass.getSimpleName() + " object of type " + type + " which could lead to unexpected behaviour upon rebind. " + warnClass.getSimpleName() + " object serialization is not supported or recommended. Check if the " + warnClass.getSimpleName() + " object (or its container) is set as a config or sensor value by mistake.");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Serializing object of type " + type.getName());
            }
        }
    }
}

