/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.catalog.CatalogConfig;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.location.PortRange;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynType;
import org.apache.brooklyn.api.objs.SpecParameter;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigInheritance;
import org.apache.brooklyn.config.ConfigInheritances;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigInheritance;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.objs.BrooklynDynamicType;
import org.apache.brooklyn.core.objs.BrooklynTypes;
import org.apache.brooklyn.core.objs.ConstraintSerialization;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.BrooklynTypeNameResolution;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.guava.TypeTokens;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicSpecParameter<T>
implements SpecParameter<T> {
    private static final long serialVersionUID = -4728186276307619778L;
    private static final Logger log = LoggerFactory.getLogger(BasicSpecParameter.class);
    private final String label;
    @Beta
    private final boolean pinned;
    private final ConfigKey<T> configKey;
    private final AttributeSensor<?> sensor;
    private ConfigKey<T> type;

    private Object readResolve() {
        if (this.type != null && this.configKey == null) {
            return new BasicSpecParameter<T>(this.label, this.pinned, this.type, this.sensor);
        }
        return this;
    }

    @Beta
    public BasicSpecParameter(String label, boolean pinned, ConfigKey<T> config) {
        this(label, pinned, config, null);
    }

    @Beta
    public <SensorType> BasicSpecParameter(String label, boolean pinned, ConfigKey<T> config, AttributeSensor<SensorType> sensor) {
        this.label = label;
        this.pinned = pinned;
        this.configKey = config;
        this.sensor = sensor;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public ConfigKey<T> getConfigKey() {
        return this.configKey;
    }

    public AttributeSensor<?> getSensor() {
        return this.sensor;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.configKey});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicSpecParameter other = (BasicSpecParameter)obj;
        return Objects.equal(this.configKey, other.configKey);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("label", (Object)this.label).add("pinned", this.pinned).add("type", this.configKey).toString();
    }

    public static List<SpecParameter<?>> parseParameterDefinitionList(List<?> obj, Function<Object, Object> specialFlagsTransformer, BrooklynClassLoadingContext loader) {
        return ParseYamlInputs.parseParameters(obj, (Function<Object, Object>)specialFlagsTransformer, loader);
    }

    public static List<SpecParameter<?>> fromClass(ManagementContext mgmt, Class<?> type) {
        return ParseClassParameters.collectParameters(BasicSpecParameter.getImplementedBy(mgmt, type));
    }

    public static List<SpecParameter<?>> fromSpec(ManagementContext mgmt, AbstractBrooklynObjectSpec<?, ?> spec) {
        EntitySpec entitySpec;
        if (!spec.getParameters().isEmpty()) {
            return spec.getParameters();
        }
        Class type = null;
        if (spec instanceof EntitySpec && (entitySpec = (EntitySpec)spec).getImplementation() != null) {
            type = entitySpec.getImplementation();
        }
        if (type == null) {
            type = BasicSpecParameter.getImplementedBy(mgmt, spec.getType());
        }
        return ParseClassParameters.collectParameters(BasicSpecParameter.getImplementedBy(mgmt, type));
    }

    private static Class<?> getImplementedBy(ManagementContext mgmt, Class<?> type) {
        if (Entity.class.isAssignableFrom(type) && type.isInterface()) {
            try {
                Class uncheckedType = ParseClassParameters.getEntityImplementedBy(mgmt, type);
                return uncheckedType;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return type;
    }

    @Beta
    public static void initializeSpecWithExplicitParameters(AbstractBrooklynObjectSpec<?, ?> spec, List<? extends SpecParameter<?>> explicitParams, BrooklynClassLoadingContext loader) {
        if (spec.getParameters().isEmpty()) {
            spec.parametersAdd(BasicSpecParameter.fromSpec(loader.getManagementContext(), spec));
        }
        spec.parametersReplace(BasicSpecParameter.resolveParameters(explicitParams, spec));
    }

    private static Collection<SpecParameter<?>> resolveParameters(Collection<? extends SpecParameter<?>> newParams, AbstractBrooklynObjectSpec<?, ?> spec) {
        List existingReferenceParams = spec.getParameters();
        MutableMap existingToKeep = MutableMap.of();
        if (existingReferenceParams != null) {
            for (SpecParameter p : existingReferenceParams) {
                if (!ConfigInheritances.isKeyReinheritable((ConfigKey)p.getConfigKey(), (ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.TYPE_DEFINITION)) continue;
                existingToKeep.put(p.getConfigKey().getName(), p);
            }
        }
        MutableList result = MutableList.of();
        if (newParams != null) {
            for (SpecParameter<?> p : newParams) {
                SpecParameter existingP = (SpecParameter)existingToKeep.get(p.getConfigKey().getName());
                if (p instanceof SpecParameterIncludingDefinitionForInheritance) {
                    p = ((SpecParameterIncludingDefinitionForInheritance)p).resolveWithAncestor(existingP);
                } else {
                    log.warn("Found non-definitional spec parameter: " + p + " adding to " + spec);
                }
                if (existingP != null) {
                    existingToKeep.put(p.getConfigKey().getName(), p);
                    continue;
                }
                result.add(p);
            }
        }
        result.addAll(existingToKeep.values());
        return result;
    }

    @Beta
    static class SpecParameterIncludingDefinitionForInheritance<T>
    extends BasicSpecParameter<T> {
        private final boolean hasType;
        private final boolean hasLabelSet;
        private final boolean hasPinnedSet;
        private final boolean hasDefaultValue;
        private final boolean hasConstraints;
        private final boolean hasRuntimeInheritance;
        private final boolean hasTypeInheritance;

        private <SensorType> SpecParameterIncludingDefinitionForInheritance(String label, Boolean pinned, ConfigKey<T> config, AttributeSensor<SensorType> sensor, boolean hasType, boolean hasDefaultValue, boolean hasConstraints, boolean hasRuntimeInheritance, boolean hasTypeInheritance) {
            super((String)Preconditions.checkNotNull((Object)(label != null ? label : config.getName()), (Object)"label or config name must be set"), pinned == null ? true : pinned, config, sensor);
            this.hasType = hasType;
            this.hasLabelSet = label != null;
            this.hasPinnedSet = pinned != null;
            this.hasDefaultValue = hasDefaultValue;
            this.hasConstraints = hasConstraints;
            this.hasRuntimeInheritance = hasRuntimeInheritance;
            this.hasTypeInheritance = hasTypeInheritance;
        }

        SpecParameter<?> resolveWithAncestor(SpecParameter<?> ancestor) {
            if (ancestor == null) {
                return new BasicSpecParameter(this.getLabel(), this.isPinned(), this.getConfigKey(), this.getSensor());
            }
            return new BasicSpecParameter(this.hasLabelSet ? this.getLabel() : ancestor.getLabel(), this.hasPinnedSet ? this.isPinned() : ancestor.isPinned(), this.resolveWithAncestorConfigKey(ancestor.getConfigKey()), this.hasType ? this.getSensor() : ancestor.getSensor());
        }

        private ConfigKey<?> resolveWithAncestorConfigKey(ConfigKey<?> ancestor) {
            ConfigKey dominant = this.getConfigKey();
            return ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)ConfigKeys.builder((this.hasType ? dominant : ancestor).getTypeToken()).name(dominant.getName())).description((dominant.getDescription() != null ? dominant : ancestor).getDescription())).defaultValue((Object)(this.hasDefaultValue ? dominant : ancestor).getDefaultValue())).constraint((this.hasConstraints ? dominant : ancestor).getConstraint())).runtimeInheritance((this.hasRuntimeInheritance ? dominant : ancestor).getInheritanceByContext((ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.RUNTIME_MANAGEMENT))).typeInheritance((this.hasTypeInheritance ? dominant : ancestor).getInheritanceByContext((ConfigInheritance.ConfigInheritanceContext)ConfigKeys.InheritanceContext.TYPE_DEFINITION))).build();
        }

        public boolean isHasDefaultValue() {
            return this.hasDefaultValue;
        }

        public boolean isHasConstraints() {
            return this.hasConstraints;
        }

        public boolean isHasRuntimeInheritance() {
            return this.hasRuntimeInheritance;
        }

        public boolean isHasTypeInheritance() {
            return this.hasTypeInheritance;
        }
    }

    private static final class ParseClassParameters {
        private ParseClassParameters() {
        }

        static List<SpecParameter<?>> collectParameters(Class<?> c) {
            MutableList parameters = MutableList.of();
            if (BrooklynObject.class.isAssignableFrom(c)) {
                Class<?> brooklynClass = c;
                BrooklynDynamicType<?, ?> dynamicType = BrooklynTypes.getDefinedBrooklynType(brooklynClass);
                BrooklynType type = dynamicType.getSnapshot();
                for (ConfigKey x : type.getConfigKeys()) {
                    WeightedParameter fieldConfig = ParseClassParameters.getFieldConfig(x, dynamicType.getConfigKeyField(x.getName()));
                    parameters.appendIfNotNull((Object)fieldConfig);
                }
                Collections.sort(parameters, new WeightedParameterComparator());
                return FluentIterable.from((Iterable)parameters).transform((Function)new SpecParameterTransformer()).toList();
            }
            return ImmutableList.of();
        }

        public static WeightedParameter getFieldConfig(ConfigKey<?> config, Field configKeyField) {
            if (configKeyField == null) {
                return null;
            }
            CatalogConfig catalogConfig = configKeyField.getAnnotation(CatalogConfig.class);
            String label = config.getName();
            Double priority = null;
            Boolean pinned = Boolean.FALSE;
            if (catalogConfig != null) {
                label = (String)Maybe.fromNullable((Object)catalogConfig.label()).or((Object)config.getName());
                priority = catalogConfig.priority();
                pinned = catalogConfig.pinned();
            }
            BasicSpecParameter param = new BasicSpecParameter(label, pinned, config);
            return new WeightedParameter(priority, param);
        }

        private static <T extends Entity> Class<? extends T> getEntityImplementedBy(ManagementContext mgmt, Class<T> type) {
            return mgmt.getEntityManager().getEntityTypeRegistry().getImplementedBy(type);
        }

        private static final class SpecParameterTransformer
        implements Function<WeightedParameter, SpecParameter<?>> {
            private SpecParameterTransformer() {
            }

            public SpecParameter<?> apply(WeightedParameter input) {
                return input.getInput();
            }
        }

        private static final class WeightedParameterComparator
        implements Comparator<WeightedParameter> {
            private WeightedParameterComparator() {
            }

            @Override
            public int compare(WeightedParameter o1, WeightedParameter o2) {
                if (o1.getWeight() == null && o2.getWeight() == null) {
                    return o1.getInput().getLabel().compareTo(o2.getInput().getLabel());
                }
                if (o1.getWeight() == null) {
                    return 1;
                }
                if (o2.getWeight() == null) {
                    return -1;
                }
                return -Double.compare(o1.getWeight(), o2.getWeight());
            }
        }

        private static final class WeightedParameter {
            private Double weight;
            private SpecParameter<?> input;

            public WeightedParameter(Double weight, SpecParameter<?> input) {
                this.weight = weight;
                this.input = input;
            }

            public Double getWeight() {
                return this.weight;
            }

            public SpecParameter<?> getInput() {
                return this.input;
            }
        }
    }

    private static final class ParseYamlInputs {
        private ParseYamlInputs() {
        }

        private static List<SpecParameter<?>> parseParameters(List<?> inputsRaw, Function<Object, Object> specialFlagTransformer, BrooklynClassLoadingContext loader) {
            if (inputsRaw == null) {
                return ImmutableList.of();
            }
            ArrayList inputs = new ArrayList(inputsRaw.size());
            for (Object obj : inputsRaw) {
                inputs.add(ParseYamlInputs.parseParameter(obj, specialFlagTransformer, loader));
            }
            return inputs;
        }

        private static SpecParameterIncludingDefinitionForInheritance<?> parseParameter(Object obj, Function<Object, Object> specialFlagTransformer, BrooklynClassLoadingContext loader) {
            ConfigKey configType;
            ConfigInheritance runtimeInheritance;
            boolean hasRuntimeInheritance;
            Object inputDef;
            if (obj instanceof String) {
                inputDef = ImmutableMap.of((Object)"name", (Object)obj);
            } else if (obj instanceof Map) {
                inputDef = (Map)obj;
            } else {
                throw new IllegalArgumentException("Catalog input definition expected to be a map, but is " + obj.getClass() + " instead: " + obj);
            }
            String name = (String)inputDef.get("name");
            Collection deprecatedNames = (Collection)inputDef.get("deprecatedNames");
            String label = (String)inputDef.get("label");
            String description = (String)inputDef.get("description");
            String type = (String)inputDef.get("type");
            Boolean pinned = (Boolean)inputDef.get("pinned");
            boolean hasDefaultValue = inputDef.containsKey("default");
            Object defaultValue = inputDef.get("default");
            if (specialFlagTransformer != null) {
                defaultValue = specialFlagTransformer.apply(defaultValue);
            }
            boolean hasConstraints = inputDef.containsKey("constraints");
            Predicate<?> constraint = ParseYamlInputs.parseConstraints(inputDef.get("constraints"), loader);
            if (inputDef.containsKey("inheritance.runtime")) {
                hasRuntimeInheritance = true;
                runtimeInheritance = ParseYamlInputs.parseInheritance(inputDef.get("inheritance.runtime"), loader);
            } else if (inputDef.containsKey("inheritance.parent")) {
                log.warn("Using deprecated key 'inheritance.parent' for " + inputDef + "; replace with 'inheritance.runtime'");
                hasRuntimeInheritance = true;
                runtimeInheritance = ParseYamlInputs.parseInheritance(inputDef.get("inheritance.parent"), loader);
            } else {
                hasRuntimeInheritance = false;
                runtimeInheritance = null;
            }
            boolean hasTypeInheritance = inputDef.containsKey("inheritance.type");
            ConfigInheritance typeInheritance = ParseYamlInputs.parseInheritance(inputDef.get("inheritance.type"), loader);
            Boolean isReconfigurable = TypeCoercions.coerce(inputDef.get("reconfigurable"), Boolean.class);
            if (name == null) {
                throw new IllegalArgumentException("'name' value missing from input definition " + obj + " but is required. Check for typos.");
            }
            PortAttributeSensorAndConfigKey sensorType = null;
            boolean hasType = type != null;
            TypeToken<?> typeToken = ParseYamlInputs.resolveType(type, loader);
            Object immutableDefaultValue = ParseYamlInputs.tryToImmutable(defaultValue, typeToken);
            Object builder = ((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)((BasicConfigKey.Builder)BasicConfigKey.builder(typeToken).name(name)).deprecatedNames((Collection<String>)(deprecatedNames == null ? ImmutableList.of() : deprecatedNames))).description(description)).defaultValue((Object)immutableDefaultValue)).constraint(constraint)).runtimeInheritance(runtimeInheritance)).typeInheritance(typeInheritance);
            if (isReconfigurable != null) {
                ((BasicConfigKey.Builder)builder).reconfigurable(isReconfigurable);
            }
            if (TypeTokens.equalsRaw(PortRange.class, typeToken)) {
                sensorType = new PortAttributeSensorAndConfigKey((BasicConfigKey.Builder<PortRange, ?>)builder);
                configType = ((ConfigKey.HasConfigKey)sensorType).getConfigKey();
            } else {
                configType = ((BasicConfigKey.Builder)builder).build();
            }
            return new SpecParameterIncludingDefinitionForInheritance(label, pinned, configType, sensorType, hasType, hasDefaultValue, hasConstraints, hasRuntimeInheritance, hasTypeInheritance);
        }

        private static Object tryToImmutable(Object val, TypeToken<?> type) {
            Object result;
            if (TypeTokens.isAssignableFromRaw(Set.class, type) && val instanceof Iterable) {
                result = Collections.unmodifiableSet(MutableSet.copyOf((Iterable)((Iterable)val)));
            } else if (val instanceof Iterable) {
                result = Collections.unmodifiableList(MutableList.copyOf((Iterable)((Iterable)val)));
            } else if (val instanceof Map) {
                result = Collections.unmodifiableMap(MutableMap.copyOf((Map)((Map)val)));
            } else {
                return val;
            }
            if (type != null && !TypeTokens.isInstanceRaw(type, (Object)result)) {
                log.trace("Unable to convert parameter default value (type " + type + ") to immutable");
                return val;
            }
            return result;
        }

        private static TypeToken<?> resolveType(String typeRaw, BrooklynClassLoadingContext loader) {
            if (typeRaw == null) {
                return TypeToken.of(String.class);
            }
            return new BrooklynTypeNameResolution.BrooklynTypeNameResolver("parameter", loader, true, true).getTypeToken(typeRaw);
        }

        private static Predicate<?> parseConstraints(Object obj, BrooklynClassLoadingContext loader) {
            Object constraintsRaw;
            if (obj == null) {
                constraintsRaw = ImmutableList.of();
            } else if (obj instanceof String) {
                constraintsRaw = ImmutableList.of((Object)obj);
            } else if (obj instanceof List) {
                constraintsRaw = (List)obj;
            } else {
                throw new IllegalArgumentException("The constraint '" + obj + "' for a catalog input is invalid format - string or list supported");
            }
            ArrayList constraints = new ArrayList(constraintsRaw.size());
            Iterator iterator = constraintsRaw.iterator();
            while (iterator.hasNext()) {
                Object untypedConstraint = iterator.next();
                constraints.add(ParseYamlInputs.parseConstraint(untypedConstraint, loader));
            }
            if (!constraints.isEmpty()) {
                if (constraints.size() == 1) {
                    return (Predicate)constraints.get(0);
                }
                return Predicates.and(constraints);
            }
            return Predicates.alwaysTrue();
        }

        private static Predicate<?> parseConstraint(Object untypedConstraint, BrooklynClassLoadingContext loader) {
            return ConstraintSerialization.INSTANCE.toPredicateFromJson(untypedConstraint);
        }

        private static ConfigInheritance parseInheritance(Object obj, BrooklynClassLoadingContext loader) {
            if (obj == null || obj instanceof String) {
                return BasicConfigInheritance.fromString((String)obj);
            }
            throw new IllegalArgumentException("The config-inheritance '" + obj + "' for a catalog input is invalid format - string supported");
        }
    }
}

