/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.google.common.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.mgmt.internal.EntityManagerInternal;
import org.apache.brooklyn.core.mgmt.internal.NonDeploymentManagementContext;
import org.apache.brooklyn.core.resolve.jackson.AsPropertyIfAmbiguous;
import org.apache.brooklyn.core.resolve.jackson.BeanWithTypeUtils;
import org.apache.brooklyn.core.resolve.jackson.BrooklynJacksonSerializationUtils;
import org.apache.brooklyn.core.resolve.jackson.JsonSymbolDependentDeserializer;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.flags.BrooklynTypeNameResolution;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.javalang.Boxing;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonTypesSerialization {
    private static final Logger LOG = LoggerFactory.getLogger(CommonTypesSerialization.class);

    public static void apply(ObjectMapper mapper) {
        CommonTypesSerialization.apply(mapper, null);
    }

    public static void apply(ObjectMapper mapper, ManagementContext mgmt) {
        SimpleModule m = new SimpleModule();
        InterceptibleDeserializers interceptible = new InterceptibleDeserializers();
        m.setDeserializers((SimpleDeserializers)interceptible);
        new DurationSerialization().apply(m);
        new DateSerialization().apply(m);
        new ByteArrayObjectStreamSerialization().apply(m);
        new InstantSerialization().apply(m);
        new ManagementContextSerialization(mgmt).apply(m);
        new BrooklynObjectSerialization(mgmt).apply(m, interceptible);
        new ConfigKeySerialization(mgmt).apply(m);
        new PredicateSerialization(mgmt).apply(m);
        new GuavaTypeTokenSerialization().apply(mapper, m, interceptible);
        mapper.registerModule((Module)m);
    }

    public static class GuavaTypeTokenSerialization
    extends BeanSerializerModifier {
        public static final String RUNTIME_TYPE = "runtimeType";

        public void apply(ObjectMapper m, SimpleModule module, InterceptibleDeserializers interceptible) {
            m.setSerializerFactory(m.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)this));
            TypeTokenDeserializer ttDeserializer = new TypeTokenDeserializer();
            interceptible.addSubtypeInterceptor(TypeToken.class, ttDeserializer);
            module.addDeserializer(TypeToken.class, (JsonDeserializer)ttDeserializer);
            ParameterizedTypeDeserializer ptDeserializer = new ParameterizedTypeDeserializer();
            interceptible.addSubtypeInterceptor(ParameterizedType.class, ptDeserializer);
            module.addDeserializer(ParameterizedType.class, (JsonDeserializer)ptDeserializer);
            module.addDeserializer(Type.class, (JsonDeserializer)new JavaLangTypeDeserializer());
        }

        public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
            if (TypeToken.class.isAssignableFrom(beanDesc.getBeanClass())) {
                beanProperties = beanProperties.stream().filter(p -> RUNTIME_TYPE.equals(p.getName())).collect(Collectors.toList());
            }
            return beanProperties;
        }

        static class JavaLangTypeDeserializer
        extends JsonSymbolDependentDeserializer {
            JavaLangTypeDeserializer() {
            }

            @Override
            public JavaType getDefaultType() {
                return this.ctxt.constructType(Class.class);
            }

            @Override
            protected JsonDeserializer<?> getTokenDeserializer() throws IOException {
                return BrooklynJacksonSerializationUtils.createBeanDeserializer(this.ctxt, this.getDefaultType());
            }
        }

        static class RuntimeTypeHolder {
            private Type runtimeType;

            RuntimeTypeHolder() {
            }

            private void setType(Object type) {
            }
        }

        static class ParameterizedTypeDeserializer
        extends JsonSymbolDependentDeserializer {
            ParameterizedTypeDeserializer() {
            }

            @Override
            public JavaType getDefaultType() {
                return this.ctxt.constructType(BrooklynTypeNameResolution.BetterToStringParameterizedTypeImpl.class);
            }

            @Override
            public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
                super.createContextual(ctxt, property);
                this.type = this.getDefaultType();
                return this;
            }
        }

        static class TypeTokenDeserializer
        extends JsonSymbolDependentDeserializer {
            TypeTokenDeserializer() {
            }

            @Override
            public JavaType getDefaultType() {
                return this.ctxt.constructType(RuntimeTypeHolder.class);
            }

            @Override
            protected Object deserializeObject(JsonParser p) throws IOException {
                Object holder = this.contextualize(BrooklynJacksonSerializationUtils.createBeanDeserializer(this.ctxt, this.getDefaultType())).deserialize(p, this.ctxt);
                return TypeToken.of((Type)((RuntimeTypeHolder)holder).runtimeType);
            }
        }
    }

    public static class PredicateSerialization {
        private final ManagementContext mgmt;

        public PredicateSerialization(ManagementContext mgmt) {
            this.mgmt = mgmt;
        }

        public void apply(SimpleModule m) {
            DslPredicates.DslPredicateJsonDeserializer.DSL_REGISTERED_CLASSES.forEach(t -> m.addDeserializer(t, (JsonDeserializer)new DslPredicates.DslPredicateJsonDeserializer()));
        }
    }

    public static class ConfigKeySerialization {
        private final ManagementContext mgmt;

        public ConfigKeySerialization(ManagementContext mgmt) {
            this.mgmt = mgmt;
        }

        public void apply(SimpleModule m) {
            m.addKeyDeserializer(ConfigKey.class, (KeyDeserializer)new CKKeyDeserializer());
        }

        static class CKKeyDeserializer
        extends KeyDeserializer {
            CKKeyDeserializer() {
            }

            public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
                return ConfigKeys.newConfigKey(Object.class, key);
            }
        }
    }

    public static class BrooklynObjectSerialization
    extends ObjectAsStringSerializerAndDeserializer<BrooklynObject> {
        private final ManagementContext mgmt;

        public BrooklynObjectSerialization(ManagementContext mgmt) {
            this.mgmt = mgmt;
        }

        public <T extends SimpleModule> T apply(T module, InterceptibleDeserializers interceptable) {
            interceptable.addSubtypeInterceptor(this.getType(), this.newDeserializer());
            return this.apply(module);
        }

        @Override
        public Class<BrooklynObject> getType() {
            return BrooklynObject.class;
        }

        @Override
        public Class<? extends BrooklynObject> getType(Object instance) {
            return BrooklynObjectType.of((BrooklynObject)((BrooklynObject)instance)).getInterfaceType();
        }

        @Override
        public String convertObjectToString(BrooklynObject value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            return value.getId();
        }

        @Override
        public BrooklynObject convertStringToObject(String value, JsonParser p, DeserializationContext ctxt) throws IOException {
            if (this.mgmt == null) {
                throw new IllegalArgumentException("BrooklynObject cannot be deserialized here");
            }
            BrooklynObject result = this.mgmt.lookup(value);
            if (result != null) {
                return result;
            }
            Entity currentEntity = BrooklynTaskTags.getContextEntity(Tasks.current());
            if (currentEntity != null) {
                Iterable<Entity> ents = ((EntityManagerInternal)this.mgmt.getEntityManager()).getAllEntitiesInApplication(currentEntity.getApplication());
                for (Entity e : ents) {
                    if (!Objects.equals(value, e.getId())) continue;
                    return e;
                }
            }
            throw new IllegalStateException("Entity or other BrooklynObject '" + value + "' is not known here");
        }

        @Override
        protected JsonDeserializer<BrooklynObject> newDeserializer() {
            return new BODeserializer();
        }

        class BODeserializer
        extends ObjectAsStringSerializerAndDeserializer.Deserializer
        implements ContextualDeserializer,
        BrooklynJacksonSerializationUtils.RecontextualDeserializer {
            private DeserializationContext context;
            private JavaType knownConcreteType;

            BODeserializer() {
            }

            BODeserializer(DeserializationContext context, JavaType knownConcreteType) {
                this.context = context;
                this.knownConcreteType = knownConcreteType;
            }

            public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
                return new BODeserializer(ctxt, null);
            }

            @Override
            public JsonDeserializer<?> recreateContextual() {
                if (this.context != null && this.context.getContextualType() != null && this.context.getContextualType().isConcrete()) {
                    return new BODeserializer(this.context, this.context.getContextualType());
                }
                return this;
            }

            protected BrooklynObject newEmptyInstance() {
                if (this.knownConcreteType != null) {
                    return (BrooklynObject)BrooklynObjectSerialization.this.newEmptyInstance(this.knownConcreteType.getRawClass());
                }
                return (BrooklynObject)super.newEmptyInstance();
            }

            public BrooklynObject convertSpecialMapToObject(Map value, JsonParser p, DeserializationContext ctxt) throws IOException {
                BrooklynObject result = null;
                if (value.size() <= 2) {
                    Object id = value.get("id");
                    Object type = value.get("type");
                    boolean isExistingInstance = false;
                    if (id instanceof String) {
                        if (type instanceof String) {
                            Optional<BrooklynObjectType> typeO = Arrays.stream(BrooklynObjectType.values()).filter(t -> type.equals(t.getInterfaceType().getName())).findAny();
                            if (typeO.isPresent()) {
                                isExistingInstance = true;
                                result = BrooklynObjectSerialization.this.mgmt.lookup((String)id, typeO.get().getInterfaceType());
                            }
                        } else {
                            isExistingInstance = true;
                            result = BrooklynObjectSerialization.this.mgmt.lookup((String)id, null);
                        }
                    }
                    if (result == null) {
                        if (isExistingInstance) {
                            throw new IllegalStateException("Cannot find serialized shorthand reference to entity " + value);
                        }
                        if (type == null && this.knownConcreteType != null) {
                            result = this.newEmptyInstance();
                            FlagUtils.setFieldsFromFlags(value, result);
                        }
                    }
                }
                if (result != null) {
                    return result;
                }
                throw new IllegalStateException("Entity instances and other Brooklyn objects should be supplied as unique IDs; they cannot be instantiated from YAML. If a spec is desired, the type should be known or use $brooklyn:entitySpec.");
            }

            public BrooklynObject convertStringToObject(String value, JsonParser p, DeserializationContext ctxt) throws IOException {
                try {
                    return (BrooklynObject)super.convertStringToObject(value, p, ctxt);
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    if (BrooklynObjectSerialization.this.mgmt instanceof NonDeploymentManagementContext) {
                        LOG.warn("Reference to BrooklynObject " + value + " which is unknown or not yet known, using NonDeployment context; replacing with 'null': " + e);
                    } else {
                        LOG.warn("Reference to BrooklynObject " + value + " which is unknown or no longer available; replacing with 'null': " + e);
                    }
                    return null;
                }
            }
        }
    }

    public static class ManagementContextSerialization
    extends ObjectAsStringSerializerAndDeserializer<ManagementContext> {
        private final ManagementContext mgmt;

        public ManagementContextSerialization(ManagementContext mgmt) {
            this.mgmt = mgmt;
        }

        @Override
        public Class<ManagementContext> getType() {
            return ManagementContext.class;
        }

        @Override
        public String convertObjectToString(ManagementContext value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            return "default";
        }

        @Override
        public ManagementContext convertStringToObject(String value, JsonParser p, DeserializationContext ctxt) throws IOException {
            if ("default".equals(value)) {
                if (this.mgmt != null) {
                    return this.mgmt;
                }
                throw new IllegalArgumentException("ManagementContext cannot be deserialized here");
            }
            throw new IllegalStateException("ManagementContext should be recorded as 'default' to be deserialized correctly");
        }
    }

    public static class InstantSerialization
    extends ObjectAsStringSerializerAndDeserializer<Instant> {
        @Override
        public Class<Instant> getType() {
            return Instant.class;
        }

        @Override
        public String convertObjectToString(Instant value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            return Time.makeIso8601DateStringZ((Instant)value);
        }

        @Override
        public Instant convertStringToObject(String value, JsonParser p, DeserializationContext ctxt) throws IOException {
            return Time.parseInstant((String)value);
        }

        @Override
        public Instant convertSpecialMapToObject(Map value, JsonParser p, DeserializationContext ctxt) throws IOException {
            return (Instant)this.doConvertSpecialMapViaNewSimpleMapper(value);
        }
    }

    public static class ByteArrayObjectStreamSerialization
    extends ObjectAsStringSerializerAndDeserializer<ByteArrayOutputStream> {
        @Override
        public Class<ByteArrayOutputStream> getType() {
            return ByteArrayOutputStream.class;
        }

        @Override
        public String convertObjectToString(ByteArrayOutputStream value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            return provider.getConfig().getBase64Variant().encode(value.toByteArray());
        }

        @Override
        public ByteArrayOutputStream convertStringToObject(String value, JsonParser p, DeserializationContext ctxt) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(ctxt.getConfig().getBase64Variant().decode(value));
            return out;
        }

        @Override
        protected ByteArrayOutputStream copyInto(ByteArrayOutputStream src, ByteArrayOutputStream target) {
            try {
                target.write(src.toByteArray());
            }
            catch (IOException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            return target;
        }
    }

    public static class DateSerialization
    extends ObjectAsStringSerializerAndDeserializer<Date> {
        @Override
        public Class<Date> getType() {
            return Date.class;
        }

        @Override
        public String convertObjectToString(Date value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            return Time.makeIso8601DateString((Date)value);
        }

        @Override
        public Date convertStringToObject(String value, JsonParser p, DeserializationContext ctxt) throws IOException {
            return Time.parseDate((String)value);
        }

        @Override
        public Date convertSpecialMapToObject(Map value, JsonParser p, DeserializationContext ctxt) throws IOException {
            return (Date)this.doConvertSpecialMapViaNewSimpleMapper(value);
        }
    }

    public static class DurationSerialization
    extends ObjectAsStringSerializerAndDeserializer<Duration> {
        @Override
        public Class<Duration> getType() {
            return Duration.class;
        }

        @Override
        public String convertObjectToString(Duration value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            return value.toString();
        }

        @Override
        public Duration convertStringToObject(String value, JsonParser p, DeserializationContext ctxt) throws IOException {
            return Time.parseDuration((String)value);
        }

        @Override
        public Duration convertSpecialMapToObject(Map value, JsonParser p, DeserializationContext ctxt) throws IOException {
            return (Duration)this.doConvertSpecialMapViaNewSimpleMapper(value);
        }
    }

    public static abstract class ObjectAsStringSerializerAndDeserializer<T> {
        public abstract Class<T> getType();

        public Class<? extends T> getType(Object instance) {
            return this.getType();
        }

        public abstract String convertObjectToString(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

        public abstract T convertStringToObject(String var1, JsonParser var2, DeserializationContext var3) throws IOException;

        public T newEmptyInstance() {
            return this.newEmptyInstance(this.getType());
        }

        public T newEmptyInstance(Class<T> t) {
            try {
                Constructor<T> tc = t.getDeclaredConstructor(new Class[0]);
                tc.setAccessible(true);
                return tc.newInstance(new Object[0]);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                throw new IllegalArgumentException("Empty instances of " + this.getType() + " are not supported; provide a 'value:' indicating the value", e);
            }
        }

        public T convertSpecialMapToObject(Map value, JsonParser p, DeserializationContext ctxt) throws IOException {
            throw new IllegalStateException(this.getType() + " should be supplied as map with 'value'; instead had " + value);
        }

        protected T doConvertSpecialMapViaNewSimpleMapper(Map value) throws IOException {
            YAMLMapper m = BeanWithTypeUtils.newSimpleYamlMapper();
            m.setVisibility((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY));
            return (T)m.readerFor(this.getType()).readValue(m.writeValueAsString((Object)value));
        }

        protected T copyInto(T src, T target) {
            throw new IllegalStateException("Not supported to read into " + this.getType() + ", from " + src + " into " + target);
        }

        public <T extends SimpleModule> T apply(T module) {
            module.addSerializer(this.getType(), (JsonSerializer)new Serializer());
            module.addDeserializer(this.getType(), this.newDeserializer());
            return module;
        }

        protected JsonDeserializer<T> newDeserializer() {
            return new Deserializer();
        }

        protected class Deserializer
        extends JsonDeserializer<T> {
            protected Deserializer() {
            }

            public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                try {
                    Object valueO;
                    Object value = valueO = BrooklynJacksonSerializationUtils.readObject(ctxt, p);
                    if (value instanceof Map) {
                        if (((Map)value).size() == 1 && ((Map)value).containsKey("value")) {
                            value = ((Map)value).get("value");
                        } else {
                            return this.convertSpecialMapToObject((Map)value, p, ctxt);
                        }
                    }
                    if (value == null) {
                        if (valueO == null) {
                            return this.newEmptyInstance();
                        }
                        return null;
                    }
                    if (value instanceof String || Boxing.isPrimitiveOrBoxedClass(value.getClass())) {
                        return this.convertStringToObject(value.toString(), p, ctxt);
                    }
                    if (value instanceof Map) {
                        return this.convertSpecialMapToObject((Map)value, p, ctxt);
                    }
                    if (value.getClass().equals(Object.class)) {
                        return this.newEmptyInstance();
                    }
                    return this.deserializeOther(value);
                }
                catch (Exception e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }

            public T deserializeOther(Object value) {
                if (ObjectAsStringSerializerAndDeserializer.this.getType() != null && ObjectAsStringSerializerAndDeserializer.this.getType().isInstance(value)) {
                    return value;
                }
                throw new IllegalStateException(ObjectAsStringSerializerAndDeserializer.this.getType() + " should be supplied as string or map with 'type' and 'value'; instead had " + value);
            }

            public T deserialize(JsonParser p, DeserializationContext ctxt, T intoValue) throws IOException, JsonProcessingException {
                return ObjectAsStringSerializerAndDeserializer.this.copyInto(this.deserialize(p, ctxt), intoValue);
            }

            protected T newEmptyInstance() {
                return ObjectAsStringSerializerAndDeserializer.this.newEmptyInstance();
            }

            public T convertSpecialMapToObject(Map value, JsonParser p, DeserializationContext ctxt) throws IOException {
                return ObjectAsStringSerializerAndDeserializer.this.convertSpecialMapToObject(value, p, ctxt);
            }

            public T convertStringToObject(String value, JsonParser p, DeserializationContext ctxt) throws IOException {
                return ObjectAsStringSerializerAndDeserializer.this.convertStringToObject(value, p, ctxt);
            }
        }

        protected class Serializer
        extends JsonSerializer<T> {
            protected Serializer() {
            }

            public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeString(ObjectAsStringSerializerAndDeserializer.this.convertObjectToString(value, gen, provider));
            }

            public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
                if (value == null) {
                    gen.writeNull();
                    return;
                }
                if (typeSer.getTypeIdResolver() instanceof AsPropertyIfAmbiguous.HasBaseType && ((AsPropertyIfAmbiguous.HasBaseType)typeSer.getTypeIdResolver()).getBaseType().findSuperType(ObjectAsStringSerializerAndDeserializer.this.getType()) != null) {
                    gen.writeString(ObjectAsStringSerializerAndDeserializer.this.convertObjectToString(value, gen, serializers));
                    return;
                }
                gen.writeStartObject();
                gen.writeStringField("type", ObjectAsStringSerializerAndDeserializer.this.getType(value).getName());
                gen.writeStringField("value", ObjectAsStringSerializerAndDeserializer.this.convertObjectToString(value, gen, serializers));
                gen.writeEndObject();
            }
        }
    }

    public static class InterceptibleDeserializers
    extends SimpleDeserializers {
        final List<Function<JavaType, JsonDeserializer<?>>> interceptors = MutableList.of();

        public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
            if (type != null) {
                for (Function<JavaType, JsonDeserializer<?>> ic : this.interceptors) {
                    JsonDeserializer<?> interception = ic.apply(type);
                    if (interception == null) continue;
                    return interception;
                }
            }
            return super.findBeanDeserializer(type, config, beanDesc);
        }

        public void addInterceptor(Function<JavaType, JsonDeserializer<?>> typeRewriter) {
            this.interceptors.add(typeRewriter);
        }

        public void addSubtypeInterceptor(Class<?> type, JsonDeserializer<?> deserializer) {
            this.interceptors.add(jt -> jt.findSuperType(type) != null ? deserializer : null);
        }
    }
}

