/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.jackson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.google.common.annotations.Beta;
import java.io.IOException;
import org.apache.brooklyn.core.resolve.jackson.AsPropertyIfAmbiguous;

@Beta
public class JsonPassThroughDeserializer
extends JsonDeserializer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        try {
            AsPropertyIfAmbiguous.startSuppressingTypeFieldDeserialization();
            Object object = ctxt.readValue(p, Object.class);
            return object;
        }
        finally {
            AsPropertyIfAmbiguous.stopSuppressingTypeFieldDeserialization();
        }
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt, Object intoValue) throws IOException {
        throw new IllegalStateException("Unsupported to deserialize into an object");
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(p, ctxt);
    }

    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer, Object intoValue) throws IOException {
        return this.deserialize(p, ctxt, intoValue);
    }

    public static class JsonObjectHolder {
        @JsonValue
        public Object value;

        @JsonCreator
        public JsonObjectHolder(@JsonDeserialize(using=JsonPassThroughDeserializer.class) Object value) {
            this.value = value;
        }
    }
}

