/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.typereg;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.classloading.BrooklynClassLoadingContext;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.RegisteredTypeLoadingContext;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredTypeLoadingContexts {
    private static final Logger log = LoggerFactory.getLogger(RegisteredTypeLoadingContexts.class);

    public static RegisteredTypeLoadingContext any() {
        return new BasicRegisteredTypeLoadingContext();
    }

    public static RegisteredTypeLoadingContext alreadyEncountered(Set<String> encounteredTypeSymbolicNames) {
        BasicRegisteredTypeLoadingContext result = new BasicRegisteredTypeLoadingContext();
        result.encounteredTypes = (Set)(encounteredTypeSymbolicNames == null ? ImmutableSet.of() : ImmutableSet.copyOf(encounteredTypeSymbolicNames));
        return result;
    }

    public static RegisteredTypeLoadingContext alreadyEncountered(Set<String> encounteredTypeSymbolicNames, String anotherEncounteredType) {
        BasicRegisteredTypeLoadingContext result = new BasicRegisteredTypeLoadingContext();
        MutableSet encounteredTypes = MutableSet.copyOf(encounteredTypeSymbolicNames);
        encounteredTypes.addIfNotNull((Object)anotherEncounteredType);
        result.encounteredTypes = encounteredTypes.asUnmodifiable();
        return result;
    }

    public static RegisteredTypeLoadingContext loaderAlreadyEncountered(BrooklynClassLoadingContext loader, Set<String> encounteredTypeSymbolicNames) {
        return RegisteredTypeLoadingContexts.loaderAlreadyEncountered(loader, encounteredTypeSymbolicNames, null);
    }

    public static RegisteredTypeLoadingContext loaderAlreadyEncountered(BrooklynClassLoadingContext loader, Set<String> encounteredTypeSymbolicNames, String anotherEncounteredType) {
        return RegisteredTypeLoadingContexts.withLoader(RegisteredTypeLoadingContexts.alreadyEncountered(encounteredTypeSymbolicNames, anotherEncounteredType), loader);
    }

    public static RegisteredTypeLoadingContext loaderAlreadyEncountered(RegisteredTypeLoadingContext loader, String anotherEncounteredType) {
        BasicRegisteredTypeLoadingContext result = new BasicRegisteredTypeLoadingContext(loader);
        MutableSet encounteredTypes = MutableSet.copyOf((Iterable)(loader == null ? null : loader.getAlreadyEncounteredTypes()));
        encounteredTypes.addIfNotNull((Object)anotherEncounteredType);
        result.encounteredTypes = encounteredTypes.asUnmodifiable();
        return result;
    }

    private static RegisteredTypeLoadingContext of(BrooklynTypeRegistry.RegisteredTypeKind kind, Class<?> javaSuperType) {
        BasicRegisteredTypeLoadingContext result = new BasicRegisteredTypeLoadingContext();
        result.kind = kind;
        result.expectedSuperType = javaSuperType;
        return result;
    }

    public static RegisteredTypeLoadingContext bean(Class<?> javaSuperType) {
        return RegisteredTypeLoadingContexts.of(BrooklynTypeRegistry.RegisteredTypeKind.BEAN, javaSuperType);
    }

    public static RegisteredTypeLoadingContext spec(Class<? extends BrooklynObject> javaSuperType) {
        return RegisteredTypeLoadingContexts.of(BrooklynTypeRegistry.RegisteredTypeKind.SPEC, javaSuperType);
    }

    public static <T> RegisteredTypeLoadingContext withBeanSuperType(@Nullable RegisteredTypeLoadingContext source, @Nullable Class<T> beanSuperType) {
        Class<T> superType = beanSuperType;
        BasicRegisteredTypeLoadingContext constraint = new BasicRegisteredTypeLoadingContext(source);
        if (source == null) {
            source = constraint;
        }
        if (superType == null) {
            return source;
        }
        constraint.expectedSuperType = superType;
        if (source.getExpectedJavaSuperType() == null || source.getExpectedJavaSuperType().isAssignableFrom(superType)) {
            return constraint;
        }
        if (superType.isAssignableFrom(source.getExpectedJavaSuperType())) {
            return source;
        }
        log.warn("Ambiguous bean supertypes (" + beanSuperType + " for target " + source.getExpectedJavaSuperType() + "); it is recommended that any registered type constraint for a spec be compatible with the spec type");
        return source;
    }

    public static <T extends AbstractBrooklynObjectSpec<?, ?>> RegisteredTypeLoadingContext withSpecSuperType(@Nullable RegisteredTypeLoadingContext source, @Nullable Class<T> specSuperType) {
        Class<BrooklynObject> superType = RegisteredTypeLoadingContexts.lookupTargetTypeForSpec(specSuperType);
        BasicRegisteredTypeLoadingContext constraint = new BasicRegisteredTypeLoadingContext(source);
        if (source == null) {
            source = constraint;
        }
        if (superType == null) {
            return source;
        }
        constraint.expectedSuperType = superType;
        if (source.getExpectedJavaSuperType() == null || source.getExpectedJavaSuperType().isAssignableFrom(superType)) {
            return constraint;
        }
        if (superType.isAssignableFrom(source.getExpectedJavaSuperType())) {
            return source;
        }
        log.warn("Ambiguous spec supertypes (" + specSuperType + " for target " + source.getExpectedJavaSuperType() + "); it is recommended that any registered type constraint for a spec be compatible with the spec type");
        return source;
    }

    static <T extends AbstractBrooklynObjectSpec<?, ?>> Class<? extends BrooklynObject> lookupTargetTypeForSpec(@Nullable Class<T> specSuperType) {
        if (specSuperType == null) {
            return BrooklynObject.class;
        }
        BrooklynObjectType best = null;
        for (BrooklynObjectType t : BrooklynObjectType.values()) {
            if (t.getSpecType() == null || !t.getSpecType().isAssignableFrom(specSuperType)) continue;
            if (t.getSpecType().equals(specSuperType)) {
                return t.getInterfaceType();
            }
            if (best == null) {
                best = t;
                continue;
            }
            if (!best.getSpecType().isAssignableFrom(t.getSpecType())) continue;
            best = t;
        }
        if (best == null) {
            if (!specSuperType.equals(AbstractBrooklynObjectSpec.class)) {
                log.warn("Unexpected spec supertype (" + specSuperType + "); treating as any " + BrooklynObject.class, new Throwable("Trace for unexpected spec supertype"));
            }
            return BrooklynObject.class;
        }
        return best.getInterfaceType();
    }

    static <BO extends BrooklynObject> Class<? extends AbstractBrooklynObjectSpec<?, ?>> lookupSpecTypeForTarget(Class<BO> targetSuperType) {
        if (targetSuperType == null) {
            return null;
        }
        BrooklynObjectType best = null;
        for (BrooklynObjectType t : BrooklynObjectType.values()) {
            if (t.getInterfaceType() == null || !t.getInterfaceType().isAssignableFrom(targetSuperType)) continue;
            if (t.getInterfaceType().equals(targetSuperType)) {
                return t.getSpecType();
            }
            if (best == null) {
                best = t;
                continue;
            }
            if (!best.getInterfaceType().isAssignableFrom(t.getInterfaceType())) continue;
            best = t;
        }
        if (best == null) {
            log.warn("Unexpected target supertype (" + targetSuperType + "); unable to infer spec type");
            return null;
        }
        return best.getSpecType();
    }

    public static RegisteredTypeLoadingContext loader(BrooklynClassLoadingContext loader) {
        BasicRegisteredTypeLoadingContext result = new BasicRegisteredTypeLoadingContext();
        result.loader = loader;
        return result;
    }

    public static RegisteredTypeLoadingContext withLoader(RegisteredTypeLoadingContext constraint, BrooklynClassLoadingContext loader) {
        BasicRegisteredTypeLoadingContext result = new BasicRegisteredTypeLoadingContext(constraint);
        result.loader = loader;
        return result;
    }

    public static RegisteredTypeLoadingContext withEncounteredItem(RegisteredTypeLoadingContext constraint, String itemId) {
        if (constraint.getAlreadyEncounteredTypes().contains(itemId)) {
            return constraint;
        }
        BasicRegisteredTypeLoadingContext result = new BasicRegisteredTypeLoadingContext(constraint);
        result.encounteredTypes = (Set)ImmutableSet.builder().addAll((Iterable)constraint.getAlreadyEncounteredTypes()).add((Object)itemId).build();
        return result;
    }

    public static final class BasicRegisteredTypeLoadingContext
    implements RegisteredTypeLoadingContext {
        @Nullable
        private BrooklynTypeRegistry.RegisteredTypeKind kind;
        @Nullable
        private Class<?> expectedSuperType;
        @Nonnull
        private Set<String> encounteredTypes = ImmutableSet.of();
        @Nullable
        BrooklynClassLoadingContext loader;

        private BasicRegisteredTypeLoadingContext() {
        }

        public BasicRegisteredTypeLoadingContext(@Nullable RegisteredTypeLoadingContext source) {
            if (source == null) {
                return;
            }
            this.kind = source.getExpectedKind();
            this.expectedSuperType = source.getExpectedJavaSuperType();
            this.encounteredTypes = source.getAlreadyEncounteredTypes();
            this.loader = source.getLoader();
        }

        public BrooklynTypeRegistry.RegisteredTypeKind getExpectedKind() {
            return this.kind;
        }

        public Class<?> getExpectedJavaSuperType() {
            if (this.expectedSuperType == null) {
                return Object.class;
            }
            return this.expectedSuperType;
        }

        public Set<String> getAlreadyEncounteredTypes() {
            if (this.encounteredTypes == null) {
                return ImmutableSet.of();
            }
            return ImmutableSet.copyOf(this.encounteredTypes);
        }

        public BrooklynClassLoadingContext getLoader() {
            return this.loader;
        }

        public String toString() {
            return JavaClassNames.cleanSimpleClassName((Object)this) + "[" + this.kind + "," + this.expectedSuperType + "," + this.encounteredTypes + "]";
        }
    }
}

