/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow;

import com.google.common.annotations.Beta;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.feed.PollConfig;
import org.apache.brooklyn.core.feed.PollHandler;
import org.apache.brooklyn.core.feed.Poller;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.core.sensor.AbstractAddTriggerableSensor;
import org.apache.brooklyn.core.workflow.WorkflowCommonConfig;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowSensor;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.predicates.DslPredicates;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class WorkflowPolicy<T>
extends AbstractPolicy
implements WorkflowCommonConfig {
    private static final Logger LOG = LoggerFactory.getLogger(WorkflowPolicy.class);
    public static final ConfigKey<Duration> POLICY_PERIOD = AbstractAddTriggerableSensor.SENSOR_PERIOD;
    public static final ConfigKey<Object> POLICY_TRIGGERS_SENSORS = AbstractAddTriggerableSensor.SENSOR_TRIGGERS;
    public static final ConfigKey<Boolean> SKIP_INITIAL_RUN = AbstractAddTriggerableSensor.SKIP_INITIAL_RUN;
    public static final ConfigKey<DslPredicates.DslPredicate> CONDITION = ConfigKeys.newConfigKey(DslPredicates.DslPredicate.class, "condition", "Optional condition required for this sensor feed to run");
    public static final ConfigKey<String> UNIQUE_TAG_CAMEL = WorkflowSensor.UNIQUE_TAG_CAMEL;
    public static final ConfigKey<String> UNIQUE_TAG_UNDERSCORE = WorkflowSensor.UNIQUE_TAG_UNDERSCORE;
    public static final ConfigKey<String> UNIQUE_TAG_DASH = WorkflowSensor.UNIQUE_TAG_DASH;
    protected transient Poller<Object> poller;

    public WorkflowPolicy() {
    }

    public WorkflowPolicy(Map<?, ?> params) {
        super(params);
    }

    public String getDescription() {
        return null;
    }

    @Override
    protected String getDefaultDisplayName() {
        return "Workflow policy";
    }

    @Override
    public void init() {
        super.init();
    }

    public String initUniqueTag() {
        return this.getUniqueTag();
    }

    @Override
    public String getUniqueTag() {
        if (this.uniqueTag == null) {
            this.uniqueTag = WorkflowSensor.getUniqueTag(this.config().getBag(), null);
            if (this.uniqueTag == null) {
                this.uniqueTag = "workflow-policy-hash-" + Objects.hash(this.getDisplayName(), this.config().getBag());
            }
        }
        return super.getUniqueTag();
    }

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.poller = new Poller(this.getEntity(), this, false);
        Object pc = ((PollConfig)((PollConfig)((PollConfig)new PollConfig((AttributeSensor)null).period(this.getConfig(POLICY_PERIOD))).skipInitialRun(this.getConfig(SKIP_INITIAL_RUN))).otherTriggers(this.getConfig(POLICY_TRIGGERS_SENSORS))).condition(new ConditionSupplierFromAdjunct());
        MutableSet pollConfigs = MutableSet.of(pc);
        this.poller.schedulePoll(this, (Set<PollConfig>)pollConfigs, new WorkflowSensor.WorkflowPollCallable(WorkflowExecutionContext.WorkflowContextType.POLICY, this.getDisplayName() + " (policy)", this.config().getBag(), this), new PolicyNoOpPollHandler());
        if (!this.isSuspended()) {
            this.resume();
        }
    }

    @Override
    public void suspend() {
        super.suspend();
        if (this.poller.isRunning()) {
            this.poller.stop();
        }
    }

    @Override
    public void resume() {
        boolean needsStarting = !this.poller.isRunning() || this.isSuspended();
        super.resume();
        if (needsStarting) {
            this.poller.start();
        }
    }

    class ConditionSupplierFromAdjunct
    implements Supplier<DslPredicates.DslPredicate> {
        ConditionSupplierFromAdjunct() {
        }

        @Override
        public DslPredicates.DslPredicate get() {
            return (DslPredicates.DslPredicate)WorkflowPolicy.this.config().get(CONDITION);
        }
    }

    class PolicyNoOpPollHandler<V>
    implements PollHandler<V> {
        PolicyNoOpPollHandler() {
        }

        @Override
        public boolean checkSuccess(V v) {
            return true;
        }

        @Override
        public void onSuccess(V val) {
        }

        @Override
        public void onFailure(V val) {
        }

        @Override
        public void onException(Exception exception) {
            throw Exceptions.propagate((Throwable)exception);
        }

        @Override
        public String getDescription() {
            return WorkflowPolicy.this.getDescription();
        }
    }
}

