/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.store;

import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowStateActiveInMemory {
    private static final Logger log = LoggerFactory.getLogger(WorkflowStateActiveInMemory.class);
    public static final ConfigKey<WorkflowStateActiveInMemory> IN_MEMORY_WORKFLOWS = ConfigKeys.newConfigKey(WorkflowStateActiveInMemory.class, "internals.brooklyn.workflow.in_memory");
    private static final long GLOBAL_UPDATE_FREQUENCY = 300000L;
    private final ManagementContext mgmt;
    final Map<String, Map<String, WorkflowExecutionContext>> data = MutableMap.of();
    long lastInMemClear = System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorkflowStateActiveInMemory get(ManagementContext mgmt) {
        WorkflowStateActiveInMemory localActiveWorkflows = (WorkflowStateActiveInMemory)mgmt.getScratchpad().get(IN_MEMORY_WORKFLOWS);
        if (localActiveWorkflows == null) {
            ConfigKey<WorkflowStateActiveInMemory> configKey = IN_MEMORY_WORKFLOWS;
            synchronized (configKey) {
                localActiveWorkflows = (WorkflowStateActiveInMemory)mgmt.getScratchpad().get(IN_MEMORY_WORKFLOWS);
                if (localActiveWorkflows == null) {
                    localActiveWorkflows = new WorkflowStateActiveInMemory(mgmt);
                    mgmt.getScratchpad().put(IN_MEMORY_WORKFLOWS, (Object)localActiveWorkflows);
                }
            }
        }
        return localActiveWorkflows;
    }

    protected WorkflowStateActiveInMemory(ManagementContext mgmt) {
        this.mgmt = mgmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireAbsentEntities() {
        MutableSet copy;
        this.lastInMemClear = System.currentTimeMillis();
        Map<String, Map<String, WorkflowExecutionContext>> map = this.data;
        synchronized (map) {
            copy = MutableSet.copyOf(this.data.keySet());
        }
        copy.forEach(entityId -> {
            if (this.mgmt.getEntityManager().getEntity(entityId) == null) {
                this.data.remove(entityId);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint(WorkflowExecutionContext context) {
        MutableMap entityActiveWorkflows = this.getForWorkflowIdWithLockButResultNeedsSynch(context.getEntity().getId());
        if (context.getStatus().expirable) {
            if (entityActiveWorkflows != null) {
                MutableMap mutableMap = entityActiveWorkflows;
                synchronized (mutableMap) {
                    entityActiveWorkflows.remove(context.getWorkflowId());
                }
            }
        } else {
            Object object;
            if (entityActiveWorkflows == null) {
                object = this.data;
                synchronized (object) {
                    entityActiveWorkflows = this.data.get(context.getEntity().getId());
                    if (entityActiveWorkflows == null) {
                        entityActiveWorkflows = MutableMap.of();
                        this.data.put(context.getEntity().getId(), (Map<String, WorkflowExecutionContext>)entityActiveWorkflows);
                    }
                }
            }
            object = entityActiveWorkflows;
            synchronized (object) {
                entityActiveWorkflows.put((String)context.getWorkflowId(), (WorkflowExecutionContext)context);
            }
        }
        if (this.lastInMemClear + 300000L < System.currentTimeMillis()) {
            this.expireAbsentEntities();
        }
    }

    public Map<String, WorkflowExecutionContext> getWorkflows(Entity entity) {
        return this.getWorkflowsCopy(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableMap<String, WorkflowExecutionContext> getWorkflowsCopy(Entity entity) {
        Map<String, WorkflowExecutionContext> entityActiveWorkflows = this.getForWorkflowIdWithLockButResultNeedsSynch(entity.getId());
        if (entityActiveWorkflows == null) {
            return MutableMap.of();
        }
        Map<String, WorkflowExecutionContext> map = entityActiveWorkflows;
        synchronized (map) {
            return MutableMap.copyOf(entityActiveWorkflows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean deleteWorkflow(WorkflowExecutionContext context) {
        Map<String, WorkflowExecutionContext> entityActiveWorkflows = this.getForWorkflowIdWithLockButResultNeedsSynch(context.getEntity().getId());
        if (entityActiveWorkflows != null) {
            Map<String, WorkflowExecutionContext> map = entityActiveWorkflows;
            synchronized (map) {
                return entityActiveWorkflows.remove(context.getWorkflowId()) != null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, WorkflowExecutionContext> getForWorkflowIdWithLockButResultNeedsSynch(String entityId) {
        Map<String, Map<String, WorkflowExecutionContext>> map = this.data;
        synchronized (map) {
            return this.data.get(entityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowExecutionContext getFromTag(BrooklynTaskTags.WorkflowTaskTag tag) {
        Map<String, WorkflowExecutionContext> activeForEntity = this.getForWorkflowIdWithLockButResultNeedsSynch(tag.getEntityId());
        if (activeForEntity != null) {
            Map<String, WorkflowExecutionContext> map = activeForEntity;
            synchronized (map) {
                return activeForEntity.get(tag.getWorkflowId());
            }
        }
        return null;
    }
}

