/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.enricher.stock;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.BrooklynLogging;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.enricher.stock.AbstractAggregator;
import org.apache.brooklyn.enricher.stock.Enrichers;
import org.apache.brooklyn.enricher.stock.MathAggregatorFunctions;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Catalog(name="Aggregator", description="Aggregates sensors from multiple entities into a single sensor value")
public class Aggregator<T, U>
extends AbstractAggregator<T, U>
implements SensorEventListener<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Aggregator.class);
    public static final ConfigKey<Sensor<?>> SOURCE_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.sourceSensor", "The sensor whose change triggers re-evaluation of the target value");
    @SetFromFlag(value="transformation")
    public static final ConfigKey<Object> TRANSFORMATION_UNTYPED = ConfigKeys.newConfigKey(Object.class, "enricher.transformation.untyped", "Specifies a transformation, as a function from a collection to the value, or as a string matching a pre-defined named transformation, such as 'average' (for numbers), 'sum' (for numbers), 'min' (for numbers), 'max' (for numbers), 'isQuorate' (to compute a quorum), 'list' (the default, putting any collection of items into a list), or 'first' (the first value, or null if empty)");
    public static final ConfigKey<Function<? super Collection<?>, ?>> TRANSFORMATION = ConfigKeys.newConfigKey(new TypeToken<Function<? super Collection<?>, ?>>(){}, "enricher.transformation", "A function to be executed to evaluate the target sensor");
    public static final ConfigKey<String> QUORUM_CHECK_TYPE = ConfigKeys.newStringConfigKey("quorum.check.type", "The requirement to be considered quorate (used with transformation of type 'isQuorate') -- possible values: 'all', 'allAndAtLeastOne', 'atLeastOne', 'atLeastOneUnlessEmpty', 'alwaysHealthy'", "allAndAtLeastOne");
    public static final ConfigKey<Integer> QUORUM_TOTAL_SIZE = ConfigKeys.newIntegerConfigKey("quorum.total.size", "The total size to consider when determining if quorate (used with transformation of type 'isQuorate')", 1);
    protected Sensor<T> sourceSensor;
    protected Function<? super Collection<T>, ? extends U> transformation;
    protected final Map<Entity, T> values = Collections.synchronizedMap(new LinkedHashMap());

    @Override
    protected Collection<Sensor<?>> getSourceSensors() {
        return Collections.singleton(this.sourceSensor);
    }

    @Override
    protected void setEntityLoadingConfig() {
        super.setEntityLoadingConfig();
        this.sourceSensor = this.getRequiredConfig(SOURCE_SENSOR);
        this.transformation = (Function)this.config().get(TRANSFORMATION);
        Object t1 = this.config().get(TRANSFORMATION_UNTYPED);
        Function<Collection<?>, ?> t2 = null;
        if (t1 instanceof String && (t2 = this.lookupTransformation((String)t1)) == null) {
            LOG.warn("Unknown transformation '" + t1 + "' for " + this + "; will use default transformation");
        }
        if (this.transformation == null) {
            this.transformation = t2;
        } else if (t1 != null && !Objects.equals(t2, this.transformation)) {
            throw new IllegalStateException("Cannot supply both " + TRANSFORMATION_UNTYPED + " and " + TRANSFORMATION + " unless they are equal.");
        }
    }

    protected Function<? super Collection<?>, ?> lookupTransformation(String t1) {
        TypeToken targetType = this.targetSensor.getTypeToken();
        Object result = "average".equalsIgnoreCase(t1) ? MathAggregatorFunctions.computingAverage(null, null, targetType) : ("sum".equalsIgnoreCase(t1) ? MathAggregatorFunctions.computingSum(null, null, targetType) : ("min".equalsIgnoreCase(t1) ? MathAggregatorFunctions.computingMin(null, null, targetType) : ("max".equalsIgnoreCase(t1) ? MathAggregatorFunctions.computingMax(null, null, targetType) : ("isQuorate".equalsIgnoreCase(t1) ? new Enrichers.ComputingIsQuorate(targetType, QuorumCheck.QuorumChecks.of((String)((String)this.config().get(QUORUM_CHECK_TYPE))), (Integer)this.config().get(QUORUM_TOTAL_SIZE)) : ("list".equalsIgnoreCase(t1) ? new ComputingList() : ("first".equalsIgnoreCase(t1) ? new FirstOrNull() : null))))));
        return result;
    }

    @Override
    protected void setEntityBeforeSubscribingProducerChildrenEvents() {
        BrooklynLogging.log(LOG, BrooklynLogging.levelDebugOrTraceIfReadOnly(this.producer), "{} subscribing to children of {}", this, this.producer);
        this.subscriptions().subscribeToChildren(this.producer, this.sourceSensor, this);
    }

    @Override
    protected void addProducerHardcoded(Entity producer) {
        this.subscriptions().subscribe(producer, this.sourceSensor, this);
        this.onProducerAdded(producer);
    }

    @Override
    protected void addProducerChild(Entity producer) {
        this.onProducerAdded(producer);
    }

    @Override
    protected void addProducerMember(Entity producer) {
        this.subscriptions().subscribe(producer, this.sourceSensor, this);
        this.onProducerAdded(producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onProducerAdded(Entity producer) {
        BrooklynLogging.log(LOG, BrooklynLogging.levelDebugOrTraceIfReadOnly(producer), "{} listening to {}", this, producer);
        Map<Entity, T> map = this.values;
        synchronized (map) {
            T vo = this.values.get(producer);
            if (vo == null) {
                Object initialVal = this.sourceSensor instanceof AttributeSensor ? producer.getAttribute((AttributeSensor)this.sourceSensor) : null;
                this.values.put(producer, initialVal != null ? initialVal : this.defaultMemberValue);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("{} already had value ({}) for producer ({}); but that producer has just been added", new Object[]{this, vo, producer});
            }
        }
    }

    @Override
    protected void onProducerRemoved(Entity producer) {
        this.values.remove(producer);
        this.onUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(SensorEvent<T> event) {
        Entity e = event.getSource();
        Map<Entity, T> map = this.values;
        synchronized (map) {
            if (this.values.containsKey(e)) {
                this.values.put(e, event.getValue());
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("{} received event for unknown producer ({}); presumably that producer has recently been removed", (Object)this, (Object)e);
            }
        }
        this.onUpdated();
    }

    @Override
    protected void onUpdated() {
        try {
            this.emit(this.targetSensor, this.compute());
        }
        catch (Throwable t) {
            LOG.warn("Error calculating and setting aggregate for enricher " + this, t);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object compute() {
        Map<Entity, T> map = this.values;
        synchronized (map) {
            MutableList vs = MutableList.copyOf((Iterable)Iterables.filter(this.values.values(), (Predicate)this.valueFilter));
            if (this.transformation == null) {
                return vs;
            }
            return this.transformation.apply((Object)vs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Entity, T> copyOfValues() {
        Map<Entity, T> map = this.values;
        synchronized (map) {
            return Collections.unmodifiableMap(MutableMap.copyOf(this.values));
        }
    }

    private static class FirstOrNull<TT>
    implements Function<Collection<TT>, TT> {
        private FirstOrNull() {
        }

        public TT apply(Collection<TT> input) {
            return (TT)(input == null ? null : Iterables.getFirst(input, null));
        }
    }

    private class ComputingList<TT>
    implements Function<Collection<TT>, List<TT>> {
        private ComputingList() {
        }

        public List<TT> apply(Collection<TT> input) {
            if (input == null) {
                return null;
            }
            return MutableList.copyOf(input).asUnmodifiable();
        }
    }
}

