/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.group;

import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineLocation;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.MapConfigKey;
import org.apache.brooklyn.core.effector.ssh.SshEffectorTasks;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.BrooklynConfigKeys;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.core.location.Machines;
import org.apache.brooklyn.core.sensor.ssh.SshCommandSensor;
import org.apache.brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.json.ShellEnvironmentSerializer;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.system.internal.AbstractProcessTaskFactory;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SshCommandMembershipTrackingPolicy
extends AbstractMembershipTrackingPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(SshCommandMembershipTrackingPolicy.class);
    public static final String EVENT_TYPE = "EVENT_TYPE";
    public static final String MEMBER_ID = "MEMBER_ID";
    public static final ConfigKey<String> EXECUTION_DIR = ConfigKeys.newStringConfigKey("executionDir", "Directory where the command should run; if not supplied, executes in the entity's run dir (or home dir if no run dir is defined); use '~' to always execute in the home dir, or 'custom-feed/' to execute in a custom-feed dir relative to the run dir");
    public static final MapConfigKey<Object> SHELL_ENVIRONMENT = BrooklynConfigKeys.SHELL_ENVIRONMENT;
    public static final ConfigKey<String> UPDATE_COMMAND = ConfigKeys.newStringConfigKey("update.command", "Command to run on membership change events");
    public static final ConfigKey<ExecutionTarget> EXECUTION_TARGET = ConfigKeys.newConfigKey(ExecutionTarget.class, "execution.target", "Strategy for executing the command on different targets (default to the entity the policy is attached to)", ExecutionTarget.ENTITY);

    @Override
    protected void onEntityEvent(AbstractMembershipTrackingPolicy.EventType type, Entity member) {
        LOG.trace("Event {} received for {} in {}", new Object[]{type, member, this.getGroup()});
        String command = (String)Preconditions.checkNotNull((Object)this.config().get(UPDATE_COMMAND));
        ExecutionTarget where = (ExecutionTarget)((Object)Preconditions.checkNotNull((Object)this.config().get(EXECUTION_TARGET)));
        if (Strings.isNonBlank((CharSequence)command)) {
            switch (where) {
                case ENTITY: {
                    this.execute((Entity)this.entity, command, type.name(), member.getId());
                    break;
                }
                case MEMBER: {
                    this.execute(member, command, type.name(), member.getId());
                    break;
                }
                case ALL_MEMBERS: {
                    this.highlightAction("Run at all members (" + this.getGroup().getMembers().size() + ")", null);
                    for (Entity each : this.getGroup().getMembers()) {
                        this.execute(each, command, type.name(), member.getId(), false);
                    }
                    break;
                }
                default: {
                    LOG.warn("Unknown value passed as execution target: {}", (Object)where.name());
                }
            }
        }
    }

    public void execute(Entity target, String command, String type, String memberId) {
        this.execute(target, command, type, memberId, true);
    }

    private void execute(Entity target, String command, String type, String memberId, boolean highlight) {
        if (Entities.isNoLongerManaged(target)) {
            return;
        }
        Lifecycle state = (Lifecycle)((Object)target.getAttribute(Attributes.SERVICE_STATE_ACTUAL));
        if (state == Lifecycle.STOPPING || state == Lifecycle.STOPPED) {
            return;
        }
        Collection<? extends Location> locations = Locations.getLocationsCheckingAncestors(target.getLocations(), target);
        Maybe<SshMachineLocation> machine = Machines.findUniqueMachineLocation(locations, SshMachineLocation.class);
        if (machine.isAbsentOrNull()) {
            LOG.debug("No machine available to execute command");
            return;
        }
        LOG.info("Executing command on {}: {}", machine.get(), (Object)command);
        String executionDir = (String)this.config().get(EXECUTION_DIR);
        String sshCommand = SshCommandSensor.makeCommandExecutingInDirectory(command, executionDir, target);
        Object env = MutableMap.of();
        env.putAll(MutableMap.copyOf((Map)((Map)this.entity.config().get(BrooklynConfigKeys.SHELL_ENVIRONMENT))));
        env.putAll(MutableMap.copyOf((Map)((Map)this.config().get(BrooklynConfigKeys.SHELL_ENVIRONMENT))));
        env.put(EVENT_TYPE, type);
        env.put(MEMBER_ID, memberId);
        try {
            env = (Map)Tasks.resolveDeepValueWithoutCoercion(env, this.getExecutionContext());
        }
        catch (InterruptedException | ExecutionException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        ShellEnvironmentSerializer serializer = new ShellEnvironmentSerializer(this.getManagementContext());
        SshEffectorTasks.SshEffectorTaskFactory task = (SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)((AbstractProcessTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh(sshCommand).machine((MachineLocation)machine.get())).requiringZeroAndReturningStdout()).summary("group-" + CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, type))).environmentVariables((Map)serializer.serialize((Map<?, ?>)env));
        Task taskI = DynamicTasks.submit(task.newTask(), target);
        if (highlight) {
            this.highlightAction("Run at " + ((SshMachineLocation)machine.get()).getAddress().getHostAddress(), taskI);
        }
        String output = (String)taskI.getUnchecked();
        LOG.trace("Command returned: {}", (Object)output);
    }

    public static enum ExecutionTarget {
        ENTITY,
        MEMBER,
        ALL_MEMBERS;

        private static Converter<String, String> converter;

        public static ExecutionTarget fromString(String name) {
            Maybe<ExecutionTarget> parsed = ExecutionTarget.tryFromString(name);
            return (ExecutionTarget)((Object)parsed.get());
        }

        public static Maybe<ExecutionTarget> tryFromString(String name) {
            try {
                ExecutionTarget scope = ExecutionTarget.valueOf((String)converter.convert((Object)name));
                return Maybe.of((Object)((Object)scope));
            }
            catch (Exception cause) {
                return Maybe.absent((Throwable)cause);
            }
        }

        public static boolean isValid(String name) {
            Maybe<ExecutionTarget> check = ExecutionTarget.tryFromString(name);
            return check.isPresentAndNonNull();
        }

        public String toString() {
            return (String)converter.reverse().convert((Object)this.name());
        }

        static {
            converter = CaseFormat.LOWER_CAMEL.converterTo(CaseFormat.UPPER_UNDERSCORE);
        }
    }
}

