/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.stock;

import java.util.Collection;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.entity.trait.StartableMethods;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.entity.stock.BasicStartable;
import org.apache.brooklyn.util.collections.QuorumCheck;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStartableImpl
extends AbstractEntity
implements BasicStartable {
    private static final Logger log = LoggerFactory.getLogger(AbstractStartableImpl.class);

    @Override
    public void start(Collection<? extends Location> locations) {
        try {
            ServiceStateLogic.setExpectedState(this, Lifecycle.STARTING);
            Object val = this.config().get(START_LATCH);
            if (val != null) {
                log.debug("{} finished waiting for start-latch; continuing...", (Object)this);
            }
            this.addLocations(locations);
            locations = Locations.getLocationsCheckingAncestors(locations, this);
            log.info("Starting entity " + this + " at " + locations);
            this.doStart(locations);
            this.sensors().set(Attributes.SERVICE_UP, true);
        }
        finally {
            ServiceStateLogic.setExpectedState(this, Lifecycle.RUNNING);
        }
    }

    protected abstract void doStart(Collection<? extends Location> var1);

    @Override
    public void stop() {
        ServiceStateLogic.setExpectedState(this, Lifecycle.STOPPING);
        this.sensors().set(SERVICE_UP, false);
        try {
            this.doStop();
            ServiceStateLogic.setExpectedState(this, Lifecycle.STOPPED);
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState(this, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected abstract void doStop();

    @Override
    public void restart() {
        StartableMethods.restart(this);
    }

    @Override
    protected void initEnrichers() {
        super.initEnrichers();
        this.enrichers().add(ServiceStateLogic.newEnricherFromChildrenUp().checkChildrenOnly().requireUpChildren(QuorumCheck.QuorumChecks.all()).suppressDuplicates(true));
    }
}

