/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.policy.AbstractInvokeEffectorPolicy;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeEffectorOnCollectionSensorChange
extends AbstractInvokeEffectorPolicy
implements SensorEventListener<Collection<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(InvokeEffectorOnCollectionSensorChange.class);
    public static final ConfigKey<AttributeSensor<? extends Collection<?>>> TRIGGER_SENSOR = ConfigKeys.newConfigKey(new TypeToken<AttributeSensor<? extends Collection<?>>>(){}, "sensor", "Sensor to be monitored.");
    public static final ConfigKey<String> ON_ADDED_EFFECTOR_NAME = ConfigKeys.newStringConfigKey("onAdded", "Name of the effector to invoke when entries are added to the collection.");
    public static final ConfigKey<String> ON_REMOVED_EFFECTOR_NAME = ConfigKeys.newStringConfigKey("onRemoved", "Name of the effector to invoke when entries are removed from the collection.");
    public static final ConfigKey<String> PARAMETER_NAME = ConfigKeys.newStringConfigKey("parameterName", "The name of the parameter to supply to the effectors", "value");
    private Set<Object> previous = Collections.emptySet();
    private final Object[] updateLock = new Object[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        Sensor sensor = (Sensor)Preconditions.checkNotNull(this.getConfig(TRIGGER_SENSOR), (Object)("Value required for " + TRIGGER_SENSOR.getName()));
        Preconditions.checkArgument((boolean)Strings.isNonBlank((CharSequence)this.getConfig(PARAMETER_NAME)), (Object)("Value required for " + PARAMETER_NAME.getName()));
        if (this.getEffector(this.getOnAddedEffector()).isAbsentOrNull() && this.getEffector(this.getOnRemovedEffector()).isAbsentOrNull()) {
            throw new IllegalArgumentException("Value required for one or both of " + ON_ADDED_EFFECTOR_NAME.getName() + " and " + ON_REMOVED_EFFECTOR_NAME.getName());
        }
        Collection current = (Collection)entity.sensors().get(this.getTriggerSensor());
        Object[] objectArray = this.updateLock;
        synchronized (this.updateLock) {
            this.previous = current != null ? new HashSet(current) : Collections.emptySet();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.subscriptions().subscribe((Entity)entity, sensor, this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(SensorEvent<Collection<?>> event) {
        Object newValue;
        Object object = newValue = event.getValue() != null ? new LinkedHashSet((Collection)event.getValue()) : ImmutableSet.of();
        if (this.isBusySensorEnabled()) {
            Collection sensorVal = (Collection)this.entity.sensors().get(this.getTriggerSensor());
            Object sensorValSet = sensorVal != null ? new LinkedHashSet(sensorVal) : ImmutableSet.of();
            this.setMoreUpdatesComing(event.getTimestamp(), newValue, sensorValSet);
        }
        LinkedHashSet added = new LinkedHashSet();
        LinkedHashSet removed = new LinkedHashSet();
        Object[] objectArray = this.updateLock;
        synchronized (this.updateLock) {
            Sets.difference((Set)newValue, this.previous).copyInto(added);
            Sets.difference(this.previous, (Set)newValue).copyInto(removed);
            for (Object o : added) {
                this.onAdded(o);
            }
            for (Object o : removed) {
                this.onRemoved(o);
            }
            this.previous = Collections.unmodifiableSet(newValue);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private void onAdded(Object newElement) {
        this.onEvent(this.getOnAddedEffector(), newElement);
    }

    private void onRemoved(Object newElement) {
        this.onEvent(this.getOnRemovedEffector(), newElement);
    }

    private void onEvent(String effectorName, Object parameter) {
        Maybe<Effector<?>> effector = this.getEffector(effectorName);
        if (effector.isPresentAndNonNull()) {
            MutableMap parameters;
            if (parameter instanceof Map) {
                Map param = (Map)parameter;
                parameters = MutableMap.of();
                for (Map.Entry entry : param.entrySet()) {
                    String key = TypeCoercions.coerce(entry.getKey(), String.class);
                    parameters.put(key, entry.getValue());
                }
            } else {
                parameters = MutableMap.of((Object)this.getConfig(PARAMETER_NAME), (Object)parameter);
            }
            LOG.debug("{} invoking {} on {} with parameters {}", new Object[]{this, effector, this.entity, parameters});
            this.invoke((Effector)effector.get(), (Map<String, ?>)parameters);
        }
    }

    private Maybe<Effector<?>> getEffector(String name) {
        return this.entity.getEntityType().getEffectorByName(name);
    }

    private String getOnAddedEffector() {
        return this.getConfig(ON_ADDED_EFFECTOR_NAME);
    }

    private String getOnRemovedEffector() {
        return this.getConfig(ON_REMOVED_EFFECTOR_NAME);
    }

    private AttributeSensor<? extends Collection<?>> getTriggerSensor() {
        return this.getConfig(TRIGGER_SENSOR);
    }
}

