/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.util.core.osgi;

import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.core.osgi.SystemFrameworkLoader;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.net.Urls;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.osgi.OsgiUtils;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.stream.Streams;
import org.apache.brooklyn.util.text.BrooklynVersionSyntax;
import org.apache.brooklyn.util.text.NaturalOrderComparator;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.text.VersionComparator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.framework.launch.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class Osgis {
    private static final Logger LOG = LoggerFactory.getLogger(Osgis.class);

    public static BundleFinder bundleFinder(Framework framework) {
        return new BundleFinder(framework);
    }

    public static Framework getFramework(String felixCacheDir, boolean clean) {
        return SystemFrameworkLoader.get().getFramework(felixCacheDir, clean);
    }

    public static void ungetFramework(Framework framework) {
        SystemFrameworkLoader.get().ungetFramework(framework);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bundle install(Framework framework, String url) throws BundleException {
        boolean isLocal = Osgis.isLocalUrl(url);
        String localUrl = url;
        if (!isLocal) {
            localUrl = Osgis.cacheFile(url);
        }
        try {
            Bundle installedBundle;
            Bundle bundle = Osgis.getInstalledBundle(framework, localUrl);
            if (bundle != null) {
                Bundle bundle2 = bundle;
                return bundle2;
            }
            LOG.debug("Installing bundle into {} from url: {}", (Object)framework, (Object)url);
            InputStream stream = Osgis.getUrlStream(localUrl);
            Bundle bundle3 = installedBundle = framework.getBundleContext().installBundle(url, stream);
            return bundle3;
        }
        finally {
            if (!isLocal) {
                try {
                    new File(new URI(localUrl)).delete();
                }
                catch (URISyntaxException e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }
    }

    private static String cacheFile(String url) {
        InputStream in = Osgis.getUrlStream(url);
        File cache = Os.writeToTempFile((InputStream)in, (String)"bundle-cache", (String)"jar");
        return cache.toURI().toString();
    }

    private static boolean isLocalUrl(String url) {
        String protocol = Urls.getProtocol((String)url);
        return "file".equals(protocol) || "classpath".equals(protocol) || "jar".equals(protocol);
    }

    private static Bundle getInstalledBundle(Framework framework, String url) {
        JarInputStream stream;
        Bundle bundle = framework.getBundleContext().getBundle(url);
        if (bundle != null) {
            return bundle;
        }
        try {
            stream = new JarInputStream(Osgis.getUrlStream(url));
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        Manifest manifest = stream.getManifest();
        Streams.closeQuietly((Closeable)stream);
        if (manifest == null) {
            throw new IllegalStateException("Missing manifest file in bundle or not a jar file.");
        }
        String versionedId = OsgiUtils.getVersionedId((Manifest)manifest);
        for (Bundle installedBundle : framework.getBundleContext().getBundles()) {
            if (!versionedId.equals(OsgiUtils.getVersionedId((Bundle)installedBundle))) continue;
            if (SystemFrameworkLoader.get().isSystemBundle(installedBundle)) {
                LOG.debug("Already have system bundle " + versionedId + " from " + installedBundle + "/" + installedBundle.getLocation() + " when requested " + url + "; not installing");
                return installedBundle;
            }
            LOG.debug("Already have bundle " + versionedId + " from " + installedBundle + "/" + installedBundle.getLocation() + " when requested " + url + "; but it is not a system bundle so proceeding");
        }
        return null;
    }

    private static InputStream getUrlStream(String url) {
        return ResourceUtils.create(Osgis.class).getResourceFromUrl(url);
    }

    @Beta
    public static Optional<Bundle> getBundleOf(Class<?> clazz) {
        Bundle bundle = FrameworkUtil.getBundle(clazz);
        return Optional.fromNullable((Object)bundle);
    }

    public static ManagementContext getManagementContext() {
        Bundle bundle = (Bundle)Osgis.getBundleOf(Osgis.class).orNull();
        if (bundle == null) {
            return null;
        }
        ServiceReference svc = bundle.getBundleContext().getServiceReference(ManagementContext.class);
        if (svc == null) {
            return null;
        }
        return (ManagementContext)bundle.getBundleContext().getService(svc);
    }

    public static class BundleFinder {
        protected final Framework framework;
        protected String symbolicName;
        protected String version;
        protected String url;
        protected boolean urlMandatory = false;
        protected final List<Predicate<? super Bundle>> predicates = MutableList.of();

        protected BundleFinder(Framework framework) {
            this.framework = framework;
        }

        public BundleFinder symbolicName(String symbolicName) {
            this.symbolicName = symbolicName;
            return this;
        }

        public BundleFinder version(String version) {
            this.version = version;
            return this;
        }

        public BundleFinder id(String symbolicNameOptionallyWithVersion) {
            if (Strings.isBlank((CharSequence)symbolicNameOptionallyWithVersion)) {
                return this;
            }
            Maybe nv = VersionedName.parseMaybe((String)symbolicNameOptionallyWithVersion, (boolean)false);
            return this.id((VersionedName)nv.get());
        }

        private BundleFinder id(VersionedName nv) {
            this.symbolicName(nv.getSymbolicName());
            if (nv.getVersionString() != null) {
                this.version(nv.getVersionString());
            }
            return this;
        }

        public BundleFinder bundle(CatalogItem.CatalogBundle bundle) {
            if (bundle.isNameResolved()) {
                this.symbolicName(bundle.getSymbolicName());
                this.version(bundle.getSuppliedVersionString());
            }
            if (bundle.getUrl() != null) {
                this.requiringFromUrl(bundle.getUrl());
            }
            return this;
        }

        public BundleFinder preferringFromUrl(String url) {
            this.url = url;
            this.urlMandatory = false;
            return this;
        }

        public BundleFinder requiringFromUrl(String url) {
            this.url = url;
            this.urlMandatory = true;
            return this;
        }

        public Maybe<Bundle> find() {
            return this.findOne(false);
        }

        public Maybe<Bundle> findUnique() {
            return this.findOne(true);
        }

        protected Maybe<Bundle> findOne(boolean requireExactlyOne) {
            if (this.symbolicName == null && this.url == null) {
                throw new IllegalStateException(this + " must be given either a symbolic name or a URL");
            }
            List<Bundle> result = this.findAll();
            if (result.isEmpty()) {
                return Maybe.absent((String)("No bundle matching " + this.getConstraintsDescription()));
            }
            if (requireExactlyOne && result.size() > 1) {
                return Maybe.absent((String)("Multiple bundles (" + result.size() + ") matching " + this.getConstraintsDescription()));
            }
            Bundle r1 = result.get(0);
            for (int i = 1; i < result.size() && result.get(i).getSymbolicName().equals(r1.getSymbolicName()); ++i) {
                r1 = result.get(i);
            }
            return Maybe.of((Object)r1);
        }

        public List<Bundle> findAll() {
            boolean urlMatched = false;
            MutableList result = MutableList.of();
            String v = null;
            String vDep = null;
            VersionRange vRange = null;
            if (this.version != null) {
                if (this.isVersionRange(this.version)) {
                    vRange = VersionRange.valueOf((String)this.version);
                } else {
                    v = BrooklynVersionSyntax.toValidOsgiVersion((String)this.version);
                    vDep = OsgiUtils.toOsgiVersion((String)this.version);
                }
            }
            for (Bundle b : this.framework.getBundleContext().getBundles()) {
                if (this.symbolicName != null && !this.symbolicName.equals(b.getSymbolicName())) continue;
                if (this.version != null) {
                    Version bv = b.getVersion();
                    if (vRange != null) {
                        if (!vRange.includes(bv)) {
                            continue;
                        }
                    } else {
                        String bvString = bv.toString();
                        if (!v.equals(bvString)) {
                            if (!vDep.equals(bvString)) continue;
                            LOG.warn("Legacy inferred OSGi version string '" + vDep + "' found to match " + this.symbolicName + ":" + this.version + "; switch to '" + v + "' format to avoid issues with deprecated version syntax");
                        }
                    }
                }
                if (!Predicates.and(this.predicates).apply((Object)b)) continue;
                if (this.url != null) {
                    boolean matches = this.url.equals(b.getLocation());
                    if (this.urlMandatory) {
                        if (!matches) continue;
                        urlMatched = true;
                    } else if (matches) {
                        if (!urlMatched) {
                            result.clear();
                            urlMatched = true;
                        }
                    } else if (urlMatched) continue;
                }
                result.add(b);
            }
            if (this.symbolicName == null && this.url != null && !urlMatched) {
                result.clear();
            }
            Collections.sort(result, new Comparator<Bundle>(){

                @Override
                public int compare(Bundle o1, Bundle o2) {
                    int r = NaturalOrderComparator.INSTANCE.compare(o1.getSymbolicName(), o2.getSymbolicName());
                    if (r != 0) {
                        return r;
                    }
                    return VersionComparator.INSTANCE.compare(o1.getVersion().toString(), o2.getVersion().toString());
                }
            });
            return result;
        }

        public String getConstraintsDescription() {
            MutableList parts = MutableList.of();
            if (this.symbolicName != null) {
                parts.add("symbolicName=" + this.symbolicName);
            }
            if (this.version != null) {
                parts.add("version=" + this.version);
            }
            if (this.url != null) {
                parts.add("url[" + (this.urlMandatory ? "required" : "preferred") + "]=" + this.url);
            }
            if (!this.predicates.isEmpty()) {
                parts.add("predicates=" + this.predicates);
            }
            return Joiner.on((String)";").join((Iterable)parts);
        }

        public String toString() {
            return this.getClass().getCanonicalName() + "[" + this.getConstraintsDescription() + "]";
        }

        public BundleFinder version(final Predicate<Version> versionPredicate) {
            return this.satisfying((Predicate<? super Bundle>)new Predicate<Bundle>(){

                public boolean apply(Bundle input) {
                    return versionPredicate.apply((Object)input.getVersion());
                }
            });
        }

        public BundleFinder satisfying(Predicate<? super Bundle> predicate) {
            this.predicates.add(predicate);
            return this;
        }

        private boolean isVersionRange(String version) {
            return !(version == null || version.length() <= 2 || version.charAt(0) != '(' && version.charAt(0) != '[' || version.charAt(version.length() - 1) != ')' && version.charAt(version.length() - 1) != ']');
        }
    }
}

