/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.api.mgmt.ha;

import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.util.guava.Maybe;

public enum ManagementNodeState {
    INITIALIZING,
    STANDBY,
    HOT_STANDBY,
    HOT_BACKUP,
    MASTER,
    FAILED,
    TERMINATED;


    public static Maybe<ManagementNodeState> of(HighAvailabilityMode startMode) {
        switch (startMode) {
            case AUTO: 
            case DISABLED: {
                return Maybe.absent((String)("Requested " + HighAvailabilityMode.class + " mode " + (Object)((Object)startMode) + " cannot be converted to " + ManagementNodeState.class));
            }
            case HOT_BACKUP: {
                return Maybe.of((Object)((Object)HOT_BACKUP));
            }
            case HOT_STANDBY: {
                return Maybe.of((Object)((Object)HOT_STANDBY));
            }
            case MASTER: {
                return Maybe.of((Object)((Object)MASTER));
            }
            case STANDBY: {
                return Maybe.of((Object)((Object)STANDBY));
            }
        }
        return Maybe.absent((String)("Requested " + HighAvailabilityMode.class + " mode " + (Object)((Object)startMode) + " was not expected"));
    }

    public static boolean isHotProxy(ManagementNodeState state) {
        return state == HOT_BACKUP || state == HOT_STANDBY;
    }

    public static boolean isStandby(ManagementNodeState state) {
        return state == STANDBY || state == HOT_STANDBY;
    }
}

