/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.cli;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import io.airlift.airline.Cli;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.brooklyn.api.catalog.BrooklynCatalog;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.ha.HighAvailabilityMode;
import org.apache.brooklyn.cli.AbstractMain;
import org.apache.brooklyn.cli.CloudExplorer;
import org.apache.brooklyn.cli.ItemLister;
import org.apache.brooklyn.core.BrooklynVersion;
import org.apache.brooklyn.core.catalog.internal.CatalogInitialization;
import org.apache.brooklyn.core.entity.Entities;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.mgmt.ShutdownHandler;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.persist.BrooklynPersistenceUtils;
import org.apache.brooklyn.core.mgmt.persist.PersistMode;
import org.apache.brooklyn.core.mgmt.rebind.transformer.CompoundTransformer;
import org.apache.brooklyn.entity.stock.BasicApplication;
import org.apache.brooklyn.launcher.BrooklynLauncher;
import org.apache.brooklyn.launcher.BrooklynServerDetails;
import org.apache.brooklyn.launcher.config.StopWhichAppsOnShutdown;
import org.apache.brooklyn.rest.security.PasswordHasher;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.FatalConfigurationRuntimeException;
import org.apache.brooklyn.util.exceptions.FatalRuntimeException;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.Enums;
import org.apache.brooklyn.util.javalang.Reflections;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.text.Identifiers;
import org.apache.brooklyn.util.text.StringEscapes;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
extends AbstractMain {
    private static final Logger log = LoggerFactory.getLogger(Main.class);

    public static void main(String ... args) {
        log.debug("Launching Brooklyn via CLI, with " + Arrays.toString(args));
        BrooklynVersion.INSTANCE.logSummary();
        new Main().execCli(args);
    }

    @Override
    protected Cli.CliBuilder<AbstractMain.BrooklynCommand> cliBuilder() {
        Cli.CliBuilder builder = Cli.builder((String)this.cliScriptName()).withDescription("Brooklyn Management Service").withDefaultCommand(this.cliDefaultInfoCommand()).withCommands(AbstractMain.HelpCommand.class, new Class[]{this.cliInfoCommand(), GeneratePasswordCommand.class, CleanOrphanedStateCommand.class, CopyStateCommand.class, ItemLister.ListAllCommand.class, this.cliLaunchCommand()});
        builder.withGroup("cloud-compute").withDescription("Access compute details of a given cloud").withDefaultCommand(AbstractMain.HelpCommand.class).withCommands(CloudExplorer.ComputeListImagesCommand.class, new Class[]{CloudExplorer.ComputeListHardwareProfilesCommand.class, CloudExplorer.ComputeListInstancesCommand.class, CloudExplorer.ComputeGetImageCommand.class, CloudExplorer.ComputeDefaultTemplateCommand.class, CloudExplorer.ComputeTerminateInstancesCommand.class});
        builder.withGroup("cloud-blobstore").withDescription("Access blobstore details of a given cloud").withDefaultCommand(AbstractMain.HelpCommand.class).withCommands(CloudExplorer.BlobstoreListContainersCommand.class, new Class[]{CloudExplorer.BlobstoreListContainerCommand.class, CloudExplorer.BlobstoreGetBlobCommand.class});
        return builder;
    }

    protected Class<? extends AbstractMain.BrooklynCommand> cliLaunchCommand() {
        return LaunchCommand.class;
    }

    protected Class<? extends AbstractMain.BrooklynCommand> cliInfoCommand() {
        return AbstractMain.InfoCommand.class;
    }

    protected Class<? extends AbstractMain.BrooklynCommand> cliDefaultInfoCommand() {
        return AbstractMain.DefaultInfoCommand.class;
    }

    public static class AppShutdownHandler
    implements ShutdownHandler {
        private CountDownLatch lock = new CountDownLatch(1);

        public void onShutdownRequest() {
            this.lock.countDown();
        }

        public boolean isRequested() {
            return this.lock.getCount() == 0L;
        }

        public void waitOnShutdownRequest() {
            try {
                this.lock.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    @Command(name="copy-state", description="Retrieves persisted state")
    public static class CopyStateCommand
    extends AbstractMain.BrooklynCommandCollectingArgs {
        @Option(name={"--localBrooklynProperties"}, title="local brooklyn.properties file", description="local brooklyn.properties file, specific to this launch (appending to and overriding global properties)")
        public String localBrooklynProperties;
        @Option(name={"--persistenceDir"}, title="persistence dir", description="The directory to read persisted state (or container name if using an object store)")
        public String persistenceDir;
        @Option(name={"--persistenceLocation"}, title="persistence location", description="The location spec for an object store to read persisted state")
        public String persistenceLocation;
        @Option(name={"--destinationDir"}, required=true, title="destination dir", description="The directory to copy persistence data to")
        public String destinationDir;
        @Option(name={"--destinationLocation"}, title="persistence location", description="The location spec for an object store to copy data to")
        public String destinationLocation;
        @Option(name={"--transformations"}, title="transformations", description="local transformations file, to be applied to the copy of the data before uploading it")
        public String transformations;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            BrooklynLauncher launcher;
            Preconditions.checkNotNull((Object)this.destinationDir, (Object)"destinationDir");
            this.failIfArguments();
            try {
                log.info("Retrieving and copying persisted state to " + this.destinationDir + (Strings.isBlank((CharSequence)this.destinationLocation) ? "" : " @ " + this.destinationLocation));
                if (!this.quiet) {
                    this.stdout.println(AbstractMain.banner);
                    this.stdout.println(AbstractMain.productOneLineSummary);
                    this.stdout.println();
                }
                PersistMode persistMode = PersistMode.AUTO;
                HighAvailabilityMode highAvailabilityMode = HighAvailabilityMode.DISABLED;
                launcher = (BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)BrooklynLauncher.newInstance().localBrooklynPropertiesFile(this.localBrooklynProperties).brooklynProperties(OsgiManager.USE_OSGI, (Object)false)).persistMode(persistMode)).persistenceDir(this.persistenceDir)).persistenceLocation(this.persistenceLocation)).highAvailabilityMode(highAvailabilityMode);
            }
            catch (FatalConfigurationRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FatalConfigurationRuntimeException("Fatal error configuring Brooklyn launch: " + e.getMessage(), (Throwable)e);
            }
            try {
                launcher.copyPersistedState(this.destinationDir, this.destinationLocation, this.loadTransformer(this.transformations));
            }
            catch (FatalRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.error("Error retrieving persisted state: " + Exceptions.collapseText((Throwable)e), (Throwable)e);
                Exceptions.propagate((Throwable)e);
            }
            finally {
                try {
                    launcher.terminate();
                }
                catch (Exception e2) {
                    log.warn("Subsequent error during termination: " + e2);
                    log.debug("Details of subsequent error during termination: " + e2, (Throwable)e2);
                }
            }
            return null;
        }

        protected CompoundTransformer loadTransformer(String transformationsFileUrl) {
            return BrooklynPersistenceUtils.loadTransformer((ResourceUtils)ResourceUtils.create((Object)this), (String)transformationsFileUrl);
        }

        @Override
        public MoreObjects.ToStringHelper string() {
            return super.string().add("localBrooklynProperties", (Object)this.localBrooklynProperties).add("persistenceLocation", (Object)this.persistenceLocation).add("persistenceDir", (Object)this.persistenceDir).add("destinationDir", (Object)this.destinationDir);
        }
    }

    @Command(name="clean-orphaned-state", description="Removes existing orphaned persisted state (e.g. locations, policies, enrichers and feeds)")
    public static class CleanOrphanedStateCommand
    extends AbstractMain.BrooklynCommandCollectingArgs {
        @Option(name={"--localBrooklynProperties"}, title="local brooklyn.properties file", description="local brooklyn.properties file, specific to this launch (appending to and overriding global properties)")
        public String localBrooklynProperties;
        @Option(name={"--persistenceDir"}, title="persistence dir", description="The directory to read persisted state (or container name if using an object store)")
        public String persistenceDir;
        @Option(name={"--persistenceLocation"}, title="persistence location", description="The location spec for an object store to read persisted state")
        public String persistenceLocation;
        @Option(name={"--destinationDir"}, required=true, title="destination dir", description="The directory to copy persistence data to, with orphaned state removed")
        public String destinationDir;
        @Option(name={"--destinationLocation"}, title="persistence location", description="The location spec for an object store to copy data to")
        public String destinationLocation;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            BrooklynLauncher launcher;
            Preconditions.checkNotNull((Object)this.destinationDir, (Object)"destinationDir");
            this.failIfArguments();
            try {
                log.info("Retrieving and copying persisted state to " + this.destinationDir + " with orphaned state deleted");
                PersistMode persistMode = PersistMode.REBIND;
                HighAvailabilityMode highAvailabilityMode = HighAvailabilityMode.DISABLED;
                launcher = (BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)BrooklynLauncher.newInstance().localBrooklynPropertiesFile(this.localBrooklynProperties).brooklynProperties(OsgiManager.USE_OSGI, (Object)false)).persistMode(persistMode)).persistenceDir(this.persistenceDir)).persistenceLocation(this.persistenceLocation)).highAvailabilityMode(highAvailabilityMode);
            }
            catch (FatalConfigurationRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FatalConfigurationRuntimeException("Fatal error configuring Brooklyn launch: " + e.getMessage(), (Throwable)e);
            }
            try {
                launcher.cleanOrphanedState(this.destinationDir, this.destinationLocation);
            }
            catch (FatalRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.error("Error retrieving persisted state: " + Exceptions.collapseText((Throwable)e), (Throwable)e);
                Exceptions.propagate((Throwable)e);
            }
            finally {
                try {
                    launcher.terminate();
                }
                catch (Exception e2) {
                    log.warn("Subsequent error during termination: " + e2);
                    log.debug("Details of subsequent error during termination: " + e2, (Throwable)e2);
                }
            }
            return null;
        }
    }

    @Command(name="launch", description="Starts a server, optionally with applications")
    public static class LaunchCommand
    extends AbstractMain.BrooklynCommandWithSystemDefines {
        @Option(name={"--localBrooklynProperties"}, title="local brooklyn.properties file", description="Load the given properties file, specific to this launch (appending to and overriding global properties)")
        public String localBrooklynProperties;
        @Option(name={"--noGlobalBrooklynProperties"}, title="do not use any global brooklyn.properties file found", description="Do not use the default global brooklyn.properties file found")
        public boolean noGlobalBrooklynProperties;
        @Option(name={"-a", "--app"}, title="application class or file", description="The Application to start. For example, my.AppName or file://my/app.yaml -- note that a BROOKLYN_CLASSPATH environment variable may be required to load classes from other locations")
        public String app;
        @Option(name={"-s", "--script"}, title="script URI", description="DEPRECATED. URI for a Groovy script to parse and load. This script will run before starting the app.")
        @Beta
        public String script = null;
        @Option(name={"-l", "--location", "--locations"}, title="location list", description="Specifies the locations where the application will be launched. You can specify more than one location as a comma-separated list of values (or as a JSON array, if the values are complex)")
        public String locations;
        @Option(name={"--catalogInitial"}, title="catalog initial bom URI", description="Specifies a catalog.bom URI to be used to populate the initial catalog, loaded on first run, or when persistence is off/empty or the catalog is reset")
        public String catalogInitial;
        @Option(name={"-p", "--port"}, title="port number", description="Use this port for the brooklyn management web console and REST API; default is 8081+ for http, 8443+ for https.")
        public String port;
        @Option(name={"--https"}, description="Launch the web console on https")
        public boolean useHttps;
        @Option(name={"-nc", "--noConsole"}, description="Do not start the web console or REST API")
        public boolean noConsole;
        @Option(name={"-b", "--bindAddress"}, description="Specifies the IP address of the NIC to bind the Brooklyn Management Console to")
        public String bindAddress = null;
        @Option(name={"-pa", "--publicAddress"}, description="Specifies the IP address or hostname that the Brooklyn Management Console will be available on")
        public String publicAddress = null;
        @Option(name={"--noConsoleSecurity"}, description="Whether to disable authentication and security filters for the web console (for use when debugging on a secure network or bound to localhost)")
        public boolean noConsoleSecurity;
        @Option(name={"--startupContinueOnWebErrors"}, description="Continue on web subsystem failures during startup (default is to abort if the web API fails to start, as management access is not normally possible)")
        public boolean startupContinueOnWebErrors;
        @Option(name={"--startupFailOnPersistenceErrors"}, description="Fail on persistence/HA subsystem failures during startup (default is to continue, so errors can be viewed via the API)")
        public boolean startupFailOnPersistenceErrors;
        @Option(name={"--startupFailOnCatalogErrors"}, description="Fail on catalog subsystem failures during startup (default is to continue, so errors can be viewed via the API)")
        public boolean startupFailOnCatalogErrors;
        @Option(name={"--startupFailOnManagedAppsErrors"}, description="Fail startup on errors deploying of managed apps specified via the command line (default is to continue, so errors can be viewed via the API)")
        public boolean startupFailOnManagedAppsErrors;
        @Option(name={"--startBrooklynNode"}, description="Start a BrooklynNode entity representing this Brooklyn instance")
        @Beta
        public boolean startBrooklynNode;
        @Option(name={"-sk", "--stopOnKeyPress"}, description="Shutdown immediately on user text entry after startup (useful for debugging and demos)")
        @Beta
        public boolean stopOnKeyPress;
        static final String STOP_WHICH_APPS_ON_SHUTDOWN = "--stopOnShutdown";
        protected static final String STOP_ALL = "all";
        protected static final String STOP_ALL_IF_NOT_PERSISTED = "allIfNotPersisted";
        protected static final String STOP_NONE = "none";
        protected static final String STOP_THESE = "these";
        protected static final String STOP_THESE_IF_NOT_PERSISTED = "theseIfNotPersisted";
        @Option(name={"--stopOnShutdown"}, allowedValues={"all", "allIfNotPersisted", "none", "these", "theseIfNotPersisted"}, description="Which managed applications to stop on shutdown. Possible values are:\nall: stop all apps\nnone: leave all apps running\nthese: stop the apps explicitly started on this command line, but leave others started subsequently running\ntheseIfNotPersisted: stop the apps started on this command line IF persistence is not enabled, otherwise leave all running\nallIfNotPersisted: stop all apps IF persistence is not enabled, otherwise leave all running")
        public String stopWhichAppsOnShutdown = "theseIfNotPersisted";
        @Option(name={"--exitAndLeaveAppsRunningAfterStarting"}, description="Once the application to start (from --app) is running exit the process, leaving any entities running. Can be used in combination with --persist auto --persistenceDir <custom folder location> to attach to the running app at a later time.")
        public boolean exitAndLeaveAppsRunningAfterStarting;
        static final String PERSIST_OPTION = "--persist";
        protected static final String PERSIST_OPTION_DISABLED = "disabled";
        protected static final String PERSIST_OPTION_AUTO = "auto";
        protected static final String PERSIST_OPTION_REBIND = "rebind";
        protected static final String PERSIST_OPTION_CLEAN = "clean";
        @Option(name={"--persist"}, allowedValues={"disabled", "auto", "rebind", "clean"}, title="persistence mode", description="The persistence mode. Possible values are: \ndisabled: will not read or persist any state; \nauto: will rebind to any existing state, or start up fresh if no state; \nrebind: will rebind to the existing state, or fail if no state available; \nclean: will start up fresh (removing any existing state)")
        public String persist = "disabled";
        @Option(name={"--persistenceDir"}, title="persistence dir", description="The directory to read/write persisted state (or container name if using an object store)")
        public String persistenceDir;
        @Option(name={"--persistenceLocation"}, title="persistence location", description="The location spec for an object store to read/write persisted state")
        public String persistenceLocation;
        static final String HA_OPTION = "--highAvailability";
        protected static final String HA_OPTION_DISABLED = "disabled";
        protected static final String HA_OPTION_AUTO = "auto";
        protected static final String HA_OPTION_MASTER = "master";
        protected static final String HA_OPTION_STANDBY = "standby";
        protected static final String HA_OPTION_HOT_STANDBY = "hot_standby";
        protected static final String HA_OPTION_HOT_BACKUP = "hot_backup";
        @Option(name={"--highAvailability"}, allowedValues={"disabled", "auto", "master", "standby", "hot_standby", "hot_backup"}, title="high availability mode", description="The high availability mode. Possible values are: \ndisabled: management node works in isolation - will not cooperate with any other standby/master nodes in management plane; \nauto: will look for other management nodes, and will allocate itself as standby or master based on other nodes' states; \nmaster: will startup as master - if there is already a master then fails immediately; \nstandby: will start up as lukewarm standby with no state - if there is not already a master then fails immediately, and if there is a master which subsequently fails, this node can promote itself; \nhot_standby: will start up as hot standby in read-only mode - if there is not already a master then fails immediately, and if there is a master which subseuqently fails, this node can promote itself; \nhot_backup: will start up as hot backup in read-only mode - no master is required, and this node will not become a master")
        public String highAvailability = "auto";
        @VisibleForTesting
        protected ManagementContext explicitManagementContext;

        @Override
        public Void call() throws Exception {
            BrooklynLauncher launcher;
            super.call();
            AppShutdownHandler shutdownHandler = new AppShutdownHandler();
            this.failIfArguments();
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Invoked launch command {}", (Object)this);
                }
                if (!this.quiet) {
                    this.stdout.println(AbstractMain.banner);
                    this.stdout.println(AbstractMain.productOneLineSummary);
                    this.stdout.println();
                }
                if (this.verbose) {
                    if (this.app != null) {
                        this.stdout.println("Launching brooklyn app: " + this.app + " in " + this.locations);
                    } else {
                        this.stdout.println("Launching brooklyn server (no app)");
                    }
                }
                PersistMode persistMode = this.computePersistMode();
                HighAvailabilityMode highAvailabilityMode = this.computeHighAvailabilityMode(persistMode);
                StopWhichAppsOnShutdown stopWhichAppsOnShutdownMode = this.computeStopWhichAppsOnShutdown();
                this.computeLocations();
                ResourceUtils utils = ResourceUtils.create((Object)this);
                GroovyClassLoader loader = new GroovyClassLoader(this.getClass().getClassLoader());
                if (this.script != null) {
                    log.warn("Use of --script for groovy-script execution is deprecated");
                    this.execGroovyScript(utils, loader, this.script);
                }
                launcher = this.createLauncher();
                CatalogInitialization catInit = new CatalogInitialization(this.catalogInitial);
                catInit.setFailOnStartupErrors(this.startupFailOnCatalogErrors);
                launcher.catalogInitialization(catInit);
                launcher.persistMode(persistMode);
                launcher.persistenceDir(this.persistenceDir);
                launcher.persistenceLocation(this.persistenceLocation);
                launcher.highAvailabilityMode(highAvailabilityMode);
                launcher.stopWhichAppsOnShutdown(stopWhichAppsOnShutdownMode);
                launcher.shutdownHandler((ShutdownHandler)shutdownHandler);
                this.computeAndSetApp(launcher, utils, loader);
                this.customize(launcher);
            }
            catch (FatalConfigurationRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FatalConfigurationRuntimeException("Fatal error configuring Brooklyn launch: " + e.getMessage(), (Throwable)e);
            }
            try {
                launcher.start();
            }
            catch (FatalRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.error("Error launching brooklyn: " + Exceptions.collapseText((Throwable)e), (Throwable)e);
                try {
                    launcher.terminate();
                }
                catch (Exception e2) {
                    log.warn("Subsequent error during termination: " + e2);
                    log.debug("Details of subsequent error during termination: " + e2, (Throwable)e2);
                }
                Exceptions.propagate((Throwable)e);
            }
            BrooklynServerDetails server = launcher.getServerDetails();
            ManagementContext mgmt = server.getManagementContext();
            if (this.verbose) {
                Entities.dumpInfo((Iterable)launcher.getApplications());
            }
            if (!this.exitAndLeaveAppsRunningAfterStarting) {
                this.waitAfterLaunch(mgmt, shutdownHandler);
            }
            return null;
        }

        protected void customize(BrooklynLauncher launcher) {
        }

        protected void computeLocations() {
            boolean hasLocations;
            boolean bl = hasLocations = !Strings.isBlank((CharSequence)this.locations);
            if (this.app != null) {
                if (hasLocations && this.isYamlApp()) {
                    log.info("YAML app combined with command line locations; YAML locations will take precedence; this behaviour may change in subsequent versions");
                } else if (!hasLocations && this.isYamlApp()) {
                    log.info("No locations supplied; defaulting to locations defined in YAML (if any)");
                } else if (!hasLocations) {
                    log.info("No locations supplied; starting with no locations");
                }
            } else if (hasLocations) {
                log.error("Locations specified without any applications; ignoring locations");
            }
        }

        protected boolean isYamlApp() {
            return this.app != null && this.app.endsWith(".yaml");
        }

        protected PersistMode computePersistMode() {
            Maybe persistMode = Enums.valueOfIgnoreCase(PersistMode.class, (String)this.persist);
            if (!persistMode.isPresent()) {
                if (Strings.isBlank((CharSequence)this.persist)) {
                    throw new FatalConfigurationRuntimeException("Persist mode must not be blank");
                }
                throw new FatalConfigurationRuntimeException("Illegal persist setting: " + this.persist);
            }
            if (persistMode.get() == PersistMode.DISABLED) {
                if (Strings.isNonBlank((CharSequence)this.persistenceDir)) {
                    throw new FatalConfigurationRuntimeException("Cannot specify persistenceDir when persist is disabled");
                }
                if (Strings.isNonBlank((CharSequence)this.persistenceLocation)) {
                    throw new FatalConfigurationRuntimeException("Cannot specify persistenceLocation when persist is disabled");
                }
            }
            return (PersistMode)persistMode.get();
        }

        protected HighAvailabilityMode computeHighAvailabilityMode(PersistMode persistMode) {
            Maybe highAvailabilityMode = Enums.valueOfIgnoreCase(HighAvailabilityMode.class, (String)this.highAvailability);
            if (!highAvailabilityMode.isPresent()) {
                if (Strings.isBlank((CharSequence)this.highAvailability)) {
                    throw new FatalConfigurationRuntimeException("High availability mode must not be blank");
                }
                throw new FatalConfigurationRuntimeException("Illegal highAvailability setting: " + this.highAvailability);
            }
            if (highAvailabilityMode.get() != HighAvailabilityMode.DISABLED) {
                if (persistMode == PersistMode.DISABLED) {
                    if (highAvailabilityMode.get() == HighAvailabilityMode.AUTO) {
                        return HighAvailabilityMode.DISABLED;
                    }
                    throw new FatalConfigurationRuntimeException("Cannot specify highAvailability when persistence is disabled");
                }
                if (persistMode == PersistMode.CLEAN && (highAvailabilityMode.get() == HighAvailabilityMode.STANDBY || highAvailabilityMode.get() == HighAvailabilityMode.HOT_STANDBY || highAvailabilityMode.get() == HighAvailabilityMode.HOT_BACKUP)) {
                    throw new FatalConfigurationRuntimeException("Cannot specify highAvailability " + highAvailabilityMode.get() + " when persistence is CLEAN");
                }
            }
            return (HighAvailabilityMode)highAvailabilityMode.get();
        }

        protected StopWhichAppsOnShutdown computeStopWhichAppsOnShutdown() {
            boolean isDefault = STOP_THESE_IF_NOT_PERSISTED.equals(this.stopWhichAppsOnShutdown);
            if (this.exitAndLeaveAppsRunningAfterStarting && isDefault) {
                return StopWhichAppsOnShutdown.NONE;
            }
            return (StopWhichAppsOnShutdown)Enums.valueOfIgnoreCase(StopWhichAppsOnShutdown.class, (String)this.stopWhichAppsOnShutdown).get();
        }

        @VisibleForTesting
        public void useManagementContext(ManagementContext mgmt) {
            this.explicitManagementContext = mgmt;
        }

        protected BrooklynLauncher createLauncher() {
            BrooklynLauncher launcher = BrooklynLauncher.newInstance();
            ((BrooklynLauncher)((BrooklynLauncher)((BrooklynLauncher)launcher.localBrooklynPropertiesFile(this.localBrooklynProperties).ignorePersistenceErrors(!this.startupFailOnPersistenceErrors)).ignoreCatalogErrors(!this.startupFailOnCatalogErrors)).ignoreWebErrors(this.startupContinueOnWebErrors).ignoreAppErrors(!this.startupFailOnManagedAppsErrors)).locations((List)(Strings.isBlank((CharSequence)this.locations) ? ImmutableList.of() : StringEscapes.JavaStringEscapes.unwrapJsonishListStringIfPossible((String)this.locations)));
            launcher.restServer(!this.noConsole);
            if (this.useHttps) {
                launcher.restServerHttps(Boolean.valueOf(this.useHttps));
            }
            launcher.restServerPort(this.port);
            if (this.noGlobalBrooklynProperties) {
                log.debug("Configuring to disable global brooklyn.properties");
                launcher.globalBrooklynPropertiesFile(null);
            }
            if (this.noConsoleSecurity) {
                log.info("Configuring to disable console security");
                launcher.installSecurityFilter(Boolean.valueOf(false));
            }
            if (this.startBrooklynNode) {
                log.info("Configuring BrooklynNode entity startup");
                launcher.startBrooklynNode(true);
            }
            if (Strings.isNonEmpty((CharSequence)this.bindAddress)) {
                log.debug("Configuring bind address as " + this.bindAddress);
                launcher.bindAddress(Networking.getInetAddressWithFixedName((String)this.bindAddress));
            }
            if (Strings.isNonEmpty((CharSequence)this.publicAddress)) {
                log.debug("Configuring public address as " + this.publicAddress);
                launcher.publicAddress(Networking.getInetAddressWithFixedName((String)this.publicAddress));
            }
            if (this.explicitManagementContext != null) {
                log.debug("Configuring explicit management context " + this.explicitManagementContext);
                launcher.managementContext(this.explicitManagementContext);
            }
            return launcher;
        }

        protected final void populateCatalog(BrooklynCatalog catalog) {
        }

        protected void setAppToLaunch(String className) {
            if (this.app != null) {
                if (this.app.equals(className)) {
                    return;
                }
                throw new FatalConfigurationRuntimeException("Cannot specify app '" + className + "' when '" + this.app + "' is already specified; remove one or more conflicting CLI arguments.");
            }
            this.app = className;
        }

        protected void computeAndSetApp(BrooklynLauncher launcher, ResourceUtils utils, GroovyClassLoader loader) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
            if (this.app != null) {
                log.debug("Loading the user's application: {}", (Object)this.app);
                if (this.isYamlApp()) {
                    log.debug("Loading application as YAML spec: {}", (Object)this.app);
                    String content = utils.getResourceAsString(this.app);
                    launcher.application(content);
                } else {
                    EntitySpec<? extends Application> appSpec = this.loadApplicationFromClasspathOrParse(utils, loader, this.app);
                    launcher.application(appSpec);
                }
            }
        }

        protected void waitAfterLaunch(ManagementContext ctx, AppShutdownHandler shutdownHandler) throws IOException {
            if (this.stopOnKeyPress) {
                log.info("Server started. Press return to stop.");
                Task readTask = ctx.getExecutionManager().submit((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        stdin.read();
                        return null;
                    }
                });
                while (!shutdownHandler.isRequested()) {
                    try {
                        readTask.get(Duration.ONE_SECOND);
                        break;
                    }
                    catch (TimeoutException timeoutException) {
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw Exceptions.propagate((Throwable)e);
                    }
                    catch (ExecutionException e) {
                        throw Exceptions.propagate((Throwable)e);
                    }
                }
                log.info("Shutting down applications.");
                this.stopAllApps(ctx.getApplications());
            } else {
                log.info("Launched Brooklyn; will now block until shutdown command received via GUI/API (recommended) or process interrupt.");
                shutdownHandler.waitOnShutdownRequest();
            }
        }

        protected void execGroovyScript(ResourceUtils utils, GroovyClassLoader loader, String script) {
            log.debug("Running the user provided script: {}", (Object)script);
            String content = utils.getResourceAsString(script);
            GroovyShell shell = new GroovyShell((ClassLoader)loader);
            shell.evaluate(content);
        }

        protected EntitySpec<? extends Application> loadApplicationFromClasspathOrParse(ResourceUtils utils, GroovyClassLoader loader, String app) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
            Class clazz;
            log.debug("Loading application as class on classpath: {}", (Object)app);
            try {
                clazz = loader.loadClass(app, true, false);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException("Unable to load app class '" + app + "'", cnfe);
            }
            if (Application.class.isAssignableFrom(clazz)) {
                if (clazz.isInterface()) {
                    return EntitySpec.create((Class)clazz);
                }
                return EntitySpec.create(Application.class).impl(clazz).additionalInterfaces((Iterable)Reflections.getAllInterfaces((Class)clazz));
            }
            if (Entity.class.isAssignableFrom(clazz)) {
                EntitySpec childSpec = clazz.isInterface() ? EntitySpec.create((Class)clazz) : EntitySpec.create(Entity.class).impl(clazz).additionalInterfaces((Iterable)Reflections.getAllInterfaces((Class)clazz));
                return EntitySpec.create(BasicApplication.class).child(childSpec);
            }
            throw new FatalConfigurationRuntimeException("Application class " + clazz + " must be an Application or Entity");
        }

        @VisibleForTesting
        protected void stopAllApps(Collection<? extends Application> applications) {
            for (Application application : applications) {
                try {
                    if (!(application instanceof Startable)) continue;
                    ((Startable)application).stop();
                }
                catch (Exception e) {
                    log.error("Error stopping " + application + ": " + e, (Throwable)e);
                }
            }
        }

        @Override
        public MoreObjects.ToStringHelper string() {
            return super.string().add("app", (Object)this.app).add("script", (Object)this.script).add("location", (Object)this.locations).add("port", (Object)this.port).add("bindAddress", (Object)this.bindAddress).add("noConsole", this.noConsole).add("noConsoleSecurity", this.noConsoleSecurity).add("startupFailOnPersistenceErrors", this.startupFailOnPersistenceErrors).add("startupFailsOnCatalogErrors", this.startupFailOnCatalogErrors).add("startupContinueOnWebErrors", this.startupContinueOnWebErrors).add("startupFailOnManagedAppsErrors", this.startupFailOnManagedAppsErrors).add("catalogInitial", (Object)this.catalogInitial).add("stopWhichAppsOnShutdown", (Object)this.stopWhichAppsOnShutdown).add("stopOnKeyPress", this.stopOnKeyPress).add("localBrooklynProperties", (Object)this.localBrooklynProperties).add("persist", (Object)this.persist).add("persistenceLocation", (Object)this.persistenceLocation).add("persistenceDir", (Object)this.persistenceDir).add("highAvailability", (Object)this.highAvailability).add("exitAndLeaveAppsRunningAfterStarting", this.exitAndLeaveAppsRunningAfterStarting);
        }

        static {
            Enums.checkAllEnumeratedIgnoreCase(StopWhichAppsOnShutdown.class, (String[])new String[]{STOP_ALL, STOP_ALL_IF_NOT_PERSISTED, STOP_NONE, STOP_THESE, STOP_THESE_IF_NOT_PERSISTED});
            Enums.checkAllEnumeratedIgnoreCase(PersistMode.class, (String[])new String[]{"disabled", "auto", PERSIST_OPTION_REBIND, PERSIST_OPTION_CLEAN});
            Enums.checkAllEnumeratedIgnoreCase(HighAvailabilityMode.class, (String[])new String[]{"auto", "disabled", HA_OPTION_MASTER, HA_OPTION_STANDBY, HA_OPTION_HOT_STANDBY, HA_OPTION_HOT_BACKUP});
        }
    }

    @Command(name="generate-password", description="Generates a hashed web-console password")
    public static class GeneratePasswordCommand
    extends AbstractMain.BrooklynCommandCollectingArgs {
        @Option(name={"--user"}, title="username", required=true)
        public String user;
        @Option(name={"--stdin"}, title="read password from stdin, instead of console", description="Before using stdin, read http://stackoverflow.com/a/715681/1393883 for discussion of security!")
        public boolean useStdin;

        @Override
        public Void call() throws Exception {
            this.checkCanReadPassword();
            System.out.print("Enter password: ");
            System.out.flush();
            String password = this.readPassword();
            if (Strings.isBlank((CharSequence)password)) {
                throw new UserFacingException("Password must not be blank; aborting");
            }
            System.out.print("Re-enter password: ");
            System.out.flush();
            String password2 = this.readPassword();
            if (!password.equals(password2)) {
                throw new UserFacingException("Passwords did not match; aborting");
            }
            String salt = Identifiers.makeRandomId((int)4);
            String sha256password = PasswordHasher.sha256((String)salt, (String)new String(password));
            System.out.println();
            System.out.println("Please add the following to your brooklyn.properties:");
            System.out.println();
            System.out.println("brooklyn.webconsole.security.users=" + this.user);
            System.out.println("brooklyn.webconsole.security.user." + this.user + ".salt=" + salt);
            System.out.println("brooklyn.webconsole.security.user." + this.user + ".sha256=" + sha256password);
            return null;
        }

        private void checkCanReadPassword() {
            Console console;
            if (!this.useStdin && (console = System.console()) == null) {
                throw new FatalConfigurationRuntimeException("No console; cannot get password securely; aborting");
            }
        }

        private String readPassword() throws IOException {
            if (this.useStdin) {
                return this.readLine(System.in);
            }
            return new String(System.console().readPassword());
        }

        private String readLine(InputStream in) throws IOException {
            char c;
            StringBuilder result = new StringBuilder();
            while ((c = (char)in.read()) != '\n') {
                result.append(c);
            }
            return result.toString();
        }
    }
}

