/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.action;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.trait.Startable;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.core.sensor.DurationSinceSensor;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopAfterDurationPolicy
extends AbstractPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(StopAfterDurationPolicy.class);
    public static final ConfigKey<Duration> LIFETIME = ConfigKeys.builder(Duration.class).name("lifetime").description("The duration the entity is allowed to remain running").constraint(Predicates.notNull()).build();
    public static final ConfigKey<Lifecycle> STATE = ConfigKeys.builder(Lifecycle.class).name("state").description("The state the entity must enter before the stop-timer is started").defaultValue((Object)Lifecycle.RUNNING).constraint(Predicates.notNull()).build();
    public static final ConfigKey<Duration> POLL_PERIOD = ConfigKeys.builder(Duration.class).name("pollPeriod").description("Period in which duration-since sensor should be updated").defaultValue((Object)Duration.THIRTY_SECONDS).constraint(Predicates.notNull()).build();
    public static final ConfigKey<Boolean> HAS_STARTED_TIMER = ConfigKeys.builder(Boolean.class).name("timer-started").description("For internal use only").defaultValue((Object)false).build();
    public static final ConfigKey<Boolean> FIRED_STOP = ConfigKeys.builder(Boolean.class).name("fired-stop").description("For internal use only").defaultValue((Object)false).build();
    private final Object eventLock = new Object[0];

    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        entity.subscriptions().subscribe((Entity)entity, (Sensor)Attributes.SERVICE_STATE_ACTUAL, (SensorEventListener)new LifecycleListener());
        entity.subscriptions().subscribe((Entity)entity, (Sensor)Sensors.newSensor(Duration.class, (String)this.getSensorName()), (SensorEventListener)new TimeIsUpListener());
    }

    protected <T> void doReconfigureConfig(ConfigKey<T> key, T val) {
        ImmutableSet accepted = ImmutableSet.of(HAS_STARTED_TIMER, FIRED_STOP, LIFETIME);
        if (!accepted.contains(key)) {
            super.doReconfigureConfig(key, val);
        }
    }

    private String getSensorName() {
        return "duration.since.first-" + ((Lifecycle)this.config().get(STATE)).name().toLowerCase();
    }

    private class TimeIsUpListener
    implements SensorEventListener<Duration> {
        private TimeIsUpListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(SensorEvent<Duration> event) {
            Object object = StopAfterDurationPolicy.this.eventLock;
            synchronized (object) {
                if (!((Boolean)StopAfterDurationPolicy.this.config().get(FIRED_STOP)).booleanValue() && ((Duration)StopAfterDurationPolicy.this.config().get(LIFETIME)).subtract((Duration)event.getValue()).isNegative()) {
                    LOG.debug("Stopping {}: lifetime ({}) has expired", (Object)StopAfterDurationPolicy.this.entity, StopAfterDurationPolicy.this.config().get(LIFETIME));
                    StopAfterDurationPolicy.this.entity.invoke(Startable.STOP, (Map)ImmutableMap.of());
                    StopAfterDurationPolicy.this.config().set(FIRED_STOP, (Object)true);
                }
            }
        }
    }

    private class LifecycleListener
    implements SensorEventListener<Lifecycle> {
        private LifecycleListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(SensorEvent<Lifecycle> event) {
            Object object = StopAfterDurationPolicy.this.eventLock;
            synchronized (object) {
                if (!((Boolean)StopAfterDurationPolicy.this.config().get(HAS_STARTED_TIMER)).booleanValue() && ((Lifecycle)StopAfterDurationPolicy.this.config().get(STATE)).equals(event.getValue())) {
                    DurationSinceSensor sensor = new DurationSinceSensor(ConfigBag.newInstance((Map)ImmutableMap.of((Object)DurationSinceSensor.SENSOR_NAME, (Object)StopAfterDurationPolicy.this.getSensorName(), (Object)DurationSinceSensor.SENSOR_PERIOD, (Object)StopAfterDurationPolicy.this.config().get(POLL_PERIOD), (Object)DurationSinceSensor.SENSOR_TYPE, (Object)Duration.class.getName())));
                    sensor.apply(StopAfterDurationPolicy.this.entity);
                    StopAfterDurationPolicy.this.config().set(HAS_STARTED_TIMER, (Object)true);
                }
            }
        }
    }
}

