/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.ha;

import com.google.common.net.HostAndPort;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.BasicConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.sensor.BasicNotificationSensor;
import org.apache.brooklyn.policy.ha.AbstractFailureDetector;
import org.apache.brooklyn.policy.ha.HASensors;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.time.Duration;

@Catalog(name="Connection Failure Detector", description="HA policy for monitoring a host:port, emitting an event if the connection is lost/restored")
public class ConnectionFailureDetector
extends AbstractFailureDetector {
    public static final ConfigKey<HostAndPort> ENDPOINT = ConfigKeys.newConfigKey(HostAndPort.class, (String)"connectionFailureDetector.endpoint", (String)"The host:port to be checked periodically");
    public static final ConfigKey<Duration> POLL_PERIOD = ConfigKeys.newConfigKey(Duration.class, (String)"connectionFailureDetector.pollPeriod", (String)"The poll period for checking that the endpoint is reachable", (Object)Duration.ONE_SECOND);
    public static final BasicNotificationSensor<HASensors.FailureDescriptor> CONNECTION_FAILED = HASensors.CONNECTION_FAILED;
    public static final BasicNotificationSensor<HASensors.FailureDescriptor> CONNECTION_RECOVERED = HASensors.CONNECTION_RECOVERED;
    @SetFromFlag(value="connectionFailedStabilizationDelay")
    public static final ConfigKey<Duration> CONNECTION_FAILED_STABILIZATION_DELAY = BasicConfigKey.builder(Duration.class).name("connectionFailureDetector.serviceFailedStabilizationDelay").description("Time period for which the connection must be consistently down for (e.g. doesn't report down-up-down) before concluding failure. Note that long TCP timeouts mean there can be long (e.g. 70 second) delays in noticing a connection refused condition.").defaultValue((Object)Duration.ZERO).build();
    @SetFromFlag(value="connectionRecoveredStabilizationDelay")
    public static final ConfigKey<Duration> CONNECTION_RECOVERED_STABILIZATION_DELAY = BasicConfigKey.builder(Duration.class).name("connectionFailureDetector.serviceRecoveredStabilizationDelay").description("For a failed connection, time period for which the connection must be consistently up for (e.g. doesn't report up-down-up) before concluding recovered").defaultValue((Object)Duration.ZERO).build();

    public void init() {
        super.init();
        this.getRequiredConfig(ENDPOINT);
        if (this.config().getRaw(SENSOR_FAILED).isAbsent()) {
            this.config().set(SENSOR_FAILED, CONNECTION_FAILED);
        }
        if (this.config().getRaw(SENSOR_RECOVERED).isAbsent()) {
            this.config().set(SENSOR_RECOVERED, CONNECTION_RECOVERED);
        }
    }

    @Override
    protected AbstractFailureDetector.CalculatedStatus calculateStatus() {
        HostAndPort endpoint = (HostAndPort)this.getConfig(ENDPOINT);
        boolean isHealthy = Networking.isReachable((HostAndPort)endpoint);
        return new AbstractFailureDetector.BasicCalculatedStatus(isHealthy, "endpoint=" + endpoint);
    }

    @Override
    protected Duration getPollPeriod() {
        return (Duration)this.getConfig(POLL_PERIOD);
    }

    @Override
    protected Duration getFailedStabilizationDelay() {
        return (Duration)this.getConfig(CONNECTION_FAILED_STABILIZATION_DELAY);
    }

    @Override
    protected Duration getRecoveredStabilizationDelay() {
        return (Duration)this.getConfig(CONNECTION_RECOVERED_STABILIZATION_DELAY);
    }

    @Override
    protected Sensor<HASensors.FailureDescriptor> getSensorFailed() {
        Maybe sensorFailed = this.config().getRaw(SENSOR_FAILED);
        if (sensorFailed.isPresent()) {
            return (Sensor)sensorFailed.get();
        }
        return CONNECTION_FAILED;
    }

    @Override
    protected Sensor<HASensors.FailureDescriptor> getSensorRecovered() {
        Maybe sensorRecovered = this.config().getRaw(SENSOR_RECOVERED);
        if (sensorRecovered.isPresent()) {
            return (Sensor)sensorRecovered.get();
        }
        return CONNECTION_RECOVERED;
    }
}

