/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.Tag;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.CreateTagsOptions;
import org.jclouds.cloudstack.options.DeleteTagsOptions;
import org.jclouds.cloudstack.options.ListTagsOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Unwrap;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface TagApi {
    @Named(value="listTags")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listTags", "true"})
    @SelectJson(value={"tag"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Tag> listTags(ListTagsOptions ... var1);

    @Named(value="createTags")
    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command"}, values={"createTags"})
    @Unwrap
    public AsyncCreateResponse createTags(CreateTagsOptions var1);

    @Named(value="deleteTags")
    @GET
    @Consumes(value={"application/json"})
    @QueryParams(keys={"command"}, values={"deleteTags"})
    @Unwrap
    public AsyncCreateResponse deleteTags(DeleteTagsOptions var1);
}

