/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.dns;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.policy.Policy;
import org.apache.brooklyn.api.policy.PolicySpec;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.core.entity.AbstractEntity;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.entity.lifecycle.Lifecycle;
import org.apache.brooklyn.core.entity.lifecycle.ServiceStateLogic;
import org.apache.brooklyn.core.location.geo.HostGeoInfo;
import org.apache.brooklyn.entity.dns.AbstractGeoDnsService;
import org.apache.brooklyn.entity.group.AbstractMembershipTrackingPolicy;
import org.apache.brooklyn.entity.group.DynamicGroup;
import org.apache.brooklyn.entity.webapp.WebAppService;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.net.Networking;
import org.apache.brooklyn.util.time.Duration;
import org.apache.brooklyn.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGeoDnsServiceImpl
extends AbstractEntity
implements AbstractGeoDnsService {
    private static final Logger log = LoggerFactory.getLogger(AbstractGeoDnsService.class);
    @SetFromFlag
    protected Group targetEntityProvider;
    protected AbstractMembershipTrackingPolicy tracker;
    protected final Object trackerLock = new Object[0];
    protected Map<Entity, HostGeoInfo> targetHosts = Collections.synchronizedMap(new LinkedHashMap());
    protected transient Set<Entity> entitiesWithoutHostname = new HashSet<Entity>();
    protected transient Set<Entity> entitiesWithoutGeoInfo = new HashSet<Entity>();
    long lastUpdate = -1L;

    public void init() {
        super.init();
        Group initialProvider = (Group)this.config().get(ENTITY_PROVIDER);
        if (initialProvider != null) {
            this.setTargetEntityProvider(initialProvider);
        }
    }

    @Override
    public Map<Entity, HostGeoInfo> getTargetHosts() {
        return this.targetHosts;
    }

    public void onManagementStarted() {
        super.onManagementStarted();
        this.startTracker();
    }

    public void onManagementStopped() {
        this.endTracker();
        super.onManagementStopped();
    }

    public void destroy() {
        this.setServiceState(Lifecycle.DESTROYED);
        super.destroy();
    }

    @Override
    public void setServiceState(Lifecycle state) {
        this.sensors().set(HOSTNAME, (Object)this.getHostname());
        ServiceStateLogic.setExpectedState((Entity)this, (Lifecycle)state);
        if (state == Lifecycle.RUNNING) {
            ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((Entity)this, (Sensor)SERVICE_STATE_ACTUAL);
        } else {
            ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((Entity)this, (Sensor)SERVICE_STATE_ACTUAL, (Object)"Not in RUNNING state");
        }
    }

    @Override
    public void setTargetEntityProvider(Group entityProvider) {
        this.targetEntityProvider = (Group)Preconditions.checkNotNull((Object)entityProvider, (Object)"targetEntityProvider");
        this.startTracker();
    }

    protected abstract void reconfigureService(Collection<HostGeoInfo> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTracker() {
        Object object = this.trackerLock;
        synchronized (object) {
            if (this.targetEntityProvider == null || !this.getManagementSupport().isDeployed()) {
                log.debug("Tracker for " + this + " not yet active: " + this.targetEntityProvider + " / " + this.getManagementContext());
                return;
            }
            this.endTracker();
            ImmutableSet.Builder sensorsToTrack = ImmutableSet.builder().add((Object[])new Sensor[]{HOSTNAME, ADDRESS, Attributes.MAIN_URI, WebAppService.ROOT_URL});
            if (Boolean.TRUE.equals(this.config().get(FILTER_FOR_RUNNING))) {
                sensorsToTrack.add((Object)Attributes.SERVICE_STATE_ACTUAL);
            }
            log.debug("Initializing tracker for " + this + ", following " + this.targetEntityProvider);
            this.tracker = (AbstractMembershipTrackingPolicy)this.policies().add((PolicySpec)((PolicySpec)((PolicySpec)PolicySpec.create(MemberTrackingPolicy.class).displayName("GeoDNS targets tracker")).configure(AbstractMembershipTrackingPolicy.SENSORS_TO_TRACK, (Object)sensorsToTrack.build())).configure(AbstractMembershipTrackingPolicy.GROUP, (Object)this.targetEntityProvider));
            this.refreshGroupMembership();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void endTracker() {
        Object object = this.trackerLock;
        synchronized (object) {
            if (this.tracker == null || this.targetEntityProvider == null) {
                return;
            }
            this.policies().remove((Policy)this.tracker);
            this.tracker = null;
        }
    }

    @Override
    public abstract String getHostname();

    protected void refreshGroupMembership() {
        try {
            if (log.isDebugEnabled()) {
                log.debug("GeoDns {} refreshing targets", (Object)this);
            }
            if (this.targetEntityProvider == null) {
                return;
            }
            if (this.targetEntityProvider instanceof DynamicGroup) {
                ((DynamicGroup)this.targetEntityProvider).rescanEntities();
            }
            MutableSet pool = MutableSet.copyOf((Iterable)(this.targetEntityProvider instanceof Group ? this.targetEntityProvider.getMembers() : this.targetEntityProvider.getChildren()));
            if (log.isDebugEnabled()) {
                log.debug("GeoDns {} refreshing targets, pool now {}", (Object)this, (Object)pool);
            }
            boolean changed = false;
            boolean filterForRunning = Boolean.TRUE.equals(this.config().get(FILTER_FOR_RUNNING));
            MutableSet previousOnes = MutableSet.copyOf(this.targetHosts.keySet());
            for (Entity e : pool) {
                if (filterForRunning && !Lifecycle.RUNNING.equals(e.sensors().get(Attributes.SERVICE_STATE_ACTUAL))) continue;
                previousOnes.remove(e);
                changed |= this.addTargetHost(e);
            }
            for (Entity e : previousOnes) {
                changed |= this.removeTargetHost(e, false);
            }
            if (changed || this.lastUpdate > 0L && Time.hasElapsedSince((long)this.lastUpdate, (Duration)Duration.ONE_HOUR)) {
                this.update();
            }
        }
        catch (Exception e) {
            log.error("Problem refreshing group membership: " + e, (Throwable)e);
        }
    }

    protected boolean addTargetHost(Entity entity) {
        try {
            String addr;
            HostGeoInfo oldGeo = this.targetHosts.get(entity);
            String hostname = this.inferHostname(entity);
            String ip = this.inferIp(entity);
            String string = addr = (Boolean)this.getConfig(USE_HOSTNAMES) != false || ip == null ? hostname : ip;
            if (addr == null) {
                addr = ip;
            }
            if (addr == null) {
                if (this.entitiesWithoutHostname.add(entity)) {
                    log.debug("GeoDns ignoring {} (no hostname/ip/URL info yet available)", (Object)entity);
                }
                return false;
            }
            HostGeoInfo geo = HostGeoInfo.fromEntity((Entity)entity);
            if (geo == null) {
                geo = this.inferHostGeoInfo(hostname, ip);
            }
            if (Networking.isPrivateSubnet((String)addr) && ip != null && !Networking.isPrivateSubnet((String)ip)) {
                log.debug("GeoDns using IP " + ip + " for " + entity + " as addr " + addr + " resolves to private subnet");
                addr = ip;
            }
            if (Networking.isPrivateSubnet((String)addr)) {
                if (((Boolean)this.getConfig(INCLUDE_HOMELESS_ENTITIES)).booleanValue()) {
                    if (this.entitiesWithoutGeoInfo.add(entity)) {
                        log.info("GeoDns including {}, even though {} is a private subnet (homeless entities included)", (Object)entity, (Object)addr);
                    }
                } else {
                    if (this.entitiesWithoutGeoInfo.add(entity)) {
                        log.warn("GeoDns ignoring {} (private subnet detected for {})", (Object)entity, (Object)addr);
                    }
                    return false;
                }
            }
            if (geo == null) {
                if (((Boolean)this.getConfig(INCLUDE_HOMELESS_ENTITIES)).booleanValue()) {
                    if (this.entitiesWithoutGeoInfo.add(entity)) {
                        log.info("GeoDns including {}, even though no geography info available for {})", (Object)entity, (Object)addr);
                    }
                    geo = HostGeoInfo.create((String)addr, (String)("unknownLocation(" + addr + ")"), (double)0.0, (double)0.0);
                } else {
                    if (this.entitiesWithoutGeoInfo.add(entity)) {
                        log.warn("GeoDns ignoring {} (no geography info available for {})", (Object)entity, (Object)addr);
                    }
                    return false;
                }
            }
            if (!addr.equals(geo.getAddress())) {
                geo = HostGeoInfo.create((String)addr, (String)geo.displayName, (double)geo.latitude, (double)geo.longitude);
            }
            if (oldGeo != null && geo.getAddress().equals(oldGeo.getAddress())) {
                return false;
            }
            this.entitiesWithoutHostname.remove(entity);
            this.entitiesWithoutGeoInfo.remove(entity);
            log.info("GeoDns adding " + entity + " at " + geo + (oldGeo != null ? " (previously " + oldGeo + ")" : ""));
            this.targetHosts.put(entity, geo);
            return true;
        }
        catch (Exception ee) {
            log.warn("GeoDns ignoring " + entity + " (error analysing location): " + ee, (Throwable)ee);
            return false;
        }
    }

    protected boolean removeTargetHost(Entity e, boolean doUpdate) {
        if (this.targetHosts.remove(e) != null) {
            log.info("GeoDns removing reference to {}", (Object)e);
            if (doUpdate) {
                this.update();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() {
        ImmutableMap m;
        this.lastUpdate = System.currentTimeMillis();
        Map<Entity, HostGeoInfo> map = this.targetHosts;
        synchronized (map) {
            m = ImmutableMap.copyOf(this.targetHosts);
        }
        if (log.isDebugEnabled()) {
            log.debug("Full update of " + this + " (" + m.size() + " target hosts)");
        }
        LinkedHashMap entityIdToAddress = Maps.newLinkedHashMap();
        for (Map.Entry entry : m.entrySet()) {
            entityIdToAddress.put(((Entity)entry.getKey()).getId(), ((HostGeoInfo)entry.getValue()).address);
        }
        this.reconfigureService(new LinkedHashSet<HostGeoInfo>(m.values()));
        if (log.isDebugEnabled()) {
            log.debug("Targets being set as " + entityIdToAddress);
        }
        this.sensors().set(TARGETS, (Object)entityIdToAddress);
    }

    protected String inferHostname(Entity entity) {
        String hostname = (String)entity.getAttribute(Attributes.HOSTNAME);
        URI url = (URI)entity.getAttribute(Attributes.MAIN_URI);
        if (url != null) {
            try {
                URL u = url.toURL();
                String hostname2 = u.getHost();
                if (hostname == null) {
                    if (!this.entitiesWithoutGeoInfo.contains(entity)) {
                        log.warn("GeoDns " + this + " using URL {} to redirect to {} (HOSTNAME attribute is preferred, but not available)", (Object)url, (Object)entity);
                    }
                    hostname = hostname2;
                } else if (!hostname.equals(hostname2) && !this.entitiesWithoutGeoInfo.contains(entity)) {
                    log.warn("GeoDns " + this + " URL {} of " + entity + " does not match advertised HOSTNAME {}; using hostname, not URL", (Object)url, (Object)hostname);
                }
                if (u.getPort() > 0 && u.getPort() != 80 && u.getPort() != 443 && !this.entitiesWithoutGeoInfo.contains(entity)) {
                    log.warn("GeoDns " + this + " detected non-standard port in URL {} for {}; forwarding may not work", (Object)url, (Object)entity);
                }
            }
            catch (MalformedURLException e) {
                log.warn("Invalid URL {} for entity {} in {}", new Object[]{url, entity, this});
            }
        }
        return hostname;
    }

    protected String inferIp(Entity entity) {
        return (String)entity.getAttribute(Attributes.ADDRESS);
    }

    protected HostGeoInfo inferHostGeoInfo(String hostname, String ip) throws UnknownHostException {
        InetAddress addr;
        HostGeoInfo geoH;
        block12: {
            geoH = null;
            if (hostname != null) {
                try {
                    addr = Networking.getInetAddressWithFixedName((String)hostname);
                    geoH = HostGeoInfo.fromIpAddress((InetAddress)addr);
                }
                catch (RuntimeException e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    if (ip == null) {
                        if (log.isTraceEnabled()) {
                            log.trace("inferHostGeoInfo failing (" + Exceptions.getFirstInteresting((Throwable)e) + "): hostname=" + hostname + "; ip=" + ip);
                        }
                        throw e;
                    }
                    if (!log.isTraceEnabled()) break block12;
                    log.trace("GeoDns failed to infer GeoInfo from hostname {}; will try with IP {} ({})", new Object[]{hostname, ip, e});
                }
            }
        }
        if (ip != null) {
            if (geoH == null) {
                addr = Networking.getInetAddressWithFixedName((String)ip);
                geoH = HostGeoInfo.fromIpAddress((InetAddress)addr);
                if (log.isTraceEnabled()) {
                    log.trace("GeoDns inferred GeoInfo {} from ip {} (could not infer from hostname {})", new Object[]{geoH, ip, hostname});
                }
            } else {
                geoH = HostGeoInfo.create((String)ip, (String)geoH.displayName, (double)geoH.latitude, (double)geoH.longitude);
                if (log.isTraceEnabled()) {
                    log.trace("GeoDns inferred GeoInfo {} from hostname {}; switching it to ip {}", new Object[]{geoH, hostname, ip});
                }
            }
        } else if (log.isTraceEnabled()) {
            log.trace("GeoDns inferred GeoInfo {} from hostname {}", (Object)geoH, (Object)hostname);
        }
        return geoH;
    }

    public static class MemberTrackingPolicy
    extends AbstractMembershipTrackingPolicy {
        protected void onEntityEvent(AbstractMembershipTrackingPolicy.EventType type, Entity entity) {
            this.defaultHighlightAction(type, entity);
            ((AbstractGeoDnsServiceImpl)this.entity).refreshGroupMembership();
        }
    }
}

