/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.elasticstack.domain.ClaimType;
import org.jclouds.elasticstack.domain.Drive;

@Singleton
public class BaseDriveToMap
implements Function<Drive, Map<String, String>> {
    public Map<String, String> apply(Drive from) {
        Preconditions.checkNotNull((Object)from, (Object)"drive");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"name", (Object)from.getName());
        builder.put((Object)"size", (Object)(from.getSize() + ""));
        if (from.getClaimType() != ClaimType.EXCLUSIVE) {
            builder.put((Object)"claim:type", (Object)from.getClaimType().toString());
        }
        if (!from.getReaders().isEmpty()) {
            builder.put((Object)"readers", (Object)Joiner.on((char)' ').join(from.getReaders()));
        }
        if (!from.getTags().isEmpty()) {
            builder.put((Object)"tags", (Object)Joiner.on((char)' ').join(from.getTags()));
        }
        for (Map.Entry<String, String> entry : from.getUserMetadata().entrySet()) {
            builder.put((Object)("user:" + entry.getKey()), (Object)entry.getValue());
        }
        return builder.build();
    }
}

