/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.suppliers;

import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.Properties;
import org.apache.brooklyn.core.location.cloud.CloudLocationConfig;
import org.apache.brooklyn.location.jclouds.JCloudsPropertiesBuilder;
import org.apache.brooklyn.location.jclouds.JcloudsLocationConfig;
import org.apache.brooklyn.location.jclouds.domain.JcloudsContext;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.jclouds.Context;
import org.jclouds.ContextBuilder;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jclouds.sshj.config.SshjSshClientModule;

public class LinkContextSupplier
implements Supplier<Context> {
    private final ConfigBag conf;

    public LinkContextSupplier(ConfigBag conf) {
        this.conf = conf;
    }

    public Context get() {
        JcloudsContext jcloudsContext = (JcloudsContext)this.conf.get(JcloudsLocationConfig.LINK_CONTEXT);
        String identity = (String)MoreObjects.firstNonNull((Object)jcloudsContext.getIdentity(), (Object)this.conf.get(CloudLocationConfig.ACCESS_IDENTITY));
        String credential = (String)MoreObjects.firstNonNull((Object)jcloudsContext.getCredential(), (Object)this.conf.get(CloudLocationConfig.ACCESS_CREDENTIAL));
        return ContextBuilder.newBuilder((String)jcloudsContext.getProviderOrApi()).credentials(identity, credential).modules((Iterable)ImmutableList.of((Object)new SshjSshClientModule(), (Object)new SLF4JLoggingModule())).overrides(this.getProperties(jcloudsContext, this.conf)).build();
    }

    private Properties getProperties(JcloudsContext jcloudsContext, ConfigBag conf) {
        if (jcloudsContext.getProperties() != null && jcloudsContext.getProperties().isEmpty()) {
            Properties properties = new Properties();
            properties.putAll(jcloudsContext.getProperties());
            return properties;
        }
        return new JCloudsPropertiesBuilder(conf).setCommonJcloudsProperties().setCustomJcloudsProperties().setEndpointProperty().build();
    }
}

